/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PatternDialog
extends StatusDialog {
    private StringDialogField fPattern;
    private final String initialValue;

    public PatternDialog(Shell shell, String initialValue) {
        super(shell);
        this.initialValue = initialValue;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void createDialogFields() {
        this.fPattern = new StringDialogField();
        this.fPattern.setLabelText(PreferenceMessages.PatternDialog_patternLabel);
    }

    protected void createFieldListeners() {
        this.fPattern.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PatternDialog.this.updateStatus(PatternDialog.this.validate());
            }
        });
    }

    protected Control createDialogArea(Composite ancestor) {
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fPattern.doFillIntoGrid(parent, 3);
        GridData pathGridData = (GridData)this.fPattern.getTextControl(null).getLayoutData();
        pathGridData.grabExcessHorizontalSpace = true;
        pathGridData.widthHint = new PixelConverter((Control)ancestor).convertWidthInCharsToPixels(64);
        this.initializeFields();
        this.createFieldListeners();
        PatternDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void create() {
        super.create();
        this.fPattern.setFocus();
    }

    private void initializeFields() {
        this.fPattern.setText(this.initialValue);
        this.updateStatus(this.validate());
    }

    private IStatus validate() {
        String pattern = this.fPattern.getText().trim();
        StatusInfo info = new StatusInfo();
        if (pattern.length() == 0) {
            info.setError(PreferenceMessages.PatternDialog_ErrorPatternIsEmpty);
        }
        return info;
    }

    public String getPattern() {
        return this.fPattern.getText().trim();
    }
}

