/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.python.parser.ast.PythonImportFromStatement;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportExpression;
import org.eclipse.dltk.python.parser.ast.statements.IfStatement;
import org.eclipse.dltk.python.parser.ast.statements.SwitchStatement;
import org.eclipse.dltk.python.parser.ast.statements.WhileStatement;

public class PythonASTLevelVisitor
extends ASTVisitor {
    private List fAppropriateNodes = new ArrayList();
    int count = 0;
    boolean first = true;

    public List getNodes() {
        return this.fAppropriateNodes;
    }

    public boolean visit(Expression expression) throws Exception {
        if (!this.first) {
            this.fAppropriateNodes.add(expression);
        } else {
            this.first = false;
        }
        ++this.count;
        if (this.count > 1) {
            --this.count;
            return false;
        }
        return true;
    }

    public boolean visit(Statement statement) throws Exception {
        if (statement instanceof Argument) {
            return false;
        }
        if (statement instanceof Block) {
            return true;
        }
        if (!this.first) {
            this.fAppropriateNodes.add(statement);
        } else {
            this.first = false;
        }
        if (statement instanceof PythonImportExpression) {
            return false;
        }
        if (statement instanceof PythonImportFromStatement) {
            return false;
        }
        if (statement instanceof IfStatement) {
            return true;
        }
        if (statement instanceof WhileStatement) {
            return true;
        }
        if (statement instanceof SwitchStatement) {
            return true;
        }
        ++this.count;
        if (this.count > 1) {
            --this.count;
            return false;
        }
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        ++this.count;
        if (!this.first) {
            this.fAppropriateNodes.add(method);
        } else {
            this.first = false;
        }
        return this.count <= 1;
    }

    public boolean visit(ModuleDeclaration declaration) throws Exception {
        ++this.count;
        return this.count <= 1;
    }

    public boolean visit(TypeDeclaration typeDeclaration) throws Exception {
        ++this.count;
        if (!this.first) {
            this.fAppropriateNodes.add(typeDeclaration);
        } else {
            this.first = false;
        }
        return this.count <= 1;
    }
}

