/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.formatter.AbstractFormatterNodeBuilder;
import org.eclipse.dltk.formatter.FormatterBlockNode;
import org.eclipse.dltk.formatter.FormatterIndentedBlockNode;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstDeclaration;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultClause;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.ExceptionFilter;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.IASTVisitor;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractElseBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.AbstractPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ArrayBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BinaryOperationPinctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BracesNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.BracketsNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CallExpressionPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CallParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CaseBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CatchBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CatchParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ColonNodeWrapper;
import org.eclipse.dltk.javascript.formatter.internal.nodes.CommaPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ConditionalOperatorPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.DoLoopWhileWrapper;
import org.eclipse.dltk.javascript.formatter.internal.nodes.DoWhileBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ElseBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ElseIfBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ElseIfElseBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.EmptyArrayBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ExpressionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FinallyBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ForEmptySemicolonPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ForParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ForSemicolonPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBinaryOperationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBreakNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterCaseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterCatchClauseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterConstDeclarationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterContinueNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterDeleteStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterElseIfNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterElseKeywordNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterElseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterExceptionFilterNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterFinallyClauseNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterForInStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterForStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterFunctionNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterGetMethodNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterLabelledStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterNewExpressionNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterObjectInitializerNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterReturnStatementNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterRootNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterScriptNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterSetMethodNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterStringNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterSwitchNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterThrowNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterTypeofNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterUnaryOperationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterVariableDeclarationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterVoidExpressionNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterVoidOperatorNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterYieldOperatorNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionArgumentsParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionArgumentsPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionBodyBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionExpressionBodyBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FunctionNoArgumentsParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.GetItemArrayBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracketsConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IfConditionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.MethodInitializerPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.MultiLineObjectInitializerBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.OperationOrPunctuationNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ParensNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.PropertyExpressionPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.PropertyInitializerPunctuationConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SemicolonNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SingleLineObjectInitializerBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.StatementBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SwitchBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.SwitchConditionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.ThenBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.TrailingColonNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.TryBodyConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WhileBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WhileConditionParensConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WithBlockBracesConfiguration;
import org.eclipse.dltk.javascript.formatter.internal.nodes.WithConditionParensConfiguration;

public class FormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    public IFormatterContainerNode build(Script astRoot, final IFormatterDocument document) {
        FormatterRootNode root = new FormatterRootNode(document);
        this.start((IFormatterContainerNode)root);
        astRoot.visitAll(new IASTVisitor(){

            private void visit(ASTNode node) {
                ASTVisitor.visit(node, (IASTVisitor)this);
            }

            private void visit(Collection<? extends ASTNode> nodes) {
                ASTVisitor.visit(nodes, (IASTVisitor)this);
            }

            @Override
            public boolean visitArrayInitializer(ArrayInitializer node) {
                ArrayBracketsConfiguration configuration = node.getItems().size() > 0 ? new ArrayBracketsConfiguration(document) : new EmptyArrayBracketsConfiguration(document);
                this.processBrackets(node.getLB(), node.getRB(), node.getItems(), configuration);
                return true;
            }

            @Override
            public boolean visitBinaryOperation(BinaryOperation node) {
                FormatterBinaryOperationNode formatterNode = new FormatterBinaryOperationNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getLeftExpression());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getOperationPosition());
                this.processPunctuation(node.getOperationPosition(), node.getOperationText().length(), new BinaryOperationPinctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getRightExpression().sourceStart());
                this.visit(node.getRightExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitBooleanLiteral(BooleanLiteral node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitBreakStatement(BreakStatement node) {
                FormatterBreakNode formatterNode = new FormatterBreakNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getBreakKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getLabel() != null) {
                    this.visit(node.getLabel());
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitCallExpression(CallExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                this.processParens(node.getLP(), node.getRP(), node.getArguments(), (IParensConfiguration)new CallParensConfiguration(document), node.getCommas(), new CallExpressionPunctuationConfiguration());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            private void processTrailingColon(int colon, ASTNode keywordNode, ASTNode valueNode) {
                TrailingColonNode formatterNode = new TrailingColonNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, keywordNode));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (valueNode != null) {
                    this.visit(valueNode);
                }
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createCharNode(document, colon));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, colon);
            }

            @Override
            public boolean visitCaseClause(CaseClause node) {
                FormatterCaseNode caseNode = new FormatterCaseNode(document);
                caseNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)caseNode);
                this.visit(node.getCondition());
                caseNode.addChild((IFormatterNode)new ColonNodeWrapper(FormatterNodeBuilder.this.createCharNode(document, node.getColonPosition())));
                return this.processSwitchComponent(caseNode, node);
            }

            @Override
            public boolean visitDefaultClause(DefaultClause node) {
                FormatterCaseNode defaultNode = new FormatterCaseNode(document);
                defaultNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)defaultNode);
                defaultNode.addChild((IFormatterNode)new ColonNodeWrapper(FormatterNodeBuilder.this.createCharNode(document, node.getColonPosition())));
                return this.processSwitchComponent(defaultNode, node);
            }

            private boolean processSwitchComponent(FormatterCaseNode caseNode, SwitchComponent node) {
                if (node.getStatements().size() == 1 && node.getStatements().get(0) instanceof StatementBlock) {
                    CaseBracesConfiguration configuration = new CaseBracesConfiguration(document);
                    caseNode.setIndenting(false);
                    this.processBraces(node.getStatements().get(0), configuration);
                } else {
                    this.visit(node.getStatements());
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)caseNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitCatchClause(CatchClause node) {
                FormatterCatchClauseNode formatterNode = new FormatterCatchClauseNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getCatchKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<Expression> exceptionNodes = new ArrayList<Expression>();
                exceptionNodes.add(node.getException());
                if (node.getExceptionFilter() != null) {
                    exceptionNodes.add(node.getExceptionFilter());
                }
                this.processParens(node.getLP(), node.getRP(), exceptionNodes, (IParensConfiguration)new CatchParensConfiguration(document));
                this.processBraces(node.getStatement(), new CatchBracesConfiguration(document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            private void visitCombinedNodeList(List nodes, List punctuations, List configurations) {
                if (nodes.size() == 0) {
                    return;
                }
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, ((ASTNode)nodes.get(0)).sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                int i = 0;
                while (i < nodes.size()) {
                    Object item = nodes.get(i);
                    this.visit((ASTNode)item);
                    if (i < punctuations.size()) {
                        int position = (Integer)punctuations.get(i);
                        this.skipSpaces((IFormatterContainerNode)formatterNode, position);
                        this.processPunctuation(position, 1, (IPunctuationConfiguration)configurations.get(i));
                        this.skipSpaces((IFormatterContainerNode)formatterNode, ((ASTNode)nodes.get(i + 1)).sourceStart());
                    }
                    ++i;
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, ((ASTNode)nodes.get(nodes.size() - 1)).sourceEnd());
            }

            private void visitCombinedNodeList(List nodes, List punctuations, IPunctuationConfiguration configuration) {
                this.visitCombinedNodeList(nodes, punctuations, Collections.nCopies(punctuations.size(), configuration));
            }

            @Override
            public boolean visitCommaExpression(CommaExpression node) {
                this.visitCombinedNodeList(node.getItems(), node.getCommas(), new CommaPunctuationConfiguration());
                return true;
            }

            @Override
            public boolean visitConditionalOperator(ConditionalOperator node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getCondition());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getQuestionPosition());
                this.processPunctuation(node.getQuestionPosition(), 1, new ConditionalOperatorPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getTrueValue().sourceStart());
                this.visit(node.getTrueValue());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getColonPosition());
                this.processPunctuation(node.getColonPosition(), 1, new ConditionalOperatorPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getFalseValue().sourceStart());
                this.visit(node.getFalseValue());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitConstDeclaration(ConstDeclaration node) {
                FormatterConstDeclarationNode formatterNode = new FormatterConstDeclarationNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getConstKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visitCombinedNodeList(node.getConsts(), node.getCommas(), new CommaPunctuationConfiguration());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitContinueStatement(ContinueStatement node) {
                FormatterContinueNode formatterNode = new FormatterContinueNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getContinueKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getLabel() != null) {
                    this.visit(node.getLabel());
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            private void processOptionalSemicolon(IFormatterContainerNode formatterNode, ISemicolonStatement node) {
                int semicolonPosition = node.getSemicolonPosition();
                if (semicolonPosition > -1) {
                    FormatterNodeBuilder.this.checkedPop(formatterNode, semicolonPosition);
                    FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createSemicolonNode(document, semicolonPosition));
                } else {
                    FormatterNodeBuilder.this.checkedPop(formatterNode, node.sourceEnd());
                }
            }

            @Override
            public boolean visitDecimalLiteral(DecimalLiteral node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitDeleteStatement(DeleteStatement node) {
                FormatterDeleteStatementNode formatterNode = new FormatterDeleteStatementNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getDeleteKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.getExpression().sourceEnd());
                return true;
            }

            @Override
            public boolean visitDoWhileStatement(DoWhileStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getDoKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces(node.getBody(), new DoWhileBlockBracesConfiguration(document));
                formatterNode.addChild((IFormatterNode)new DoLoopWhileWrapper(FormatterNodeBuilder.this.createTextNode(document, node.getWhileKeyword())));
                this.processParens(node.getLP(), node.getRP(), node.getCondition(), (IParensConfiguration)new WhileConditionParensConfiguration(document));
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitEmptyExpression(EmptyExpression node) {
                return true;
            }

            @Override
            public boolean visitExceptionFilter(ExceptionFilter node) {
                FormatterExceptionFilterNode formatterNode = new FormatterExceptionFilterNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getIfKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitFinallyClause(FinallyClause node) {
                FormatterFinallyClauseNode formatterNode = new FormatterFinallyClauseNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getFinallyKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces(node.getStatement(), new FinallyBracesConfiguration(document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitForEachInStatement(ForEachInStatement node) {
                FormatterForInStatementNode formatterNode = new FormatterForInStatementNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getForKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
                nodes.add(node.getItem());
                nodes.add(node.getInKeyword());
                nodes.add(node.getIterator());
                this.processParens(node.getLP(), node.getRP(), nodes, (IParensConfiguration)new ForParensConfiguration(document));
                if (node.getBody() != null) {
                    this.processBraces(node.getBody(), new BlockBracesConfiguration(document));
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitForInStatement(ForInStatement node) {
                FormatterForInStatementNode formatterNode = new FormatterForInStatementNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getForKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
                nodes.add(node.getItem());
                nodes.add(node.getInKeyword());
                nodes.add(node.getIterator());
                this.processParens(node.getLP(), node.getRP(), nodes, (IParensConfiguration)new ForParensConfiguration(document));
                if (node.getBody() != null) {
                    this.processBraces(node.getBody(), new BlockBracesConfiguration(document));
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitForStatement(ForStatement node) {
                FormatterForStatementNode formatterNode = new FormatterForStatementNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getForKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                ArrayList<Expression> nodes = new ArrayList<Expression>();
                nodes.add(node.getInitial());
                nodes.add(node.getCondition());
                nodes.add(node.getStep());
                ArrayList<Integer> semicolons = new ArrayList<Integer>();
                semicolons.add(new Integer(node.getInitialSemicolonPosition()));
                semicolons.add(new Integer(node.getConditionalSemicolonPosition()));
                ArrayList<AbstractPunctuationConfiguration> semicolonConfigurations = new ArrayList<AbstractPunctuationConfiguration>();
                if (node.getCondition() instanceof EmptyExpression) {
                    semicolonConfigurations.add(new ForEmptySemicolonPunctuationConfiguration());
                } else {
                    semicolonConfigurations.add(new ForSemicolonPunctuationConfiguration());
                }
                if (node.getStep() instanceof EmptyExpression) {
                    semicolonConfigurations.add(new ForEmptySemicolonPunctuationConfiguration());
                } else {
                    semicolonConfigurations.add(new ForSemicolonPunctuationConfiguration());
                }
                this.processParens(node.getLP(), node.getRP(), nodes, (IParensConfiguration)new ForParensConfiguration(document), semicolons, semicolonConfigurations);
                if (node.getBody() != null) {
                    this.processBraces(node.getBody(), new BlockBracesConfiguration(document));
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitFunctionStatement(FunctionStatement node) {
                FormatterFunctionNode formatterNode = new FormatterFunctionNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getFunctionKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getName() != null) {
                    this.visit(node.getName());
                }
                AbstractParensConfiguration argsConfiguration = node.getArguments().size() == 0 ? new FunctionNoArgumentsParensConfiguration(document) : new FunctionArgumentsParensConfiguration(document);
                this.processParens(node.getLP(), node.getRP(), node.getArguments(), (IParensConfiguration)argsConfiguration, node.getArgumentCommas(), new FunctionArgumentsPunctuationConfiguration());
                boolean emptyBody = node.getBody() == null || node.getBody().getStatements() == null || node.getBody().getStatements().size() == 0;
                FunctionBodyBracesConfiguration bodyConfiguration = node.getName() != null ? new FunctionBodyBracesConfiguration(document, emptyBody) : new FunctionExpressionBodyBracesConfiguration(document, emptyBody);
                this.processBraces(node.getBody(), bodyConfiguration);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return false;
            }

            @Override
            public boolean visitGetArrayItemExpression(GetArrayItemExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getArray());
                ArrayList<Expression> nodes = new ArrayList<Expression>();
                nodes.add(node.getIndex());
                this.processBrackets(node.getLB(), node.getRB(), nodes, new GetItemArrayBracketsConfiguration(document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitGetMethod(GetMethod node) {
                FormatterGetMethodNode formatterNode = new FormatterGetMethodNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getGetKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getName());
                this.processParens(node.getLP(), node.getRP(), (ASTNode)null, (IParensConfiguration)new FunctionNoArgumentsParensConfiguration(document));
                boolean emptyBody = node.getBody() == null || node.getBody().getStatements() == null || node.getBody().getStatements().size() == 0;
                this.processBraces(node.getBody(), new FunctionBodyBracesConfiguration(document, emptyBody));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return false;
            }

            @Override
            public boolean visitIdentifier(Identifier node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return true;
            }

            private void processParens(int leftParen, int rightParen, ASTNode expression, IParensConfiguration configuration) {
                ParensNode parens = new ParensNode(document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (expression != null) {
                    this.skipSpaces((IFormatterContainerNode)parens, expression.sourceStart());
                    this.visit(expression);
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(document, rightParen));
            }

            private void processParens(int leftParen, int rightParen, List expressions, IParensConfiguration configuration, List punctuations, IPunctuationConfiguration punctuationConfiguration) {
                ParensNode parens = new ParensNode(document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!expressions.isEmpty()) {
                    ASTNode expression0 = (ASTNode)expressions.get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, expression0.sourceStart());
                }
                this.visitCombinedNodeList(expressions, punctuations, punctuationConfiguration);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(document, rightParen));
            }

            private void processParens(int leftParen, int rightParen, List expressions, IParensConfiguration configuration, List punctuations, List punctuationConfigurations) {
                ParensNode parens = new ParensNode(document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!expressions.isEmpty()) {
                    ASTNode expression0 = (ASTNode)expressions.get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, expression0.sourceStart());
                }
                this.visitCombinedNodeList(expressions, punctuations, punctuationConfigurations);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(document, rightParen));
            }

            private void processParens(int leftParen, int rightParen, List expressions, IParensConfiguration configuration) {
                ParensNode parens = new ParensNode(document, configuration);
                parens.setBegin(FormatterNodeBuilder.this.createCharNode(document, leftParen));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)parens);
                if (!expressions.isEmpty()) {
                    ASTNode expression0 = (ASTNode)expressions.get(0);
                    this.skipSpaces((IFormatterContainerNode)parens, expression0.sourceStart());
                }
                this.visitNodeList(expressions);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parens, rightParen);
                parens.setEnd(FormatterNodeBuilder.this.createCharNode(document, rightParen));
            }

            private void skipSpaces(IFormatterContainerNode formatterNode, int end) {
                int prev;
                int pos = prev = formatterNode.getEndOffset();
                while (pos < end && FormatterUtils.isSpace((char)document.charAt(pos))) {
                    ++pos;
                }
                if (pos > prev) {
                    formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, pos));
                }
            }

            private void processPunctuation(int position, int length, IPunctuationConfiguration configuration) {
                OperationOrPunctuationNode block = new OperationOrPunctuationNode(document, configuration);
                block.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, position, position + length));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)block);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)block, position + length);
            }

            private void processBraces(ASTNode node, IBracesConfiguration configuration) {
                if (node instanceof StatementBlock) {
                    StatementBlock block = (StatementBlock)node;
                    if (block.getLC() > -1 && block.getRC() > -1) {
                        BracesNode braces = new BracesNode(document, configuration);
                        braces.setBegin(FormatterNodeBuilder.this.createCharNode(document, block.getLC()));
                        FormatterNodeBuilder.this.push((IFormatterContainerNode)braces);
                        this.visitNodeList(block.getStatements());
                        FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)braces, block.getRC());
                        braces.setEnd(FormatterNodeBuilder.this.createCharNode(document, block.getRC()));
                    } else {
                        FormatterIndentedBlockNode formatter = new FormatterIndentedBlockNode(document, configuration.isIndenting());
                        formatter.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                        FormatterNodeBuilder.this.push((IFormatterContainerNode)formatter);
                        this.visitNodeList(block.getStatements());
                        FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatter, node.sourceEnd());
                    }
                } else {
                    FormatterIndentedBlockNode block = new FormatterIndentedBlockNode(document, configuration.isIndenting());
                    block.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                    FormatterNodeBuilder.this.push((IFormatterContainerNode)block);
                    this.visit(node);
                    FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)block, node.sourceEnd());
                }
            }

            private void processBrackets(int leftBracket, int rightBracket, List nodes, IBracketsConfiguration configuration) {
                BracketsNode brackets = new BracketsNode(document, configuration);
                brackets.setBegin(FormatterNodeBuilder.this.createCharNode(document, leftBracket));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)brackets);
                Iterator i = nodes.iterator();
                while (i.hasNext()) {
                    this.visit((ASTNode)i.next());
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)brackets, rightBracket);
                brackets.setEnd(FormatterNodeBuilder.this.createCharNode(document, rightBracket));
            }

            private void processElseIf(ASTNode node, IBracesConfiguration configuration) {
                BracesNode braces = new BracesNode(document, configuration);
                braces.setBegin(FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)braces);
                this.visit(node);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)braces, node.sourceEnd());
            }

            @Override
            public boolean visitIfStatement(IfStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getIfKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processParens(node.getLP(), node.getRP(), node.getCondition(), (IParensConfiguration)new IfConditionParensConfiguration(document));
                AbstractBracesConfiguration thenConfiguration = node.getElseStatement() != null ? new ThenBlockBracesConfiguration(document) : new BlockBracesConfiguration(document);
                this.processBraces(node.getThenStatement(), thenConfiguration);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.getThenStatement().sourceEnd());
                if (node.getElseStatement() != null) {
                    AbstractElseBracesConfiguration elseConfiguration;
                    boolean lineBreakBeforeElse = node.getThenStatement() == null || !(node.getThenStatement() instanceof StatementBlock);
                    FormatterElseNode elseNode = null;
                    if (node.getElseStatement() instanceof IfStatement) {
                        IfStatement elseStatement = (IfStatement)node.getElseStatement();
                        elseConfiguration = elseStatement.getElseStatement() == null ? new ElseIfBlockBracesConfiguration(document) : new ElseIfElseBlockBracesConfiguration(document);
                        elseNode = new FormatterElseIfNode(document, lineBreakBeforeElse);
                    } else {
                        elseConfiguration = new ElseBlockBracesConfiguration(document);
                        elseNode = new FormatterElseNode(document, lineBreakBeforeElse);
                    }
                    elseNode.addChild((IFormatterNode)new FormatterElseKeywordNode(document, node.getElseKeyword().sourceStart(), node.getElseKeyword().sourceEnd()));
                    FormatterNodeBuilder.this.push((IFormatterContainerNode)elseNode);
                    if (node.getElseStatement() instanceof IfStatement) {
                        this.processElseIf(node.getElseStatement(), elseConfiguration);
                    } else {
                        this.processBraces(node.getElseStatement(), elseConfiguration);
                    }
                    FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseNode, node.getElseStatement().sourceEnd());
                }
                return true;
            }

            @Override
            public boolean visitKeyword(Keyword node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitLabel(Label node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return true;
            }

            @Override
            public boolean visitLabelledStatement(LabelledStatement node) {
                FormatterLabelledStatementNode formatterNode = new FormatterLabelledStatementNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createEmptyTextNode(document, node.getLabel().sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processTrailingColon(node.getColonPosition(), node.getLabel(), null);
                this.processBraces(node.getStatement(), new CaseBracesConfiguration(document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitNewExpression(NewExpression node) {
                FormatterNewExpressionNode formatterNode = new FormatterNewExpressionNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getNewKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getObjectClass());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return false;
            }

            @Override
            public boolean visitNullExpression(NullExpression node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitObjectInitializer(ObjectInitializer node) {
                AbstractBracesConfiguration configuration = node.isMultiline() ? new MultiLineObjectInitializerBracesConfiguration(document) : new SingleLineObjectInitializerBracesConfiguration(document);
                FormatterObjectInitializerNode formatterNode = new FormatterObjectInitializerNode(document, configuration);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getLC(), node.getLC() + 1));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                List initializers = node.getInitializers();
                ArrayList<AbstractPunctuationConfiguration> commaConfigurations = new ArrayList<AbstractPunctuationConfiguration>();
                int i = 1;
                while (i < initializers.size()) {
                    Expression item = (Expression)initializers.get(i);
                    if (item instanceof Method) {
                        commaConfigurations.add(new MethodInitializerPunctuationConfiguration());
                    } else {
                        commaConfigurations.add(new PropertyInitializerPunctuationConfiguration());
                    }
                    ++i;
                }
                this.visitCombinedNodeList(node.getInitializers(), node.getCommas(), commaConfigurations);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd() - 1);
                formatterNode.setEnd(FormatterNodeBuilder.this.createTextNode(document, node.getRC(), node.getRC() + 1));
                return true;
            }

            @Override
            public boolean visitParenthesizedExpression(ParenthesizedExpression node) {
                this.processParens(node.getLP(), node.getRP(), node.getExpression(), (IParensConfiguration)new ExpressionParensConfiguration(document));
                return true;
            }

            @Override
            public boolean visitPropertyExpression(PropertyExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getObject());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getDotPosition());
                this.processPunctuation(node.getDotPosition(), 1, new PropertyExpressionPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getProperty().sourceStart());
                this.visit(node.getProperty());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return false;
            }

            @Override
            public boolean visitPropertyInitializer(PropertyInitializer node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getName());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getColon());
                this.processPunctuation(node.getColon(), 1, new PropertyInitializerPunctuationConfiguration());
                this.skipSpaces((IFormatterContainerNode)formatterNode, node.getValue().sourceStart());
                this.visit(node.getValue());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.getValue().sourceStart());
                return true;
            }

            @Override
            public boolean visitRegExpLiteral(RegExpLiteral node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitReturnStatement(ReturnStatement node) {
                FormatterReturnStatementNode formatterNode = new FormatterReturnStatementNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getReturnKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getValue() != null) {
                    this.visit(node.getValue());
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return false;
            }

            @Override
            public boolean visitScript(Script node) {
                FormatterScriptNode scriptNode = new FormatterScriptNode(document);
                FormatterNodeBuilder.this.push((IFormatterContainerNode)scriptNode);
                this.visitNodeList(node.getStatements());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)scriptNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitSetMethod(SetMethod node) {
                FormatterSetMethodNode formatterNode = new FormatterSetMethodNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getSetKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getName());
                this.processParens(node.getLP(), node.getRP(), node.getArgument(), (IParensConfiguration)new FunctionArgumentsParensConfiguration(document));
                boolean emptyBody = node.getBody() == null || node.getBody().getStatements() == null || node.getBody().getStatements().size() == 0;
                this.processBraces(node.getBody(), new FunctionBodyBracesConfiguration(document, emptyBody));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return false;
            }

            @Override
            public boolean visitStatementBlock(StatementBlock node) {
                this.processBraces(node, new StatementBlockBracesConfiguration(document));
                return true;
            }

            @Override
            public boolean visitStringLiteral(StringLiteral node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitSwitchStatement(SwitchStatement node) {
                FormatterSwitchNode switchNode = new FormatterSwitchNode(document);
                switchNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getSwitchKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)switchNode);
                this.processParens(node.getLP(), node.getRP(), node.getCondition(), (IParensConfiguration)new SwitchConditionParensConfiguration(document));
                BracesNode braces = new BracesNode(document, new SwitchBracesConfiguration(document));
                braces.setBegin(FormatterNodeBuilder.this.createCharNode(document, node.getLC()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)braces);
                for (SwitchComponent component : node.getCaseClauses()) {
                    this.visit(component);
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)braces, node.getRC());
                braces.setEnd(FormatterNodeBuilder.this.createCharNode(document, node.getRC()));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)switchNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitThisExpression(ThisExpression node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return false;
            }

            @Override
            public boolean visitThrowStatement(ThrowStatement node) {
                FormatterThrowNode formatterNode = new FormatterThrowNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getThrowKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (node.getException() != null) {
                    this.visit(node.getException());
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitTryStatement(TryStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getTryKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processBraces(node.getBody(), new TryBodyConfiguration(document));
                ArrayList<Statement> nodes = new ArrayList<Statement>();
                nodes.addAll(node.getCatches());
                if (node.getFinally() != null) {
                    nodes.add(node.getFinally());
                }
                this.visitNodeList(nodes);
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitTypeOfExpression(TypeOfExpression node) {
                FormatterTypeofNode formatterNode = new FormatterTypeofNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getTypeOfKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitUnaryOperation(UnaryOperation node) {
                FormatterUnaryOperationNode formatterNode = new FormatterUnaryOperationNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                if (!node.isPostfix()) {
                    FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getOperationPosition(), node.getOperationPosition() + node.getOperationText().length()));
                    this.skipSpaces((IFormatterContainerNode)formatterNode, node.getExpression().sourceStart());
                }
                this.visit(node.getExpression());
                if (node.isPostfix()) {
                    this.skipSpaces((IFormatterContainerNode)formatterNode, node.getOperationPosition());
                    FormatterNodeBuilder.this.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getOperationPosition(), node.getOperationPosition() + node.getOperationText().length()));
                }
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitVariableDeclaration(VariableDeclaration node) {
                FormatterVariableDeclarationNode formatterNode = new FormatterVariableDeclarationNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getVarKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visitCombinedNodeList(node.getVariables(), node.getCommas(), new CommaPunctuationConfiguration());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitVoidExpression(VoidExpression node) {
                FormatterVoidExpressionNode formatterNode = new FormatterVoidExpressionNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return false;
            }

            @Override
            public boolean visitWhileStatement(WhileStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getWhileKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processParens(node.getLP(), node.getRP(), node.getCondition(), (IParensConfiguration)new WhileConditionParensConfiguration(document));
                if (node.getBody() != null) {
                    this.processBraces(node.getBody(), new WhileBlockBracesConfiguration(document));
                }
                this.processOptionalSemicolon((IFormatterContainerNode)formatterNode, node);
                return true;
            }

            @Override
            public boolean visitWithStatement(WithStatement node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getWithKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.processParens(node.getLP(), node.getRP(), node.getExpression(), (IParensConfiguration)new WithConditionParensConfiguration(document));
                this.processBraces(node.getStatement(), new WithBlockBracesConfiguration(document));
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            private void visitNodeList(List<? extends ASTNode> nodes) {
                int i = 0;
                while (i < nodes.size()) {
                    this.visit(nodes.get(i));
                    ++i;
                }
            }

            @Override
            public boolean visitVoidOperator(VoidOperator node) {
                FormatterVoidOperatorNode formatterNode = new FormatterVoidOperatorNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getVoidKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitYieldOperator(YieldOperator node) {
                FormatterYieldOperatorNode formatterNode = new FormatterYieldOperatorNode(document);
                formatterNode.setBegin(FormatterNodeBuilder.this.createTextNode(document, node.getVoidKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getExpression());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitXmlLiteral(XmlLiteral node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return true;
            }

            @Override
            public boolean visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
                FormatterBlockNode formatter = new FormatterBlockNode(document);
                formatter.addChild((IFormatterNode)FormatterNodeBuilder.this.createTextNode(document, node.getDefaultKeyword()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatter);
                this.visit(node.getXmlKeyword());
                this.visit(node.getNamespaceKeyword());
                this.visit(node.getValue());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatter, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return true;
            }

            @Override
            public boolean visitAsteriskExpression(AsteriskExpression node) {
                FormatterStringNode strNode = new FormatterStringNode(document, node);
                FormatterNodeBuilder.this.addChild((IFormatterNode)strNode);
                return true;
            }

            @Override
            public boolean visitGetLocalNameExpression(GetLocalNameExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getNamespace());
                this.visit(node.getLocalName());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitGetAllChildrenExpression(GetAllChildrenExpression node) {
                FormatterBlockNode formatterNode = new FormatterBlockNode(document);
                formatterNode.addChild((IFormatterNode)FormatterNodeBuilder.this.createEmptyTextNode(document, node.sourceStart()));
                FormatterNodeBuilder.this.push((IFormatterContainerNode)formatterNode);
                this.visit(node.getObject());
                this.visit(node.getProperty());
                FormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)formatterNode, node.sourceEnd());
                return true;
            }

            @Override
            public boolean visitUnknownNode(ASTNode node) {
                return false;
            }
        });
        this.checkedPop((IFormatterContainerNode)root, document.getLength());
        return root;
    }

    private IFormatterTextNode createTextNode(IFormatterDocument document, ASTNode node) {
        return this.createTextNode(document, node.sourceStart(), node.sourceEnd());
    }

    private IFormatterTextNode createCharNode(IFormatterDocument document, int startPos) {
        return this.createTextNode(document, startPos, startPos + 1);
    }

    private IFormatterTextNode createEmptyTextNode(IFormatterDocument document, int pos) {
        return this.createTextNode(document, pos, pos);
    }

    private IFormatterTextNode createSemicolonNode(IFormatterDocument document, int offset) {
        return new SemicolonNode(document, offset);
    }
}

