/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.wizards.CapabilityConfigurationPage;
import org.eclipse.dltk.ui.wizards.IProjectWizardLastPage;
import org.eclipse.dltk.ui.wizards.ProjectMetadataBackup;
import org.eclipse.dltk.ui.wizards.ProjectWizardFirstPage;
import org.eclipse.dltk.ui.wizards.ProjectWizardUtils;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public abstract class ProjectWizardSecondPage
extends CapabilityConfigurationPage
implements IProjectWizardLastPage {
    private final ProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private ProjectMetadataBackup projectFileBackup = null;
    private Boolean fIsAutobuild;

    public ProjectWizardSecondPage(ProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fIsAutobuild = null;
    }

    public ProjectWizardFirstPage getFirstPage() {
        return this.fFirstPage;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    protected void changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (ProjectWizardSecondPage.this.fIsAutobuild == null) {
                            ProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                        }
                        ProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_initialize, 70);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            ProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            IBuildpathEntry[] entries = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(".buildpath").exists()) {
                    IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getScriptNature());
                    BuildpathDetector detector = this.createBuildpathDetector(monitor, toolkit);
                    entries = detector.getBuildpath();
                } else {
                    monitor.worked(20);
                }
            } else if (this.fFirstPage.isSrc()) {
                IFolder folder;
                IPreferenceStore store = this.getPreferenceStore();
                Path srcPath = new Path(store.getString("com.xore.dltk.ui.wizards.srcFoldersSrcName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    monitor.worked(10);
                }
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    monitor.worked(10);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
                cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                cpEntries.addAll(ProjectWizardUtils.getDefaultBuildpathEntry(this.fFirstPage));
                entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
                cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll(ProjectWizardUtils.getDefaultBuildpathEntry(this.fFirstPage));
                entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
                monitor.worked(20);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(DLTKCore.create((IProject)this.fCurrProject), entries, false);
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 30));
        }
        finally {
            monitor.done();
        }
    }

    protected BuildpathDetector createBuildpathDetector(IProgressMonitor monitor, IDLTKLanguageToolkit toolkit) throws CoreException {
        BuildpathDetector detector = new BuildpathDetector(this.fCurrProject, toolkit);
        detector.detectBuildpath((IProgressMonitor)new SubProgressMonitor(monitor, 20));
        return detector;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return this.fFirstPage.getLocationURI();
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.projectFileBackup = new ProjectMetadataBackup();
        this.projectFileBackup.backup(projectLocation, new String[]{".project", ".buildpath"});
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        if (this.projectFileBackup != null) {
            this.projectFileBackup.restore(projectLocation, monitor);
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureScriptProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (!this.fKeepContent && DLTKCore.DEBUG) {
                System.err.println("Add compiler compilance options here...");
            }
            this.configureEnvironment(monitor);
            this.postConfigureProject();
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    protected void configureEnvironment(IProgressMonitor monitor) throws CoreException {
        String nature;
        IInterpreterInstall projectInterpreter = this.fFirstPage.getInterpreter();
        if (projectInterpreter == null && (nature = this.getScriptNature()) != null) {
            projectInterpreter = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry(nature, this.fFirstPage.getInterpreterEnvironment().getId()));
        }
        if (projectInterpreter != null) {
            IEnvironment interpreterEnv = projectInterpreter.getEnvironment();
            if (!this.fFirstPage.getEnvironment().equals(interpreterEnv)) {
                EnvironmentManager.setEnvironmentId((IProject)this.fCurrProject, (String)interpreterEnv.getId(), (boolean)false);
            } else {
                EnvironmentManager.setEnvironmentId((IProject)this.fCurrProject, null, (boolean)false);
            }
            ProjectWizardUtils.reuseInterpreterLibraries(this.fCurrProject, projectInterpreter, monitor);
        } else {
            EnvironmentManager.setEnvironmentId((IProject)this.fCurrProject, null, (boolean)false);
        }
    }

    protected void postConfigureProject() throws CoreException {
    }

    protected void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    public void performCancel() {
        this.removeProject();
    }

    public IProject getCurrProject() {
        return this.fCurrProject;
    }
}

