/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ui.IWorkingSet;

public class BasicElementLabels {
    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return BasicElementLabels.markLTR(label);
    }

    public static String getPathLabel(File file) {
        return BasicElementLabels.markLTR(file.getAbsolutePath(), "");
    }

    public static String getFilePattern(String name) {
        return BasicElementLabels.markLTR(name, "*.?");
    }

    public static String getURLPart(String name) {
        return BasicElementLabels.markLTR(name, ":@?-");
    }

    public static String getResourceName(IResource resource) {
        return BasicElementLabels.markLTR(resource.getName());
    }

    public static String getResourceName(String resourceName) {
        return BasicElementLabels.markLTR(resourceName);
    }

    public static String getFileName(ISourceModule typeRoot) {
        return BasicElementLabels.markLTR(typeRoot.getElementName());
    }

    public static String getJavaElementName(String name) {
        return BasicElementLabels.markLTR(name, "<>()?,{}");
    }

    public static String getJavaCodeString(String string) {
        return BasicElementLabels.markLTR(string, "<>()?,{}+-*!%=");
    }

    public static String getVersionName(String name) {
        return BasicElementLabels.markLTR(name);
    }

    public static String getWorkingSetLabel(IWorkingSet set) {
        return BasicElementLabels.markLTR(set.getLabel(), "");
    }

    private static String markLTR(String string) {
        return string;
    }

    private static String markLTR(String string, String additionalDelimiters) {
        return string;
    }
}

