/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class BuildPathSupport {
    public static final String InterpreterEnvironment_PREF_PAGE_ID = "org.eclipse.dltk.debug.ui.preferences.InterpreterPreferencePage";

    private BuildPathSupport() {
    }

    public static void modifyBuildpathEntry(Shell shell, IBuildpathEntry newEntry, String[] changedAttributes, IScriptProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        if (containerPath != null) {
            BuildPathSupport.updateContainerBuildpath(jproject, containerPath, newEntry, changedAttributes, monitor);
        } else {
            BuildPathSupport.updateProjectBuildpath(shell, jproject, newEntry, changedAttributes, monitor);
        }
    }

    public static void modifyBuildpathEntry(Shell shell, IBuildpathEntry newEntry, IScriptProject jproject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        BuildPathSupport.modifyBuildpathEntry(shell, newEntry, null, jproject, containerPath, monitor);
    }

    private static void updateContainerBuildpath(IScriptProject project, IPath containerPath, IBuildpathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws CoreException {
        IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)containerPath, (IScriptProject)project);
        if (container == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", 4, "Container " + containerPath + " cannot be resolved", null));
        }
        IBuildpathEntry[] entries = container.getBuildpathEntries(project);
        IBuildpathEntry[] newEntries = new IBuildpathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            IBuildpathEntry curr = entries[i];
            newEntries[i] = curr.getEntryKind() == newEntry.getEntryKind() && curr.getPath().equals((Object)newEntry.getPath()) ? BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, project) : curr;
            ++i;
        }
        BuildPathSupport.requestContainerUpdate(project, container, newEntries);
        monitor.worked(1);
    }

    private static IBuildpathEntry getUpdatedEntry(IBuildpathEntry currEntry, IBuildpathEntry updatedEntry, String[] updatedAttributes, IScriptProject jproject) {
        if (updatedAttributes == null) {
            return updatedEntry;
        }
        BPListElement currElem = BPListElement.createFromExisting(currEntry, jproject);
        BPListElement newElem = BPListElement.createFromExisting(updatedEntry, jproject);
        int i = 0;
        while (i < updatedAttributes.length) {
            String attrib = updatedAttributes[i];
            currElem.setAttribute(attrib, newElem.getAttribute(attrib));
            ++i;
        }
        return currElem.getBuildpathEntry();
    }

    public static void requestContainerUpdate(IScriptProject jproject, IBuildpathContainer container, IBuildpathEntry[] newEntries) throws CoreException {
        IPath containerPath = container.getPath();
        UpdatedBuildpathContainer updatedContainer = new UpdatedBuildpathContainer(container, newEntries);
        BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            initializer.requestBuildpathContainerUpdate(containerPath, jproject, (IBuildpathContainer)updatedContainer);
            if (DLTKCore.DEBUG) {
                System.err.println("BuildPathSupport: Add user library preference page container");
            }
        }
    }

    private static void updateProjectBuildpath(Shell shell, IScriptProject jproject, IBuildpathEntry newEntry, String[] changedAttributes, IProgressMonitor monitor) throws ModelException {
        IBuildpathEntry[] oldBuildpath = jproject.getRawBuildpath();
        int nEntries = oldBuildpath.length;
        ArrayList<IBuildpathEntry> newEntries = new ArrayList<IBuildpathEntry>(nEntries + 1);
        int entryKind = newEntry.getEntryKind();
        IPath archivePath = newEntry.getPath();
        boolean found = false;
        int i = 0;
        while (i < nEntries) {
            IBuildpathEntry curr = oldBuildpath[i];
            if (curr.getEntryKind() == entryKind && curr.getPath().equals((Object)archivePath)) {
                newEntries.add(BuildPathSupport.getUpdatedEntry(curr, newEntry, changedAttributes, jproject));
                found = true;
            } else {
                newEntries.add(curr);
            }
            ++i;
        }
        if (!found) {
            if (!BuildPathSupport.putArchiveOnBuildpathDialog(shell)) {
                return;
            }
            newEntries.add(newEntry);
        }
        IBuildpathEntry[] newBuildpath = newEntries.toArray(new IBuildpathEntry[newEntries.size()]);
        jproject.setRawBuildpath(newBuildpath, monitor);
    }

    private static boolean putArchiveOnBuildpathDialog(final Shell shell) {
        if (shell == null) {
            return false;
        }
        final boolean[] result = new boolean[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = NewWizardMessages.BuildPathSupport_putoncpdialog_title;
                String message = NewWizardMessages.BuildPathSupport_putoncpdialog_message;
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
            }
        });
        return result[0];
    }

    private static class UpdatedBuildpathContainer
    implements IBuildpathContainer {
        private IBuildpathEntry[] fNewEntries;
        private IBuildpathContainer fOriginal;

        public UpdatedBuildpathContainer(IBuildpathContainer original, IBuildpathEntry[] newEntries) {
            this.fNewEntries = newEntries;
            this.fOriginal = original;
        }

        public IBuildpathEntry[] getBuildpathEntries(IScriptProject project) {
            return this.fNewEntries;
        }

        public String getDescription(IScriptProject project) {
            return this.fOriginal.getDescription(project);
        }

        public int getKind() {
            return this.fOriginal.getKind();
        }

        public IPath getPath() {
            return this.fOriginal.getPath();
        }

        public IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
            return this.fOriginal.getBuiltinProvider(project);
        }
    }
}

