/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.DeltaProcessor;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;

public class DeleteProjectFragmentOperation
extends ModelOperation {
    int updateResourceFlags;
    int updateModelFlags;

    public DeleteProjectFragmentOperation(IProjectFragment root, int updateResourceFlags, int updateModelFlags) {
        super(root);
        this.updateResourceFlags = updateResourceFlags;
        this.updateModelFlags = updateModelFlags;
    }

    protected void executeOperation() throws ModelException {
        IProjectFragment root = (IProjectFragment)this.getElementToProcess();
        IBuildpathEntry rootEntry = root.getRawBuildpathEntry();
        DeltaProcessor deltaProcessor = ModelManager.getModelManager().getDeltaProcessor();
        if (deltaProcessor.oldRoots == null) {
            deltaProcessor.oldRoots = new HashMap();
        }
        if ((this.updateModelFlags & 2) != 0) {
            this.updateProjectBuildpath(rootEntry.getPath(), root.getScriptProject(), deltaProcessor.oldRoots);
        }
        if ((this.updateModelFlags & 4) != 0) {
            this.updateReferringProjectBuildpaths(rootEntry.getPath(), root.getScriptProject(), deltaProcessor.oldRoots);
        }
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.deleteResource(root, rootEntry);
        }
    }

    protected void deleteResource(IProjectFragment root, IBuildpathEntry rootEntry) throws ModelException {
        char[][] exclusionPatterns = ((BuildpathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (rootEntry.getEntryKind() != 3 || exclusionPatterns == null) {
            try {
                rootResource.delete(this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 2) {
                    IPath path = proxy.requestFullPath();
                    if (DeleteProjectFragmentOperation.this.prefixesOneOf(path, nestedFolders)) {
                        return !DeleteProjectFragmentOperation.this.equalsOneOf(path, nestedFolders);
                    }
                    proxy.requestResource().delete(DeleteProjectFragmentOperation.this.updateResourceFlags, DeleteProjectFragmentOperation.this.progressMonitor);
                    return false;
                }
                proxy.requestResource().delete(DeleteProjectFragmentOperation.this.updateResourceFlags, DeleteProjectFragmentOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        this.setAttribute("hasModifiedResource", "true");
    }

    protected void updateReferringProjectBuildpaths(IPath rootPath, IScriptProject projectOfRoot, Map oldRoots) throws ModelException {
        IScriptModel model = this.getModel();
        IScriptProject[] projects = model.getScriptProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IScriptProject project = projects[i];
            if (!project.equals(projectOfRoot)) {
                this.updateProjectBuildpath(rootPath, project, oldRoots);
            }
            ++i;
        }
    }

    protected void updateProjectBuildpath(IPath rootPath, IScriptProject project, Map oldRoots) throws ModelException {
        oldRoots.put(project, project.getProjectFragments());
        IBuildpathEntry[] buildpath = project.getRawBuildpath();
        IBuildpathEntry[] newBuildpath = null;
        int cpLength = buildpath.length;
        int newCPIndex = -1;
        int j = 0;
        while (j < cpLength) {
            IBuildpathEntry entry = buildpath[j];
            if (rootPath.equals((Object)entry.getPath())) {
                if (newBuildpath == null) {
                    newBuildpath = new IBuildpathEntry[cpLength - 1];
                    System.arraycopy(buildpath, 0, newBuildpath, 0, j);
                    newCPIndex = j;
                }
            } else if (newBuildpath != null) {
                newBuildpath[newCPIndex++] = entry;
            }
            ++j;
        }
        if (newBuildpath != null) {
            if (newCPIndex < newBuildpath.length) {
                IBuildpathEntry[] iBuildpathEntryArray = newBuildpath;
                newBuildpath = new IBuildpathEntry[newCPIndex];
                System.arraycopy(iBuildpathEntryArray, 0, newBuildpath, 0, newCPIndex);
            }
            project.setRawBuildpath(newBuildpath, this.progressMonitor);
        }
    }

    protected IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IProjectFragment root = (IProjectFragment)this.getElementToProcess();
        if (root == null || !root.exists()) {
            return new ModelStatus(969, root);
        }
        IResource resource = root.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            return new ModelStatus(995, root);
        }
        return ModelStatus.VERIFIED_OK;
    }
}

