/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.dltk.core.environment.IEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimePerformanceMonitor {
    public static final String IOREAD = "IO Read";
    public static final String IOWRITE = "IO Write";
    public static boolean RUNTIME_PERFORMANCE = true;
    private static Map<String, Map<String, DataEntry>> entries = new HashMap<String, Map<String, DataEntry>>();

    public static synchronized void updateData(String language, String kind, long time, long value) {
        Map<String, DataEntry> attrs = RuntimePerformanceMonitor.internalGetEntries(language);
        DataEntry entry = attrs.get(kind);
        if (entry == null) {
            entry = new DataEntry();
            attrs.put(kind, entry);
        }
        ++entry.count;
        entry.total += value;
        entry.time += time;
    }

    public static synchronized void updateData(String language, String kind, long time, long value, IEnvironment env) {
        if (env != null) {
            RuntimePerformanceMonitor.updateData(language, String.valueOf(kind) + " " + env.getName(), time, value);
        }
        RuntimePerformanceMonitor.updateData(language, kind, time, value);
    }

    private static synchronized Map<String, DataEntry> internalGetEntries(String language) {
        Map<String, DataEntry> attrs = entries.get(language);
        if (attrs == null) {
            attrs = new HashMap<String, DataEntry>();
            entries.put(language, attrs);
        }
        return attrs;
    }

    public static Map<String, DataEntry> getEntries(String language) {
        HashMap<String, DataEntry> copy = new HashMap<String, DataEntry>();
        Map<String, DataEntry> map = RuntimePerformanceMonitor.internalGetEntries(language);
        for (Map.Entry<String, DataEntry> i : map.entrySet()) {
            DataEntry value = i.getValue();
            DataEntry decopy = new DataEntry();
            decopy.count = value.count;
            decopy.total = value.total;
            decopy.time = value.time;
            copy.put(i.getKey(), decopy);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, DataEntry>> getAllEntries() {
        HashSet keySet = null;
        Class<RuntimePerformanceMonitor> clazz = RuntimePerformanceMonitor.class;
        synchronized (RuntimePerformanceMonitor.class) {
            keySet = new HashSet(entries.keySet());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            HashMap<String, Map<String, DataEntry>> result = new HashMap<String, Map<String, DataEntry>>();
            for (String key : keySet) {
                result.put(key, RuntimePerformanceMonitor.getEntries(key));
            }
            return result;
        }
    }

    public static PerformanceNode begin() {
        PerformanceNode node = new PerformanceNode();
        node.renew();
        return node;
    }

    public static synchronized void clear() {
        entries.clear();
    }

    public static class DataEntry {
        long count = 0L;
        long total = 0L;
        long time = 0L;

        public long getCount() {
            return this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static class PerformanceNode {
        private long start;
        private long end;

        public long done() {
            this.end = System.currentTimeMillis();
            return this.get();
        }

        public long get() {
            return this.end - this.start;
        }

        public void renew() {
            this.start = System.currentTimeMillis();
        }

        public void done(String natureId, String string, long value) {
            RuntimePerformanceMonitor.updateData(natureId, string, this.done(), value);
        }

        public void done(String natureId, String kind, long value, IEnvironment environment) {
            RuntimePerformanceMonitor.updateData(natureId, kind, this.done(), value, environment);
        }
    }
}

