/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.checks;

import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.internal.core.search.mixin.TclMixinModel;
import org.eclipse.dltk.tcl.internal.core.search.mixin.model.TclProc;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.validators.ITclCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndefinedProcCheck
implements ITclCheck {
    @Override
    public void checkCommands(List<TclCommand> commands, final ITclErrorReporter reporter, Map<String, String> options, final IScriptProject project, ISourceLineTracker sourceLineTracker) {
        TclParserUtils.traverse(commands, (TclVisitor)new TclVisitor(){

            public boolean visit(TclCommand command) {
                if (command.getDefinition() != null) {
                    return true;
                }
                TclArgument name = command.getName();
                if (!(name instanceof StringArgument)) {
                    return true;
                }
                String qName = command.getQualifiedName();
                if (qName == null) {
                    return true;
                }
                IMixinElement[] elements = TclMixinModel.getInstance().getMixin(project).find(qName.replaceAll("::", IMixinRequestor.MIXIN_NAME_SEPARATOR));
                String realName = ((StringArgument)name).getValue();
                if (realName.indexOf("::") != -1) {
                    realName = realName.substring(realName.lastIndexOf("::") + 2);
                }
                boolean found = false;
                int i = 0;
                while (i < elements.length) {
                    Object[] objects = elements[i].getAllObjects();
                    int j = 0;
                    while (j < objects.length) {
                        if (objects[j] instanceof TclProc) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!found) {
                    reporter.report(10000, "Call to undefined proc:" + realName, null, name.getStart(), name.getEnd(), 1);
                }
                return true;
            }
        });
    }
}

