/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.internal.validators.CheckPreferenceManager;
import org.eclipse.dltk.tcl.internal.validators.ChecksExtensionManager;
import org.eclipse.dltk.tcl.internal.validators.TclBuildContext;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.dltk.tcl.validators.ITclCheck;
import org.eclipse.dltk.tcl.validators.TclValidatorsCore;
import org.eclipse.emf.common.util.EList;

public class TclCheckBuildParticipant
implements IBuildParticipant {
    public static boolean TESTING_DO_CHECKS = true;
    public static boolean TESTING_DO_OPERATIONS = true;
    private final NamespaceScopeProcessor processor;
    private final ChecksExtensionManager.TclCheckInfo[] checks = ChecksExtensionManager.getInstance().getChecks();
    private final CheckPreferenceManager preferences = new CheckPreferenceManager(TclValidatorsCore.getDefault().getPluginPreferences());

    public TclCheckBuildParticipant(IScriptProject project) {
        this.processor = DefinitionManager.getInstance().getCoreProcessor();
    }

    public void build(IBuildContext context) throws CoreException {
        try {
            if (!TESTING_DO_OPERATIONS) {
                return;
            }
            ISourceModule module = context.getSourceModule();
            TclErrorCollector errorCollector = new TclErrorCollector();
            TclModule tclModule = TclBuildContext.getStatements(context);
            EList commands = tclModule.getStatements();
            ISourceLineTracker lineTracker = context.getLineTracker();
            if (TESTING_DO_CHECKS) {
                int i = 0;
                while (i < this.checks.length) {
                    ChecksExtensionManager.TclCheckInfo info = this.checks[i];
                    if (this.preferences.isEnabled(info) && info.getCommandName() == null) {
                        ITclCheck check = info.getCheck();
                        IScriptProject scriptProject = module.getScriptProject();
                        check.checkCommands((List<TclCommand>)commands, (ITclErrorReporter)errorCollector, this.preferences.getOptions(info), scriptProject, lineTracker);
                    }
                    ++i;
                }
            }
            IProblemReporter reporter = context.getProblemReporter();
            errorCollector.reportAll(reporter, lineTracker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

