/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.dltk.internal.testing.Messages;
import org.eclipse.dltk.internal.testing.model.TestCaseElement;
import org.eclipse.dltk.internal.testing.model.TestCategoryElement;
import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.model.TestSuiteElement;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestCategoryElement;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestElementContainer;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.testing.model.ITestSuiteElement;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider {
    private final TestRunnerViewPart fTestRunnerPart;
    private final int fLayoutMode;

    public TestSessionLabelProvider(TestRunnerViewPart testRunnerPart, int layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
    }

    private String getSimpleLabel(Object element) {
        if (element instanceof ITestCaseElement) {
            ITestCaseElement caseElement = (ITestCaseElement)element;
            return this.getTestRunnerUI().getTestCaseLabel(caseElement, false);
        }
        if (element instanceof ITestSuiteElement) {
            return ((ITestSuiteElement)element).getSuiteTypeName();
        }
        if (element instanceof ITestCategoryElement) {
            return ((ITestCategoryElement)element).getCategoryName();
        }
        return element.toString();
    }

    public String getText(Object element) {
        String runnerDisplayName;
        ITestElementContainer parent;
        if (this.fLayoutMode == 0 && element instanceof ITestCaseElement) {
            return this.getTestRunnerUI().getTestCaseLabel((ITestCaseElement)element, true);
        }
        String label = this.getSimpleLabel(element);
        if (this.fLayoutMode == 1 && element instanceof ITestElement && !(element instanceof ITestCategoryElement) && ((parent = ((ITestElement)element).getParentContainer()) instanceof ITestRunSession || parent instanceof ITestCategoryElement) && (runnerDisplayName = this.getTestRunnerUI().getDisplayName()) != null) {
            return Messages.format(DLTKTestingMessages.TestSessionLabelProvider_testName_JUnitVersion, new Object[]{label, runnerDisplayName});
        }
        return label;
    }

    private final ITestRunnerUI getTestRunnerUI() {
        return this.fTestRunnerPart.getTestRunnerUI();
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            if (testCaseElement.isIgnored()) {
                return this.fTestRunnerPart.fTestIgnoredIcon;
            }
            TestElement.Status status = testCaseElement.getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fTestIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fTestRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isFailure()) {
                switch (status.getFailedCode()) {
                    case 0: {
                        return this.fTestRunnerPart.fTestAbortedIcon;
                    }
                    case 2: {
                        return this.fTestRunnerPart.fTestBlockedIcon;
                    }
                    case 1: {
                        return this.fTestRunnerPart.fTestSkippedIcon;
                    }
                    case 3: {
                        return this.fTestRunnerPart.fTestUnknownIcon;
                    }
                }
                return this.fTestRunnerPart.fTestFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fSuiteIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fSuiteRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isFailure()) {
                switch (status.getFailedCode()) {
                    case 0: {
                        return this.fTestRunnerPart.fSuiteAbortedIcon;
                    }
                    case 2: {
                        return this.fTestRunnerPart.fSuiteBlockedIcon;
                    }
                    case 1: {
                        return this.fTestRunnerPart.fSuiteSkippedIcon;
                    }
                    case 3: {
                        return this.fTestRunnerPart.fSuiteUnknownIcon;
                    }
                }
                return this.fTestRunnerPart.fSuiteFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestCategoryElement) {
            TestElement.Status status = ((TestCategoryElement)element).getStatus();
            if (status.isNotRun()) {
                return this.fTestRunnerPart.fCategoryIcon;
            }
            if (status.isRunning()) {
                return this.fTestRunnerPart.fCategoryRunningIcon;
            }
            if (status.isError()) {
                return this.fTestRunnerPart.fCategoryErrorIcon;
            }
            if (status.isFailure()) {
                switch (status.getFailedCode()) {
                    case 0: {
                        return this.fTestRunnerPart.fCategoryAbortedIcon;
                    }
                    case 2: {
                        return this.fTestRunnerPart.fCategoryBlockedIcon;
                    }
                    case 1: {
                        return this.fTestRunnerPart.fCategorySkippedIcon;
                    }
                    case 3: {
                        return this.fTestRunnerPart.fCategoryUnknownIcon;
                    }
                }
                return this.fTestRunnerPart.fCategoryFailIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fCategoryOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }
}

