/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class IfStatement
extends Statement {
    private ASTNode fCondition;
    private Statement fThenStatement;
    private ASTNode fElseStatement;

    public IfStatement(int start, int end) {
        super(start, end);
    }

    public IfStatement(Statement condition, Statement thenStatement, Statement elseStatement) {
        this.fCondition = condition;
        this.fThenStatement = thenStatement;
        this.fElseStatement = elseStatement;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            if (this.fThenStatement != null) {
                this.fThenStatement.traverse(pVisitor);
            }
            if (this.fElseStatement != null) {
                this.fElseStatement.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 2005;
    }

    public void acceptElse(ASTNode elseStatement) {
        this.fElseStatement = elseStatement;
        if (this.fElseStatement != null) {
            this.setEnd(this.fElseStatement.sourceEnd());
        }
    }

    public void acceptThen(Statement statement) {
        this.fThenStatement = statement;
    }

    public void acceptCondition(ASTNode condition) {
        this.fCondition = condition;
    }

    public ASTNode getElse() {
        return this.fElseStatement;
    }

    public Statement getThen() {
        return this.fThenStatement;
    }

    public ASTNode getCondition() {
        return this.fCondition;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("if: ");
        if (this.fCondition != null) {
            this.fCondition.printNode(output);
        }
        if (this.fThenStatement != null) {
            if (!(this.fThenStatement instanceof Block)) {
                output.indent();
            }
            this.fThenStatement.printNode(output);
            if (!(this.fThenStatement instanceof Block)) {
                output.dedent();
            }
        }
        if (this.fElseStatement != null) {
            output.formatPrintLn("else:");
            if (!(this.fElseStatement instanceof Block)) {
                output.indent();
            }
            this.fElseStatement.printNode(output);
            if (!(this.fElseStatement instanceof Block)) {
                output.dedent();
            }
        }
    }
}

