/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.JavaMembers;
import com.xored.org.mozilla.javascript.MemberBox;
import com.xored.org.mozilla.javascript.NativeJavaMethod;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceFactory;
import org.eclipse.dltk.internal.javascript.typeinference.UnknownReference;

public class NativeObjectReference
extends UnknownReference {
    public static HashMap TYPES = new HashMap(){
        private static final long serialVersionUID = 1L;

        public Object get(Object name) {
            Object o = super.get(name);
            if (o == null) {
                String str = (String)name;
                int i = str.lastIndexOf(".");
                if (i >= 0) {
                    str = str.substring(i + 1);
                }
                o = str;
            }
            return o;
        }
    };
    private final Class clz;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        TYPES.put("double", "number");
        TYPES.put("float", "number");
        TYPES.put("int", "number");
        TYPES.put("long", "number");
    }

    public NativeObjectReference(String paramOrVarName, Class clz) {
        super(paramOrVarName, false);
        this.clz = clz;
    }

    protected void createChilds() {
        block32: {
            try {
                JavaMembers javaMembers = new JavaMembers(null, this.clz);
                Hashtable fieldAndMethods = javaMembers.getFieldAndMethods(false);
                Hashtable members = javaMembers.getMembers(false);
                if (members == null) break block32;
                Iterator iterator = members.entrySet().iterator();
                while (iterator.hasNext()) {
                    UnknownReference uref = null;
                    Map.Entry entry = iterator.next();
                    String key = (String)entry.getKey();
                    if (entry.getValue() instanceof NativeJavaMethod) {
                        MemberBox[] methods = ((NativeJavaMethod)entry.getValue()).getMethods();
                        int i = 0;
                        while (i < methods.length) {
                            Class[] argTypes;
                            if (methods[i].getReturnType() != null) {
                                Class clss = methods[i].getReturnType();
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("java.lang.String");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clss == clazz) {
                                    uref = ReferenceFactory.createStringReference(key);
                                } else {
                                    Class<?> clazz2 = class$1;
                                    if (clazz2 == null) {
                                        try {
                                            clazz2 = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clss == clazz2 || clss == Boolean.TYPE) {
                                        uref = ReferenceFactory.createBooleanReference(key);
                                    } else {
                                        Class<?> clazz3 = class$3;
                                        if (clazz3 == null) {
                                            try {
                                                clazz3 = Class.forName("java.util.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz3.isAssignableFrom(clss)) {
                                            uref = ReferenceFactory.createDateReference(key);
                                        } else {
                                            Class<?> clazz4 = class$4;
                                            if (clazz4 == null) {
                                                try {
                                                    clazz4 = Class.forName("java.lang.Number");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz4.isAssignableFrom(clss) || clss.isPrimitive()) {
                                                uref = ReferenceFactory.createNumberReference(key);
                                            } else if (clss.isArray()) {
                                                uref = ReferenceFactory.createArrayReference(key);
                                            }
                                        }
                                    }
                                }
                            }
                            if (uref == null) {
                                uref = new UnknownReference(key, false);
                            }
                            if ((argTypes = methods[i].getArgTypes()) != null) {
                                char[][] names = new char[argTypes.length][];
                                int j = 0;
                                while (j < argTypes.length) {
                                    String name;
                                    if (argTypes[j].isArray()) {
                                        name = String.valueOf((String)TYPES.get(argTypes[j].getComponentType().getName())) + "[]";
                                        names[j] = name.toCharArray();
                                    } else {
                                        name = (String)TYPES.get(argTypes[j].getName());
                                        names[j] = name.toCharArray();
                                    }
                                    ++j;
                                }
                                uref.setParameterNames(names);
                            }
                            uref.setFunctionRef();
                            this.setChild(key, uref);
                            ++i;
                        }
                        continue;
                    }
                    this.setChild(key, new UnknownReference(key, false));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

