/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.debug.Debugger;

public class DefaultRhinoRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        Context cx = Context.enter();
        if (args.length > 1) {
            String host = args[1];
            String porg = args[2];
            try {
                Socket s = new Socket(host, Integer.parseInt(porg));
                DBGPDebugger debugger = new DBGPDebugger(s, args[0], args[3], cx);
                debugger.start();
                cx.setDebugger((Debugger)debugger, null);
                ScriptableObject scope = cx.initStandardObjects();
                this.extraInit((Scriptable)scope, cx);
                DBGPDebugger dBGPDebugger = debugger;
                synchronized (dBGPDebugger) {
                    try {
                        debugger.isInited = true;
                        debugger.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IllegalStateException();
                    }
                }
                try {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    cx.setGeneratingDebug(true);
                    cx.setOptimizationLevel(-1);
                    cx.evaluateReader((Scriptable)scope, (Reader)new FileReader(args[0]), new File(args[0]).getAbsolutePath(), 0, null);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                debugger.notifyEnd();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ScriptableObject scope = cx.initStandardObjects();
            try {
                cx.evaluateReader((Scriptable)scope, (Reader)new FileReader(args[0]), args[0], 0, null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void extraInit(Scriptable scope, Context cx) {
    }
}

