/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text.hyperlink;

import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.internal.ui.text.hyperlink.RubyRequireHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubyRequireHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String REQUIRE = "require";
    static /* synthetic */ Class class$0;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion inputRegion, boolean canShowMultipleHyperlinks) {
        block4: {
            if (inputRegion == null || textViewer == null) {
                return null;
            }
            try {
                IHyperlink link;
                IDocument doc = textViewer.getDocument();
                int lineNumber = doc.getLineOfOffset(inputRegion.getOffset());
                IRegion region = doc.getLineInformation(lineNumber);
                String line = doc.get(region.getOffset(), region.getLength());
                if (line != null && line.length() != 0 && (link = this.checkLine(region.getOffset(), line)) != null) {
                    return new IHyperlink[]{link};
                }
            }
            catch (BadLocationException e) {
                if (!RubyPlugin.DUMP_EXCEPTIONS_TO_CONSOLE) break block4;
                e.printStackTrace();
            }
        }
        return null;
    }

    public IHyperlink checkLine(int offset, String line) {
        int begin = 0;
        int end = line.length();
        while (begin < end && Character.isWhitespace(line.charAt(begin))) {
            ++begin;
        }
        while (begin < end && Character.isWhitespace(line.charAt(end - 1))) {
            --end;
        }
        if (begin + REQUIRE.length() < end && line.startsWith(REQUIRE, begin)) {
            char quote;
            begin += REQUIRE.length();
            while (begin < end && Character.isWhitespace(line.charAt(begin))) {
                ++begin;
            }
            if (begin + 2 < end && line.charAt(begin) == '(' && line.charAt(end - 1) == ')') {
                ++begin;
                --end;
                while (begin < end && Character.isWhitespace(line.charAt(begin))) {
                    ++begin;
                }
                while (begin < end && Character.isWhitespace(line.charAt(end - 1))) {
                    --end;
                }
            }
            if (begin + 2 < end && ((quote = line.charAt(begin)) == '\'' || quote == '\"') && line.charAt(end - 1) == quote) {
                return this.createLink(offset, line, ++begin, --end);
            }
        }
        return null;
    }

    protected IHyperlink createLink(int offset, String line, int begin, int end) {
        ITextEditor editor;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((editor = (ITextEditor)this.getAdapter(clazz)) != null) {
            String requiredFile = line.substring(begin, end);
            Region region = new Region(offset + begin, end - begin);
            return new RubyRequireHyperlink(requiredFile, (IRegion)region, editor);
        }
        return null;
    }
}

