/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.launching;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.launching.AbstractInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.ruby.internal.launching.RubyInterpreterRunner;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;
import org.eclipse.dltk.utils.DeployHelper;

public class RubyGenericInstall
extends AbstractInterpreterInstall {
    private static final String prefix = "#### DLTK RUBY BUILTINS ####";
    private static final int prefixLength = "#### DLTK RUBY BUILTINS ####".length();
    private HashMap sources = null;

    public RubyGenericInstall(IInterpreterInstallType type, String id) {
        super(type, id);
    }

    public IInterpreterRunner getInterpreterRunner(String mode) {
        IInterpreterRunner runner = super.getInterpreterRunner(mode);
        if (runner != null) {
            return runner;
        }
        if (mode.equals("run")) {
            return new RubyInterpreterRunner((IInterpreterInstall)this);
        }
        return null;
    }

    private void initialize() {
        this.sources = new HashMap();
        String content = new BuiltinsHelper().execute("");
        int start = 0;
        int pos = content.indexOf(prefix, start);
        while (pos >= 0) {
            int nl = content.indexOf(10, pos);
            String filename = content.substring(pos + prefixLength, nl).trim();
            String data = "";
            pos = content.indexOf(prefix, nl + 1);
            data = pos != -1 ? content.substring(nl + 1, pos) : content.substring(nl + 1);
            String prev = (String)this.sources.get(filename);
            if (prev != null) {
                data = String.valueOf(prev) + data;
            }
            this.sources.put(filename, data);
        }
    }

    public String getBuiltinModuleContent(String name) {
        if (this.sources == null) {
            this.initialize();
        }
        return (String)this.sources.get(name);
    }

    public String[] getBuiltinModules() {
        if (this.sources == null) {
            this.initialize();
        }
        return this.sources.keySet().toArray(new String[this.sources.size()]);
    }

    public String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    public class BuiltinsHelper {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String execute(String command) {
            File builder = null;
            try {
                IPath path = DeployHelper.deploy((Plugin)RubyLaunchingPlugin.getDefault(), (String)"scripts");
                builder = path.append("builtin.rb").toFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
            String[] cmdLine = new String[]{RubyGenericInstall.this.getInstallLocation().getAbsolutePath(), builder.getAbsolutePath(), command};
            BufferedReader input = null;
            OutputStreamWriter output = null;
            try {
                String string;
                block10: {
                    try {
                        Process process = DebugPlugin.exec((String[])cmdLine, null);
                        input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        StringBuffer sb = new StringBuffer();
                        String line = null;
                        while (true) {
                            if ((line = input.readLine()) == null) {
                                string = sb.toString();
                                Object var9_13 = null;
                                if (output == null) break block10;
                                break;
                            }
                            sb.append(String.valueOf(line) + "\n");
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        if (output != null) {
                            output.close();
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    output.close();
                }
                if (input == null) return string;
                input.close();
                return string;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

