/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.codeassist.ISelectionEngine;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.core.ICallHierarchyFactory;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.BasicDLTKExtensionManager;
import org.eclipse.dltk.internal.core.ClassBasedDLTKExtensionManager;
import org.eclipse.dltk.internal.core.NewInstanceClassBasedDLTKExtensionManager;

public class DLTKLanguageManager {
    private static final String LANGUAGE_EXTPOINT = "org.eclipse.dltk.core.language";
    private static final String SOURCE_ELEMENT_PARSERS_EXTPOINT = "org.eclipse.dltk.core.sourceElementParsers";
    private static final String SOURCE_PARSERS_EXTPOINT = "org.eclipse.dltk.core.sourceParsers";
    private static final String PROBLEM_FACTORY_EXTPOINT = "org.eclipse.dltk.core.problemFactory";
    private static final String COMPLETION_ENGINE_EXTPOINT = "org.eclipse.dltk.core.completionEngine";
    private static final String SELECTION_ENGINE_EXTPOINT = "org.eclipse.dltk.core.selectionEngine";
    private static final String SEARCH_EXTPOINT = "org.eclipse.dltk.core.search";
    private static final String CALLHIERARCHY_EXTPOINT = "org.eclipse.dltk.core.callHierarchy";
    private static ClassBasedDLTKExtensionManager instance = new ClassBasedDLTKExtensionManager("org.eclipse.dltk.core.language");
    private static ClassBasedDLTKExtensionManager sourceElementParsersManager = new NewInstanceClassBasedDLTKExtensionManager("org.eclipse.dltk.core.sourceElementParsers");
    private static ClassBasedDLTKExtensionManager problemFactoryManager = new ClassBasedDLTKExtensionManager("org.eclipse.dltk.core.problemFactory");
    private static ClassBasedDLTKExtensionManager selectionEngineManager = new NewInstanceClassBasedDLTKExtensionManager("org.eclipse.dltk.core.selectionEngine");
    private static ClassBasedDLTKExtensionManager completionEngineManager = new NewInstanceClassBasedDLTKExtensionManager("org.eclipse.dltk.core.completionEngine");
    private static ClassBasedDLTKExtensionManager sourceParsersManager = new NewInstanceClassBasedDLTKExtensionManager("org.eclipse.dltk.core.sourceParsers");
    private static ClassBasedDLTKExtensionManager searchManager = new ClassBasedDLTKExtensionManager("org.eclipse.dltk.core.search");
    private static ClassBasedDLTKExtensionManager callHierarchyManager = new ClassBasedDLTKExtensionManager("org.eclipse.dltk.core.callHierarchy");

    public static IDLTKLanguageToolkit getLanguageToolkit(String natureId) throws CoreException {
        return (IDLTKLanguageToolkit)instance.getObject(natureId);
    }

    private static IDLTKLanguageToolkit findAppropriateToolkitByObject(Object object) {
        BasicDLTKExtensionManager.ElementInfo[] elementInfos = instance.getElementInfos();
        int j = 0;
        while (j < elementInfos.length) {
            IDLTKLanguageToolkit toolkit = (IDLTKLanguageToolkit)instance.getInitObject(elementInfos[j]);
            if (object instanceof IResource) {
                if (toolkit.validateSourceModule((IResource)object).getSeverity() == 0) {
                    return toolkit;
                }
            } else if (object instanceof IPath) {
                if (toolkit.validateSourceModule((IPath)object).getSeverity() == 0) {
                    return toolkit;
                }
            } else {
                return null;
            }
            ++j;
        }
        return null;
    }

    public static boolean hasScriptNature(IProject project) {
        return instance.findScriptNature(project) != null;
    }

    public static IDLTKLanguageToolkit getLanguageToolkit(IModelElement element) throws CoreException {
        return (IDLTKLanguageToolkit)instance.getObject(element);
    }

    public static IDLTKLanguageToolkit findToolkit(IResource resource) {
        return DLTKLanguageManager.findAppropriateToolkitByObject(resource);
    }

    public static IDLTKLanguageToolkit findToolkit(IPath path) {
        return DLTKLanguageManager.findAppropriateToolkitByObject(path);
    }

    public static ISourceElementParser getSourceElementParser(String nature) throws CoreException {
        return (ISourceElementParser)sourceElementParsersManager.getObject(nature);
    }

    public static ISourceElementParser getSourceElementParser(IModelElement element) throws CoreException {
        return (ISourceElementParser)sourceElementParsersManager.getObject(element);
    }

    public static IProblemFactory getProblemFactory(String natureID) throws CoreException {
        IProblemFactory factory = (IProblemFactory)problemFactoryManager.getObject(natureID);
        if (factory != null) {
            return factory;
        }
        return new DefaultProblemFactory();
    }

    public static IProblemFactory getProblemFactory(IModelElement element) throws CoreException {
        IProblemFactory factory = (IProblemFactory)problemFactoryManager.getObject(element);
        if (factory != null) {
            return factory;
        }
        return new DefaultProblemFactory();
    }

    public static ICompletionEngine getCompletionEngine(String natureID) throws CoreException {
        return (ICompletionEngine)completionEngineManager.getObject(natureID);
    }

    public static ISelectionEngine getSelectionEngine(String natureID) throws CoreException {
        return (ISelectionEngine)selectionEngineManager.getObject(natureID);
    }

    public static ISourceParser getSourceParser(String natureID) throws CoreException {
        return (ISourceParser)sourceParsersManager.getObject(natureID);
    }

    public static ISourceParser getSourceParserLower(String natureID) throws CoreException {
        return (ISourceParser)sourceParsersManager.getObjectLower(natureID);
    }

    public static DLTKSearchParticipant createSearchParticipant(String natureID) {
        DLTKSearchParticipant participant;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (participant = factory.createSearchParticipant()) != null) {
            return participant;
        }
        return new DLTKSearchParticipant();
    }

    private static ISearchFactory getSearchFactory(String natureId) {
        return (ISearchFactory)searchManager.getObject(natureId);
    }

    public static MatchLocator createMatchLocator(String natureID, SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, SubProgressMonitor subProgressMonitor) {
        MatchLocator locator;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (locator = factory.createMatchLocator(pattern, requestor, scope, subProgressMonitor)) != null) {
            return locator;
        }
        return new MatchLocator(pattern, requestor, scope, (IProgressMonitor)subProgressMonitor);
    }

    public static SourceIndexerRequestor createSourceRequestor(String natureID) {
        SourceIndexerRequestor requestor;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (requestor = factory.createSourceRequestor()) != null) {
            return requestor;
        }
        return new SourceIndexerRequestor();
    }

    public static IMatchLocatorParser createMatchParser(String natureID, MatchLocator matchLocator) {
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null) {
            return factory.createMatchParser(matchLocator);
        }
        return null;
    }

    public static ICalleeProcessor createCalleeProcessor(String natureID, IMethod member, IProgressMonitor progressMonitor, IDLTKSearchScope scope) {
        ICallHierarchyFactory factory = DLTKLanguageManager.getCallHierarchyFactory(natureID);
        if (factory != null) {
            ICalleeProcessor processor = factory.createCalleeProcessor(member, progressMonitor, scope);
            return processor;
        }
        return null;
    }

    private static ICallHierarchyFactory getCallHierarchyFactory(String natureId) {
        return (ICallHierarchyFactory)callHierarchyManager.getObject(natureId);
    }

    public static ICallProcessor createCallProcessor(String natureID) {
        ICallHierarchyFactory factory = DLTKLanguageManager.getCallHierarchyFactory(natureID);
        if (factory != null) {
            return factory.createCallProcessor();
        }
        return null;
    }
}

