/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import org.eclipse.dltk.ruby.internal.ui.text.RubyIndenter;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPreferenceInterpreter;
import org.eclipse.dltk.ui.text.util.AutoEditUtils;
import org.eclipse.dltk.ui.text.util.ITabPreferencesProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RubyAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;
    private RubyPreferenceInterpreter prefs;
    private RubyIndenter indenter;

    public RubyAutoEditStrategy(IPreferenceStore store, String part) {
        this.fPartitioning = part;
        this.prefs = new RubyPreferenceInterpreter(store);
        this.indenter = new RubyIndenter(part, this.prefs);
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        if (AutoEditUtils.isNewLineInsertionCommand((IDocument)d, (DocumentCommand)c)) {
            if (this.prefs.isSmartMode()) {
                this.handleSmartNewLine(d, c);
            } else {
                super.customizeDocumentCommand(d, c);
            }
        } else if (c.text != null && c.text.length() > 1 && this.prefs.isSmartPaste()) {
            this.handleSmartPaste(d, c);
        } else if (AutoEditUtils.isSingleCharactedInsertionOrReplaceCommand((DocumentCommand)c)) {
            this.handeSingleCharacterTyped(d, c);
        }
    }

    private static void installStuff(Document document) {
        String[] types = new String[]{"__ruby_string", "__ruby_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RubyPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__ruby_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeStuff(Document document) {
        document.setDocumentPartitioner("__ruby_partitioning", null);
    }

    private void reindent(IDocument d, DocumentCommand c) {
        try {
            if (AutoEditUtils.getRegionType((IDocument)d, (String)this.fPartitioning, (int)c.offset) != "__dftl_partition_content_type") {
                return;
            }
            int line = d.getLineOfOffset(c.offset);
            String newIndent = this.indenter.calculateChangedLineIndent(d, line, false, c.offset, c);
            if (newIndent == null) {
                return;
            }
            String curIndent = AutoEditUtils.getLineIndent((IDocument)d, (int)line);
            if (AutoEditUtils.getIndentVisualLength((ITabPreferencesProvider)this.prefs, (String)curIndent) < AutoEditUtils.getIndentVisualLength((ITabPreferencesProvider)this.prefs, (String)newIndent)) {
                return;
            }
            d.replace(d.getLineOffset(line), curIndent.length(), newIndent);
            c.offset += newIndent.length() - curIndent.length();
        }
        catch (BadLocationException badLocationException) {}
    }

    /*
     * Exception decompiling
     */
    private void autoClose(IDocument d, DocumentCommand c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean handleSmartTabulation(IDocument d, DocumentCommand c) {
        String resultIndent;
        int lineHome;
        int lineStart;
        block11: {
            int currentIndentSize;
            int resultIndentSize;
            int lineLength;
            int tabOffset;
            block10: {
                int lineEnd;
                int lineIndex;
                block8: {
                    block9: {
                        if (c.offset == -1 || d.getLength() == 0) {
                            return false;
                        }
                        try {
                            tabOffset = c.offset;
                            lineIndex = d.getLineOfOffset(tabOffset);
                            lineStart = d.getLineOffset(lineIndex);
                            lineLength = d.getLineLength(lineIndex);
                            lineEnd = lineStart + lineLength;
                            lineHome = AutoEditUtils.findEndOfWhiteSpace((IDocument)d, (int)lineStart, (int)lineEnd);
                            if (tabOffset < lineHome || lineHome >= lineEnd) break block8;
                            if (this.prefs.getTabAlwaysIndents()) break block9;
                            return false;
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    c.offset = lineHome;
                    c.length = tabOffset - lineHome;
                    c.text = String.valueOf(this.prefs.getIndent()) + d.get(lineHome, tabOffset - lineHome);
                    return true;
                }
                String line = d.get(lineStart, lineLength);
                resultIndent = this.indenter.forciblyCalculateLineIndent(d, lineIndex, lineStart, line, -1);
                resultIndentSize = AutoEditUtils.getIndentVisualLength((ITabPreferencesProvider)this.prefs, (String)resultIndent);
                if (lineHome != lineEnd) break block10;
                int visualColumn = AutoEditUtils.calculateVisualLength((ITabPreferencesProvider)this.prefs, (IDocument)d, (int)lineStart, (int)lineLength, (int)lineStart, (int)tabOffset);
                if (visualColumn >= resultIndentSize) {
                    return false;
                }
                break block11;
            }
            if (tabOffset >= lineHome || (currentIndentSize = AutoEditUtils.calculateVisualLength((ITabPreferencesProvider)this.prefs, (IDocument)d, (int)lineStart, (int)lineLength, (int)lineStart, (int)lineHome)) != resultIndentSize) break block11;
            c.offset = lineHome;
            c.length = 0;
            c.text = null;
            return true;
        }
        c.offset = lineStart;
        c.length = lineHome - lineStart;
        c.text = resultIndent;
        return true;
    }

    private void handleSmartPaste(IDocument d, DocumentCommand c) {
        try {
            int firstSourceIndentedLineIndex;
            int targetLineIndexToCalculateCommonIndentationFor;
            int firstTargetLineLength;
            int firstTargetLineEnd;
            int firstTargetLineHome;
            boolean reindentFirstInsertedLine;
            boolean insertionPointInsideIndent;
            int pasteOffset = c.offset;
            int firstLineIndex = d.getLineOfOffset(pasteOffset);
            int firstLineStart = d.getLineOffset(firstLineIndex);
            int firstLineLength = d.getLineLength(firstLineIndex);
            int firstLineHome = AutoEditUtils.findEndOfWhiteSpace((IDocument)d, (int)firstLineStart, (int)(firstLineStart + firstLineLength));
            Document temp = new Document(String.valueOf(d.get(0, pasteOffset)) + c.text);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            RubyAutoEditStrategy.installStuff(temp);
            int numberOfPastedLines = temp.getNumberOfLines() - firstLineIndex;
            boolean bl = insertionPointInsideIndent = pasteOffset <= firstLineHome;
            if (insertionPointInsideIndent && numberOfPastedLines > 1) {
                temp.replace(firstLineStart, pasteOffset - firstLineStart, "");
                pasteOffset = c.offset = firstLineStart;
            }
            boolean bl2 = reindentFirstInsertedLine = pasteOffset <= (firstTargetLineHome = AutoEditUtils.findEndOfWhiteSpace((IDocument)d, (int)firstLineStart, (int)(firstTargetLineEnd = firstLineStart + (firstTargetLineLength = d.getLineLength(firstLineIndex)))));
            if (reindentFirstInsertedLine) {
                targetLineIndexToCalculateCommonIndentationFor = firstLineIndex;
                firstSourceIndentedLineIndex = firstLineIndex;
            } else {
                targetLineIndexToCalculateCommonIndentationFor = firstLineIndex + 1 < d.getNumberOfLines() ? firstLineIndex + 1 : firstLineIndex;
                firstSourceIndentedLineIndex = firstLineIndex + 1;
            }
            if (!reindentFirstInsertedLine && numberOfPastedLines > 1) {
                this.collapseIndentationOfFirstPastedLine(temp, pasteOffset, firstLineIndex, firstLineStart);
            }
            int sourceIndentSizeToRemove = this.determineAmountOfIndentationToRemove(temp, firstSourceIndentedLineIndex);
            int indentSizeToApplyToPastedText = this.determineIndentationToApplyToPastedText(d, targetLineIndexToCalculateCommonIndentationFor);
            this.fixupIndentation(temp, firstSourceIndentedLineIndex, numberOfPastedLines, -sourceIndentSizeToRemove + indentSizeToApplyToPastedText);
            temp.stopRewriteSession(session);
            RubyAutoEditStrategy.removeStuff(temp);
            c.text = temp.get(pasteOffset, temp.getLength() - pasteOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void collapseIndentationOfFirstPastedLine(Document temp, int pasteOffset, int firstLineIndex, int firstLineStart) throws BadLocationException {
        int firstSourceLineLength = temp.getLineLength(firstLineIndex);
        int firstSourceLineEnd = firstLineStart + firstSourceLineLength;
        temp.get(firstLineStart, firstSourceLineLength);
        int firstSourceLineInsertionHome = AutoEditUtils.findEndOfWhiteSpace((IDocument)temp, (int)pasteOffset, (int)firstSourceLineEnd);
        if (AutoEditUtils.atEndOfLine((IDocument)temp, (int)firstSourceLineInsertionHome, (int)firstSourceLineEnd)) {
            temp.replace(pasteOffset, firstSourceLineInsertionHome - pasteOffset, "");
        } else if (firstSourceLineInsertionHome > pasteOffset) {
            temp.replace(pasteOffset, firstSourceLineInsertionHome - pasteOffset, " ");
        }
    }

    private int determineAmountOfIndentationToRemove(Document temp, int firstSourceIndentedLineIndex) throws BadLocationException {
        int sourceIndentSizeToRemove = Integer.MAX_VALUE;
        int lineIndex = firstSourceIndentedLineIndex;
        while (lineIndex < temp.getNumberOfLines()) {
            int length;
            int start = temp.getLineOffset(lineIndex);
            int home = AutoEditUtils.findEndOfWhiteSpace((IDocument)temp, (int)start, (int)(start + (length = temp.getLineLength(lineIndex))));
            if (!AutoEditUtils.atEndOfLine((IDocument)temp, (int)home, (int)(start + length))) {
                int indent = AutoEditUtils.calculateVisualLength((ITabPreferencesProvider)this.prefs, (IDocument)temp, (int)start, (int)length, (int)start, (int)home);
                sourceIndentSizeToRemove = Math.min(sourceIndentSizeToRemove, indent);
            }
            ++lineIndex;
        }
        return sourceIndentSizeToRemove;
    }

    private int determineIndentationToApplyToPastedText(IDocument document, int targetLineIndexToCalculateCommonIndentationFor) throws BadLocationException {
        int lineOffset = document.getLineOffset(targetLineIndexToCalculateCommonIndentationFor);
        String indent = this.indenter.forciblyCalculateLineIndent(document, targetLineIndexToCalculateCommonIndentationFor, lineOffset, "", -1);
        return AutoEditUtils.getIndentVisualLength((ITabPreferencesProvider)this.prefs, (String)indent);
    }

    private void fixupIndentation(Document temp, int firstSourceIndentedLineIndex, int numberOfPastedLines, int indentSizeDelta) throws BadLocationException {
        int lineIndex = firstSourceIndentedLineIndex;
        while (lineIndex < temp.getNumberOfLines()) {
            int correctLineIndentSize;
            int end;
            int home;
            int lineLength;
            int lineStart = temp.getLineOffset(lineIndex);
            int existingLineIndentSize = AutoEditUtils.calculateVisualLength((ITabPreferencesProvider)this.prefs, (IDocument)temp, (int)lineStart, (int)(lineLength = temp.getLineLength(lineIndex)), (int)lineStart, (int)(home = AutoEditUtils.findEndOfWhiteSpace((IDocument)temp, (int)lineStart, (int)(end = lineStart + lineLength))));
            if (existingLineIndentSize != (correctLineIndentSize = lineIndex == temp.getNumberOfLines() - 1 && AutoEditUtils.atEndOfLine((IDocument)temp, (int)home, (int)end) && numberOfPastedLines > 1 ? 0 : Math.max(existingLineIndentSize + indentSizeDelta, 0))) {
                String indent = this.prefs.getIndentByVirtualSize(correctLineIndentSize);
                temp.replace(lineStart, home - lineStart, indent);
            }
            ++lineIndex;
        }
    }

    private void replaceIndentation(Document temp, int lineIndex, int correctLineIndentSize) throws BadLocationException {
        int end;
        int home;
        int lineLength;
        int lineStart = temp.getLineOffset(lineIndex);
        int existingLineIndentSize = AutoEditUtils.calculateVisualLength((ITabPreferencesProvider)this.prefs, (IDocument)temp, (int)lineStart, (int)(lineLength = temp.getLineLength(lineIndex)), (int)lineStart, (int)(home = AutoEditUtils.findEndOfWhiteSpace((IDocument)temp, (int)lineStart, (int)(end = lineStart + lineLength))));
        if (existingLineIndentSize != correctLineIndentSize) {
            String indent = this.prefs.getIndentByVirtualSize(correctLineIndentSize);
            temp.replace(lineStart, home - lineStart, indent);
        }
    }

    private void handleSmartNewLine(IDocument document, DocumentCommand c) {
        try {
            int lineIndex = document.getLineOfOffset(c.offset);
            int lineStart = document.getLineOffset(lineIndex);
            int lineLength = document.getLineLength(lineIndex);
            String line = document.get(c.offset, lineStart + lineLength - c.offset);
            String indent = this.indenter.forciblyCalculateLineIndent(document, lineIndex + 1, lineStart, line, c.offset);
            if (line.trim().equals("}") && c.offset >= 0 && document.getChar(c.offset - 1) == '{') {
                StringBuffer buf = new StringBuffer(c.text);
                buf.append(indent);
                buf.append(this.prefs.getIndent());
                c.shiftsCaret = false;
                c.caretOffset = c.offset + buf.length();
                buf.append('\n');
                buf.append(indent);
                c.text = buf.toString();
            } else {
                c.text = String.valueOf(c.text) + indent;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            super.customizeDocumentCommand(document, c);
        }
    }

    private void handeSingleCharacterTyped(IDocument d, DocumentCommand c) {
        char newChar = c.text.charAt(0);
        switch (newChar) {
            case 'd': 
            case 'e': 
            case 'f': 
            case 'n': {
                this.reindent(d, c);
                break;
            }
            case '}': {
                this.reindent(d, c);
                this.autoClose(d, c);
                break;
            }
            case '{': {
                this.autoClose(d, c);
                break;
            }
            case '\t': {
                boolean jumped = false;
                if (this.prefs.isSmartTab()) {
                    jumped = this.handleSmartTabulation(d, c);
                }
                if (jumped) break;
                c.text = this.prefs.getIndent();
            }
        }
    }
}

