/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IPackageDeclaration;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.core.CommitWorkingCopyOperation;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.DiscardWorkingCopyOperation;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.PackageDeclaration;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.dltk.internal.core.SourceMethod;
import org.eclipse.dltk.internal.core.SourceModuleElementInfo;
import org.eclipse.dltk.internal.core.SourceModuleStructureRequestor;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public class SourceModule
extends Openable
implements org.eclipse.dltk.core.ISourceModule,
ISourceModule {
    private static final boolean DEBUG_PRINT_MODEL = DLTKCore.DEBUG_PRINT_MODEL;
    protected String name;
    public WorkingCopyOwner owner;
    private final boolean fReadOnly;
    private static int nextId = 1;
    private final int id = nextId++;

    public org.eclipse.dltk.core.ISourceModule getSourceModule() {
        return this;
    }

    public SourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent);
        this.name = name;
        this.owner = owner;
        this.fReadOnly = false;
    }

    public SourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner, boolean readOnly) {
        super(parent);
        this.name = name;
        this.owner = owner;
        this.fReadOnly = readOnly;
    }

    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(this, false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(this, problemRequestor);
            operation.runOperation(monitor);
        }
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IProblemReporter problemReporter;
        IResource resource;
        IDLTKLanguageToolkit toolkit;
        SourceModuleStructureRequestor requestor;
        char[] contents;
        SourceModuleElementInfo moduleInfo;
        block11: {
            IStatus status;
            if (!this.isWorkingCopy() && !(status = this.validateSourceModule(underlyingResource)).isOK()) {
                throw this.newModelException(status);
            }
            if (!this.isPrimary() && this.getPerWorkingCopyInfo() == null) {
                throw this.newNotPresentException();
            }
            moduleInfo = (SourceModuleElementInfo)info;
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(pm, moduleInfo);
            }
            contents = buffer == null ? null : buffer.getCharacters();
            try {
                requestor = new SourceModuleStructureRequestor(this, moduleInfo, newElements);
                toolkit = null;
                resource = this.getResource();
                toolkit = resource == null ? DLTKLanguageManager.findToolkit(this.getPath()) : DLTKLanguageManager.findToolkit(this.getResource());
                if (toolkit != null) break block11;
                return false;
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
        ModelManager.PerWorkingCopyInfo wcInfo = this.getPerWorkingCopyInfo();
        if (wcInfo != null && wcInfo.problemReporter != null) {
            problemReporter = wcInfo.problemReporter;
        } else {
            IProblemFactory factory = DLTKLanguageManager.getProblemFactory(toolkit.getNatureId());
            problemReporter = factory.createReporter(resource);
        }
        ISourceElementParser parser = DLTKLanguageManager.getSourceElementParser(toolkit.getNatureId());
        parser.setRequestor(requestor);
        parser.setReporter(problemReporter);
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        ISourceModuleInfoCache.ISourceModuleInfo mifo = sourceModuleInfoCache.get(this);
        parser.parseSourceModule(contents, mifo, this.getPath().toString().toCharArray());
        if (DEBUG_PRINT_MODEL) {
            System.out.println("Source Module Debug print:");
            CorePrinter printer = new CorePrinter(System.out);
            this.printNode(printer);
            printer.flush();
        }
        if (underlyingResource == null) {
            underlyingResource = this.getResource();
        }
        if (underlyingResource != null) {
            moduleInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
        }
        return moduleInfo.isStructureKnown();
    }

    protected Object createElementInfo() {
        return new SourceModuleElementInfo();
    }

    public int getElementType() {
        return 5;
    }

    public IResource getResource() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    public IPath getPath() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    public ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return ModelManager.getModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    public void discardWorkingCopy() throws ModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this);
        op.runOperation(null);
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceModule)) {
            return false;
        }
        SourceModule other = (SourceModule)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws ModelException {
        IBuffer buffer;
        boolean isWorkingCopy = this.isWorkingCopy();
        IBuffer iBuffer = buffer = isWorkingCopy ? this.owner.createBuffer(this) : BufferManager.getDefaultBufferManager().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            if (isWorkingCopy) {
                SourceModule original;
                if (!this.isPrimary() && (original = new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY)).isOpen()) {
                    buffer.setContents(original.getSource());
                } else {
                    IFile file = (IFile)this.getResource();
                    if (file == null || !file.exists()) {
                        buffer.setContents(CharOperation.NO_CHAR);
                    } else {
                        buffer.setContents(Util.getResourceContentsAsCharArray(file));
                    }
                }
            } else {
                IFile file = (IFile)this.getResource();
                if (file == null || !file.exists()) {
                    throw this.newNotPresentException();
                }
                buffer.setContents(Util.getResourceContentsAsCharArray(file));
            }
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    public String getSource() throws ModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    public char[] getSourceAsCharArray() throws ModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return new char[0];
        }
        return buffer.getCharacters();
    }

    public String getElementName() {
        return this.name;
    }

    public org.eclipse.dltk.core.ISourceModule getWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.getWorkingCopy(new WorkingCopyOwner(){}, null, monitor);
    }

    public org.eclipse.dltk.core.ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        return this.getWorkingCopy(workingCopyOwner, problemRequestor, null, monitor);
    }

    public org.eclipse.dltk.core.ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProblemReporter problemReporter, IProgressMonitor monitor) throws ModelException {
        SourceModule workingCopy;
        if (!this.isPrimary()) {
            return this;
        }
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), workingCopyOwner), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, problemRequestor, problemReporter);
        op.runOperation(monitor);
        return workingCopy;
    }

    public boolean exists() {
        if (this.getPerWorkingCopyInfo() != null) {
            return true;
        }
        return this.isPrimary() && this.validateSourceModule(this.getResource()).isOK();
    }

    protected IStatus validateSourceModule(IResource resource) {
        IDLTKLanguageToolkit toolkit;
        ProjectFragment root = this.getProjectFragment();
        try {
            if (root.getKind() != 1) {
                return new ModelStatus(967, root);
            }
        }
        catch (ModelException e) {
            return e.getModelStatus();
        }
        if (resource != null) {
            char[][] exclusionPatterns;
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            if (Util.isExcluded(resource, inclusionPatterns, exclusionPatterns = root.fullExclusionPatternChars())) {
                return new ModelStatus(1006, this);
            }
            if (!resource.isAccessible()) {
                return new ModelStatus(969, this);
            }
        }
        if (!root.isArchive()) {
            try {
                toolkit = DLTKLanguageManager.getLanguageToolkit(this);
                if (toolkit != null) {
                    return toolkit.validateSourceModule(resource);
                }
                toolkit = DLTKLanguageManager.findToolkit(resource);
                if (toolkit != null) {
                    return toolkit.validateSourceModule(resource);
                }
                return new ModelStatus(995, root);
            }
            catch (CoreException ex) {
                return new ModelStatus(ex);
            }
        }
        toolkit = DLTKLanguageManager.findToolkit(resource);
        if (toolkit != null) {
            return toolkit.validateSourceModule(resource);
        }
        return new ModelStatus(995, root);
    }

    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(buffer);
    }

    public void close() throws ModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    protected void closing(Object info) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(info);
        }
    }

    public IModelElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new SourceModule((ScriptFolder)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY);
    }

    public IResource getUnderlyingResource() throws ModelException {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return super.getUnderlyingResource();
    }

    public boolean isConsistent() {
        return !ModelManager.getModelManager().getElementsOutOfSynchWithBuffers().contains(this);
    }

    public void makeConsistent(IProgressMonitor monitor) throws ModelException {
        ISourceModuleInfoCache sourceModuleInfoCache = ModelManager.getModelManager().getSourceModuleInfoCache();
        sourceModuleInfoCache.remove(this);
        this.openWhenClosed(this.createElementInfo(), monitor);
    }

    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws ModelException {
        if (!this.isWorkingCopy()) {
            super.openParent(childInfo, newElements, pm);
        }
    }

    public void save(IProgressMonitor pm, boolean force) throws ModelException {
        if (this.isWorkingCopy()) {
            throw new RuntimeException("not implemented");
        }
        super.save(pm, force);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws ModelException {
        if (!this.isWorkingCopy()) {
            return;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, forceProblemDetection, workingCopyOwner);
        ModelManager manager = ModelManager.getModelManager();
        try {
            manager.cacheZipFiles();
            op.runOperation(monitor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.flushZipFiles();
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.flushZipFiles();
            return;
        }
    }

    public org.eclipse.dltk.core.ISourceModule getPrimary() {
        return (org.eclipse.dltk.core.ISourceModule)this.getPrimaryElement(true);
    }

    protected void updateTimeStamp(SourceModule original) throws ModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new ModelException(new ModelStatus(995));
        }
        ((SourceModuleElementInfo)this.getElementInfo()).timestamp = timeStamp;
    }

    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = ModelManager.getModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        return ((SourceModuleElementInfo)info).timestamp != this.getResource().getModificationStamp();
    }

    public IModelElement getElementAt(int position) throws ModelException {
        IModelElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    public ISourceRange getSourceRange() throws ModelException {
        return ((SourceModuleElementInfo)this.getElementInfo()).getSourceRange();
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Source Module:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    public IType[] getTypes() throws ModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '#': {
                if (!DLTKCore.DEBUG) break;
                System.err.println("Add import support in SourceModule getHandleFromMemento");
                break;
            }
            case '%': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String pkgName = memento.nextToken();
                ModelElement pkgDecl = (ModelElement)((Object)this.getPackageDeclaration(pkgName));
                return pkgDecl.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                ModelElement type = (ModelElement)((Object)this.getType(typeName));
                return type.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String methodName = memento.nextToken();
                ModelElement method = (ModelElement)((Object)this.getMethod(methodName));
                return method.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String field = memento.nextToken();
                ModelElement fieldE = (ModelElement)((Object)this.getField(field));
                return fieldE.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '{';
    }

    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().copy(elements, containers, null, renamings, replace, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        IModelElement[] elements = new IModelElement[]{this};
        this.getModel().delete(elements, force, monitor);
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().move(elements, containers, null, renamings, replace, monitor);
    }

    public void rename(String newName, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.operation_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getModel().rename(elements, dests, renamings, replace, monitor);
    }

    public void codeComplete(int offset, CompletionRequestor requestor) throws ModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws ModelException {
        this.codeComplete(this, offset, requestor, owner);
    }

    public IModelElement[] codeSelect(int offset, int length) throws ModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IModelElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws ModelException {
        return super.codeSelect(this, offset, length, owner);
    }

    public String getSourceContents() {
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            try {
                char[] cont = Util.getResourceContentsAsCharArray((IFile)this.getResource());
                return cont.toString();
            }
            catch (ModelException modelException) {
                return "";
            }
        }
        return buffer.getContents();
    }

    public IPath getScriptFolder() {
        return null;
    }

    public char[] getFileName() {
        return this.getPath().toOSString().toCharArray();
    }

    public IModelElement getModelElement() {
        return this;
    }

    public IPackageDeclaration getPackageDeclaration(String pkg) {
        return new PackageDeclaration(this, pkg);
    }

    public IPackageDeclaration[] getPackageDeclarations() throws ModelException {
        ArrayList list = this.getChildrenOfType(10);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    public IField[] getFields() throws ModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    public IMethod getMethod(String selector) {
        return new SourceMethod(this, selector);
    }

    public IMethod[] getMethods() throws ModelException {
        ArrayList list = this.getChildrenOfType(9);
        IMethod[] array = new IMethod[list.size()];
        list.toArray(array);
        return array;
    }

    public IType[] getAllTypes() throws ModelException {
        IType[] types = this.getTypes();
        ArrayList<IType> allTypes = new ArrayList<IType>(types.length);
        ArrayList<IType> typesToTraverse = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            IType type = (IType)typesToTraverse.get(0);
            typesToTraverse.remove(type);
            allTypes.add(type);
            types = type.getTypes();
            i = 0;
            while (i < types.length) {
                typesToTraverse.add(types[i]);
                ++i;
            }
        }
        IType[] arrayOfAllTypes = new IType[allTypes.size()];
        allTypes.toArray(arrayOfAllTypes);
        return arrayOfAllTypes;
    }

    public boolean isBuiltin() {
        return false;
    }
}

