/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class NewSourceModulePage
extends NewContainerWizardPage {
    private static final String FILE = "NewSourceModulePage.file";
    private IStatus sourceMoudleStatus;
    private IScriptFolder currentScriptFolder;
    private StringDialogField fileDialogField;

    private IStatus fileChanged() {
        ISourceModule module;
        StatusInfo status = new StatusInfo();
        if (this.getFileText().length() == 0) {
            status.setError("Cannot be empty");
        } else if (this.currentScriptFolder != null && (module = this.currentScriptFolder.getSourceModule(this.getFileName())).exists()) {
            status.setError("File already exists");
        }
        return status;
    }

    public void init(IStructuredSelection selection) {
        IModelElement element = this.getInitialScriptElement(selection);
        this.initContainerPage(element);
        this.updateStatus(new IStatus[]{this.containerStatus, this.fileChanged()});
    }

    protected void createFileControls(Composite parent, int nColumns) {
        this.fileDialogField.doFillIntoGrid(parent, nColumns - 1);
        Text text = this.fileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        DialogField.createEmptySpace(parent);
    }

    public NewSourceModulePage() {
        super("wizardPage");
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        this.sourceMoudleStatus = new StatusInfo();
        this.fileDialogField = new StringDialogField();
        this.fileDialogField.setLabelText("File: ");
        this.fileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewSourceModulePage.this.sourceMoudleStatus = NewSourceModulePage.this.fileChanged();
                NewSourceModulePage.this.handleFieldChanged(NewSourceModulePage.FILE);
            }
        });
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            IProjectFragment fragment = this.getProjectFragment();
            this.currentScriptFolder = fragment != null ? fragment.getScriptFolder("") : null;
            this.sourceMoudleStatus = this.fileChanged();
        }
        this.updateStatus(new IStatus[]{this.containerStatus, this.sourceMoudleStatus});
    }

    public ISourceModule createFile(IProgressMonitor monitor) throws CoreException, InterruptedException {
        String fileName;
        ISourceModule module;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((module = this.currentScriptFolder.createSourceModule(fileName = this.getFileName(), this.getFileContent(), true, monitor)) != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        EditorUtility.openInEditor(module);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return module;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 3);
        this.createFileControls(composite, 3);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected String getFileText() {
        return this.fileDialogField.getText();
    }

    protected String getFileName() {
        String fileText = this.getFileText();
        String[] extensions = this.getFileExtensions();
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            if (extension.length() > 0 && fileText.endsWith("." + extension)) {
                return fileText;
            }
            ++i;
        }
        return String.valueOf(fileText) + "." + extensions[0];
    }

    protected String[] getFileExtensions() {
        try {
            return DLTKLanguageManager.getLanguageToolkit((String)this.getRequiredNature()).getLanguageFileExtensions();
        }
        catch (CoreException coreException) {
            return new String[]{""};
        }
    }

    protected IScriptFolder chooseScriptFolder() {
        Object element;
        ModelElementLabelProvider labelProvider = new ModelElementLabelProvider(ModelElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setIgnoreCase(false);
        dialog.setTitle("Select Script Folder title");
        dialog.setMessage("Select Script Folder message");
        dialog.setEmptyListMessage("Empty List message");
        IProjectFragment projectFragment = this.getProjectFragment();
        if (projectFragment != null) {
            try {
                dialog.setElements((Object[])projectFragment.getChildren());
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        dialog.setHelpAvailable(false);
        if (this.currentScriptFolder != null) {
            dialog.setInitialSelections(new Object[]{this.currentScriptFolder});
        }
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IScriptFolder) {
            return (IScriptFolder)element;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void setFocus() {
        this.fileDialogField.setFocus();
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected String getFileContent() {
        return "";
    }
}

