/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecServiceImpl;
import org.eclipse.actf.ai.fennec.impl.NodeUtil;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.query.IQuery;
import org.w3c.dom.NodeList;

class FennecSimpleMetadata
extends FennecMetadata {
    public static final int TYPE_ALT_TEXT = 1;
    public static final int TYPE_DESCRIPTION = 2;
    public static final int TYPE_HEADER = 3;
    private short headingLevel;
    private int type;
    private List stringFormat;

    public short getHeadingLevel(ITreeItem item) {
        return this.headingLevel;
    }

    public String getString(ITreeItem item) {
        StringBuffer buf = new StringBuffer();
        if (this.stringFormat == null) {
            return null;
        }
        for (Object o : this.stringFormat) {
            if (o instanceof String) {
                buf.append((String)o);
                continue;
            }
            if (!(o instanceof IQuery)) continue;
            IQuery q = (IQuery)o;
            NodeList nl = this.query(q, item);
            String str = NodeUtil.extractString(nl);
            buf.append(str);
        }
        return buf.toString();
    }

    public String getAltText(ITreeItem item) {
        if (this.type == 1) {
            return this.getString(item);
        }
        return "";
    }

    public String getDescription(ITreeItem item) {
        if (this.type == 2) {
            return this.getString(item);
        }
        return "";
    }

    static FennecSimpleMetadata newHeader(FennecServiceImpl fennecService, IQuery q, FennecMode mode, short level) {
        FennecSimpleMetadata md = new FennecSimpleMetadata(fennecService, q, mode);
        md.type = 3;
        md.headingLevel = level;
        return md;
    }

    static FennecSimpleMetadata newAltText(FennecServiceImpl fennecService, IQuery q, FennecMode mode, List stringFormat) {
        FennecSimpleMetadata md = new FennecSimpleMetadata(fennecService, q, mode);
        md.type = 1;
        md.stringFormat = stringFormat;
        return md;
    }

    static FennecSimpleMetadata newDescription(FennecServiceImpl fennecService, FennecMode mode, IQuery q, List stringFormat) {
        FennecSimpleMetadata md = new FennecSimpleMetadata(fennecService, q, mode);
        md.type = 2;
        md.stringFormat = stringFormat;
        return md;
    }

    private FennecSimpleMetadata(FennecServiceImpl fennecService, IQuery q, FennecMode mode) {
        super(fennecService, q, mode);
    }

    List expand(TreeItemFennec pItem, int trigger) throws FennecException {
        return null;
    }
}

