/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.impl.FennecMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecServiceImpl;
import org.eclipse.actf.ai.fennec.impl.FennecSimpleMetadata;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.query.IQuery;
import org.w3c.dom.Node;

abstract class FennecBundleMetadata
extends FennecMetadata {
    private static final FennecMetadata[] emptyChildMetadata = new FennecMetadata[0];
    protected final FennecMetadata[] childMetadata;

    protected FennecBundleMetadata(FennecServiceImpl fennecService, IQuery q, FennecMode mode, FennecMetadata[] mds) {
        super(fennecService, q, mode);
        if (mds == null) {
            mds = emptyChildMetadata;
        }
        this.childMetadata = mds;
    }

    protected FennecBundleMetadata(FennecServiceImpl fennecService, FennecMode mode, Node node, FennecMetadata[] mds) {
        super(fennecService, mode, node);
        if (mds == null) {
            mds = emptyChildMetadata;
        }
        this.childMetadata = mds;
    }

    List expand(TreeItemFennec pItem, int trigger) throws FennecException {
        ArrayList ret = new ArrayList();
        int i = 0;
        while (i < this.childMetadata.length) {
            FennecMetadata cmd = this.childMetadata[i];
            List ret2 = cmd.buildItems(pItem, null, trigger);
            if (ret2 != null) {
                ret.addAll(ret2);
            }
            ++i;
        }
        return ret;
    }

    FennecMetadata[] getChildMetadata() {
        return this.childMetadata;
    }

    public String getAltText(ITreeItem item) {
        int i = 0;
        while (i < this.childMetadata.length) {
            if (!this.childMetadata[i].hasTargets() && this.childMetadata[i] instanceof FennecSimpleMetadata) {
                String ret = this.childMetadata[i].getAltText(item);
                if (ret == null) {
                    return null;
                }
                if (ret.length() > 0) {
                    return ret;
                }
            }
            ++i;
        }
        return "";
    }

    public String getDescription(ITreeItem item) {
        int i = 0;
        while (i < this.childMetadata.length) {
            if (!this.childMetadata[i].hasTargets() && this.childMetadata[i] instanceof FennecSimpleMetadata) {
                String ret = this.childMetadata[i].getDescription(item);
                if (ret == null) {
                    return null;
                }
                if (ret.length() > 0) {
                    return ret;
                }
            }
            ++i;
        }
        return "";
    }

    public short getHeadingLevel(ITreeItem item) {
        int i = 0;
        while (i < this.childMetadata.length) {
            if (!this.childMetadata[i].hasTargets() && this.childMetadata[i] instanceof FennecSimpleMetadata) {
                short ret = this.childMetadata[i].getHeadingLevel(item);
                if (ret == -1) {
                    return -1;
                }
                if (ret > 0) {
                    return ret;
                }
            }
            ++i;
        }
        return 0;
    }
}

