/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.autotranslator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.impl.TreeItemMark;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.eclipse.actf.model.dom.dombycom.IImageElement;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoTranslator {
    private static final boolean AUTO_COLLAPSE = true;
    private static final boolean AUTO_INDENT = true;

    private static boolean canCollapse(TreeItemFennec item) {
        return Vocabulary.isReducible().eval((IEvalTarget)item);
    }

    private static TreeItemFennec simplify(TreeItemFennec item, TreeItemFennec pItem) {
        ITreeItem[] childItems;
        if (!Vocabulary.hasContent().eval((IEvalTarget)item)) {
            ITreeItem[] cc = item.getChildItems();
            if (cc.length == 0) {
                return null;
            }
            if (cc.length == 1) {
                TreeItemFennec item2 = (TreeItemFennec)cc[0];
                item2.forceParent(pItem);
                item2.addMetadata(item);
                return item2;
            }
        }
        if ((childItems = item.getChildItems()).length == 1) {
            TreeItemFennec item2 = (TreeItemFennec)childItems[0];
            if (!Vocabulary.hasContent().eval((IEvalTarget)item2)) {
                ITreeItem[] childItems2 = item2.getChildItems();
                item.setChildItems(childItems2);
                item.addMetadata(item2);
            }
        }
        return item;
    }

    private static void adjustLabelIndent(TreeItemFennec item) {
    }

    private static List<ITreeItem> buildTreeItemContinued(FennecMode mode, TreeItemFennec item, INodeEx nex, int depth) {
        IImageElement image;
        ArrayList<ITreeItem> childItemList = new ArrayList<ITreeItem>();
        TreeItemMark lastItem = null;
        if (nex instanceof IFlashNode) {
            IFlashNode fn = (IFlashNode)nex;
            nex = fn.getMSAA();
            lastItem = new TreeItemMark(item, TreeItemMark.MarkType.FLASH_END);
            if (nex != null && Vocabulary.getNormalFlashMode() == Vocabulary.FlashMode.NO_FLASH || nex == null && Vocabulary.getWindowlessFlashMode() == Vocabulary.FlashMode.NO_FLASH) {
                return childItemList;
            }
            if (nex != null && Vocabulary.getNormalFlashMode() == Vocabulary.FlashMode.FLASH_DOM || nex == null && Vocabulary.getWindowlessFlashMode() == Vocabulary.FlashMode.FLASH_DOM) {
                IFlashNode[] translated = fn.translate();
                int i = 0;
                while (i < translated.length) {
                    TreeItemFennec newItem = mode.generateItem(item, (Node)translated[i]);
                    if (newItem != null) {
                        childItemList.add(newItem);
                    }
                    ++i;
                }
                if (Vocabulary.isFlashTopNode().eval((IEvalTarget)fn)) {
                    childItemList.add(lastItem);
                }
                item.setChildItems(childItemList);
                return childItemList;
            }
        }
        if (nex instanceof IImageElement && (image = (IImageElement)nex).hasUsemap()) {
            Element map = image.getMap();
            if (map == null) {
                return childItemList;
            }
            NodeList nl = map.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    TreeItemFennec newItem = mode.generateItem(item, n);
                    childItemList.add(newItem);
                }
                ++i;
            }
            item.setChildItems(childItemList);
            return childItemList;
        }
        if (depth <= 0) {
            item.setChildItems(childItemList);
            return childItemList;
        }
        TreeItemFennec childItem = null;
        NodeList nl = nex.getChildNodes();
        int len = nl.getLength();
        boolean hasContent = Vocabulary.hasContent().eval((IEvalTarget)item);
        int i = 0;
        while (i < len) {
            Node cn = nl.item(i);
            childItem = hasContent ? AutoTranslator.buildTreeItem(mode, item, cn, depth - 1) : AutoTranslator.buildTreeItem(mode, item, cn, depth);
            if (childItem != null) {
                if (AutoTranslator.canCollapse(childItem)) {
                    ITreeItem[] cc = childItem.getChildItems();
                    if (cc != null && cc.length > 0) {
                        int j = 0;
                        while (j < cc.length) {
                            if (cc[j] instanceof TreeItemFennec) {
                                TreeItemFennec temp = (TreeItemFennec)cc[j];
                                temp.addMetadata(childItem);
                            }
                            ++j;
                        }
                        childItemList.addAll(Arrays.asList(cc));
                    }
                } else {
                    childItemList.add(childItem);
                }
            }
            ++i;
        }
        if (lastItem != null) {
            childItemList.add(lastItem);
        }
        item.setChildItems(childItemList);
        return childItemList;
    }

    private static TreeItemFennec buildTreeItem(FennecMode mode, TreeItemFennec pItem, Node n, int depth) {
        if (!(n instanceof INodeEx)) {
            return null;
        }
        INodeEx nex = (INodeEx)n;
        if (!Vocabulary.isValidNode().eval((IEvalTarget)nex)) {
            return null;
        }
        TreeItemFennec item = mode.generateItem(pItem, n);
        if (item == null) {
            return null;
        }
        AutoTranslator.buildTreeItemContinued(mode, item, nex, depth);
        AutoTranslator.adjustLabelIndent(item);
        return AutoTranslator.simplify(item, pItem);
    }

    public static TreeItemFennec translate(FennecMode mode, TreeItemFennec pItem, Node n) {
        return AutoTranslator.buildTreeItem(mode, pItem, n, 1);
    }

    public static TreeItemFennec translateContinued(FennecMode mode, TreeItemFennec item, Node n) {
        if (!(n instanceof INodeEx)) {
            return item;
        }
        AutoTranslator.buildTreeItemContinued(mode, item, (INodeEx)n, 2);
        return item;
    }
}

