/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.io.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import org.eclipse.actf.ai.audio.io.AudioIOException;
import org.eclipse.actf.ai.audio.io.AudioPipeListener;
import org.eclipse.actf.ai.audio.io.AudioUtil;
import org.eclipse.actf.ai.audio.io.IAudioPipe;
import org.eclipse.actf.ai.audio.io.IAudioReader;
import org.eclipse.actf.ai.audio.io.IAudioWriter;

public class AudioPipe
implements IAudioPipe {
    private IAudioReader reader;
    private IAudioWriter writer;
    private AudioFormat format;
    private Thread thread;
    private Runnable runner;
    private byte[] buffer;
    private int bufferSize;
    private int interval = 100;
    private int priority = 5;
    private int bufferSizeInMs = 1000;
    private boolean active;
    private boolean waiting;
    private boolean stopFlag = false;
    private boolean stopFlag2 = false;
    private ArrayList<AudioPipeListener> listeners = new ArrayList();

    public AudioPipe(IAudioReader reader, IAudioWriter writer) {
        this.reader = reader;
        this.writer = writer;
        this.runner = new ReaderWriterRunner();
    }

    public void addAudioPipeListener(AudioPipeListener listener) {
        this.listeners.add(listener);
    }

    private void fireFinished() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).finished(this);
            ++i;
        }
    }

    private void fireStopped() {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).stopped(this);
            ++i;
        }
    }

    public synchronized void setInterval(int interval) {
        this.interval = interval;
    }

    public synchronized void setPriority(int priority) {
        this.priority = priority;
        if (this.thread != null) {
            this.thread.setPriority(priority);
        }
    }

    public void prepare() {
        try {
            this.reader.open();
            this.format = this.reader.getAudioFormat();
            this.writer.open(this.format);
        }
        catch (AudioIOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void start() {
        this.start(0);
    }

    public void start(final int delay) {
        if (this.active || this.waiting) {
            return;
        }
        this.waiting = true;
        this.thread = new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            public void run() {
                s = new Date().getTime();
                while (true) {
                    n = new Date().getTime();
                    if (AudioPipe.access$6(AudioPipe.this)) {
                        AudioPipe.access$12(AudioPipe.this, false);
                        AudioPipe.access$7(AudioPipe.this, false);
                        AudioPipe.access$4(AudioPipe.this, false);
                        AudioPipe.access$5(AudioPipe.this);
                        return;
                    }
                    if (s + (long)delay <= n) ** GOTO lbl20
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException v0) {}
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException v1) {}
lbl20:
                    // 3 sources

                    ** while (AudioPipe.access$13((AudioPipe)AudioPipe.this))
                }
lbl21:
                // 1 sources

                AudioPipe.this.prepare();
                Bps = AudioUtil.getBytesPerSampleLR(AudioPipe.access$0(AudioPipe.this));
                AudioPipe.access$15(AudioPipe.this, AudioUtil.getBytesPerSecondLR(AudioPipe.access$0(AudioPipe.this)) * AudioPipe.access$14(AudioPipe.this) / 1000 / Bps * Bps);
                AudioPipe.access$17(AudioPipe.this, new byte[AudioPipe.access$16(AudioPipe.this)]);
                AudioPipe.access$4(AudioPipe.this, true);
                AudioPipe.access$12(AudioPipe.this, false);
                AudioPipe.access$18(AudioPipe.this).run();
            }
        });
        this.thread.setPriority(this.priority);
        this.thread.setName(String.valueOf(this.reader.getName()) + "<->" + this.writer.getName());
        this.thread.start();
    }

    private synchronized void sleep() {
        try {
            Thread.sleep(this.interval);
            Thread.yield();
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean isActive() {
        return this.active;
    }

    public void stop() {
        if (this.active || this.waiting) {
            this.stopFlag = true;
        }
    }

    public void join() {
        if (this.thread == null) {
            return;
        }
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setBufferSize(int miliSeconds) {
        this.bufferSizeInMs = miliSeconds;
    }

    static /* synthetic */ void access$12(AudioPipe audioPipe, boolean bl) {
        audioPipe.waiting = bl;
    }

    static /* synthetic */ boolean access$13(AudioPipe audioPipe) {
        return audioPipe.active;
    }

    static /* synthetic */ int access$14(AudioPipe audioPipe) {
        return audioPipe.bufferSizeInMs;
    }

    static /* synthetic */ void access$15(AudioPipe audioPipe, int n) {
        audioPipe.bufferSize = n;
    }

    static /* synthetic */ int access$16(AudioPipe audioPipe) {
        return audioPipe.bufferSize;
    }

    static /* synthetic */ void access$17(AudioPipe audioPipe, byte[] byArray) {
        audioPipe.buffer = byArray;
    }

    static /* synthetic */ Runnable access$18(AudioPipe audioPipe) {
        return audioPipe.runner;
    }

    class ReaderWriterRunner
    implements Runnable {
        ReaderWriterRunner() {
        }

        private void fadeout(byte[] buffer, int nBytesRead) {
            int bps = AudioUtil.getBytesPerSample(AudioPipe.this.format);
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            ShortBuffer sb = null;
            if (AudioPipe.this.format.isBigEndian()) {
                bb.order(ByteOrder.BIG_ENDIAN);
            } else {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            if (bps == 2) {
                sb = bb.asShortBuffer();
            }
            int len = nBytesRead / bps;
            int i = 0;
            while (i < len) {
                double k = (double)(len - i) / (double)len;
                if (bps == 1) {
                    bb.put(i, (byte)((double)bb.get(i) * k));
                } else {
                    sb.put(i, (short)((double)sb.get(i) * k));
                }
                ++i;
            }
        }

        public void run() {
            try {
                while (!AudioPipe.this.reader.isClosed()) {
                    int temp;
                    int nBytesRead = AudioPipe.this.reader.read(AudioPipe.this.buffer, 0, AudioPipe.this.buffer.length);
                    int nBytesWritten = 0;
                    do {
                        if (AudioPipe.this.writer.isClosed()) {
                            AudioPipe.this.active = false;
                            AudioPipe.this.fireStopped();
                            return;
                        }
                        if (AudioPipe.this.stopFlag) {
                            this.fadeout(AudioPipe.this.buffer, nBytesRead);
                            AudioPipe.this.stopFlag = false;
                            AudioPipe.this.stopFlag2 = true;
                        }
                        temp = AudioPipe.this.writer.write(AudioPipe.this.buffer, nBytesWritten, nBytesRead);
                        nBytesWritten += temp;
                        AudioPipe.this.sleep();
                    } while ((nBytesRead -= temp) > 0);
                    if (!AudioPipe.this.stopFlag2) continue;
                    AudioPipe.this.stopFlag2 = false;
                    AudioPipe.this.writer.close();
                }
                AudioPipe.this.writer.close();
            }
            catch (AudioIOException audioIOException) {
                AudioPipe.this.writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                AudioPipe.this.writer.close();
            }
            AudioPipe.this.active = false;
            AudioPipe.this.fireFinished();
        }
    }
}

