/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLActionManager;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelVisitor;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLNoResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;

public class NVDLModelTraverse
implements NVDLModelVisitor {
    private Set<NVDLModel> traversed = new HashSet<NVDLModel>();

    private boolean checkTraversedInternal(NVDLModel m) {
        if (this.traversed.contains(m)) {
            return true;
        }
        this.traversed.add(m);
        return false;
    }

    protected boolean checkTraversed(NVDLModel m) {
        return this.traversed.contains(m);
    }

    public void traverse(NVDLModel m) throws NVDLModelException {
        this.traversed.clear();
        m.visitModel(this);
    }

    private NVDLModel visit(NVDLModel m) throws NVDLModelException {
        if (m == null) {
            return null;
        }
        return m.visitModel(this);
    }

    public NVDLModel visitNVDLMode(NVDLMode mode) throws NVDLModelException {
        if (this.checkTraversedInternal(mode)) {
            return null;
        }
        NVDLRule rule = mode.getAnyNamespaceRuleForAttribute();
        if (rule != null) {
            this.visit(rule);
        }
        if ((rule = mode.getAnyNamespaceRuleForElement()) != null) {
            this.visit(rule);
        }
        Iterator it = mode.notAnyNamespaceRuleIterator();
        while (it.hasNext()) {
            rule = (NVDLRule)it.next();
            this.visit(rule);
        }
        return null;
    }

    private void traverseAction(NVDLAction a) throws NVDLModelException {
        this.visit(a.getUseMode());
        List<NVDLAction.Context> contexts = a.getContextsList();
        for (NVDLAction.Context c : contexts) {
            this.visit(c.useMode);
        }
    }

    public NVDLModel visitNVDLNoResultAction(NVDLNoResultAction action) throws NVDLModelException {
        if (this.checkTraversedInternal(action)) {
            return null;
        }
        this.traverseAction(action);
        return null;
    }

    public NVDLModel visitNVDLResultAction(NVDLResultAction action) throws NVDLModelException {
        if (this.checkTraversedInternal(action)) {
            return null;
        }
        this.traverseAction(action);
        return null;
    }

    public NVDLModel visitNVDLRule(NVDLRule rule) throws NVDLModelException {
        if (this.checkTraversedInternal(rule)) {
            return null;
        }
        NVDLActionManager am = rule.getActionManager();
        NVDLResultAction ra = am.getResultAction();
        if (ra != null) {
            this.visit(ra);
        }
        List nras = am.getNoResultActions();
        for (NVDLNoResultAction nra : nras) {
            this.visit(nra);
        }
        return null;
    }

    public NVDLModel visitNVDLRules(NVDLRules rules) throws NVDLModelException {
        if (this.checkTraversedInternal(rules)) {
            return null;
        }
        this.visit(rules.getStartMode());
        return null;
    }
}

