/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.driver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.SAXParser;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.NVDLSAXReader;
import org.eclipse.actf.ai.xmlstore.nvdl.rec.SAXReconstructor;
import org.eclipse.actf.ai.xmlstore.nvdl.util.IRIUtil;
import org.eclipse.actf.ai.xmlstore.nvdl.util.Log;
import org.eclipse.actf.ai.xmlstore.nvdl.util.WritingContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ReconstructionDriver {
    private SAXParser parser;
    private NVDLSAXReader nvdlReader;
    private ErrorHandler eh;

    private void setInput(SAXReconstructor rec, File file) throws Exception {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.setContentHandler(rec.requestInput());
        InputThread ithread = new InputThread(reader, file);
        ithread.start();
    }

    private boolean setupInput(SAXReconstructor rec, File dir) throws Exception {
        if (!dir.isDirectory()) {
            throw new FileNotFoundException(dir + " is not a directory.");
        }
        File[] fileList = dir.listFiles();
        int i = 0;
        while (i < fileList.length) {
            File file = fileList[i];
            if (file.isFile() && file.canRead()) {
                this.setInput(rec, file);
            }
            ++i;
        }
        return true;
    }

    void reconstruct(String nvdlFile, String instanceFilename, String targetDirectory) throws Exception {
        Log.info("ValidationDriver.OpenNVDLFile", new Object[]{nvdlFile});
        NVDLRules rules = this.nvdlReader.parse(IRIUtil.newInputSourceFromFilename(nvdlFile));
        if (rules == null) {
            return;
        }
        SAXReconstructor rec = new SAXReconstructor(rules);
        File instanceFile = new File(instanceFilename);
        FileOutputStream os = new FileOutputStream(instanceFile);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, "utf-8");
        rec.setOutput(new WritingContentHandler(w));
        this.setupInput(rec, new File(targetDirectory));
        rec.start();
    }

    private void setupReader() throws Exception {
        this.parser = NVDLSAXReader.newSAXParser();
        this.parser.getXMLReader().setErrorHandler(this.eh);
        this.nvdlReader = new NVDLSAXReader(this.parser, this.eh);
    }

    ReconstructionDriver(ErrorHandler eh, boolean debug, boolean quiet) throws Exception {
        this.eh = eh;
        this.setupReader();
    }

    private static class InputThread
    extends Thread {
        private XMLReader reader;
        private InputSource inputSource;

        public void run() {
            try {
                this.reader.parse(this.inputSource);
            }
            catch (IOException iOException) {
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }

        InputThread(XMLReader reader, File file) throws IOException {
            super(file.getName());
            this.reader = reader;
            String path = file.getCanonicalPath();
            this.inputSource = IRIUtil.newInputSourceFromFilename(path);
        }
    }
}

