/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.dispatcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.validation.Schema;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.AllowValidatorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLAttributes;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLDispatcherException;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLPlaceHolderAttributes;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLSlotNodeAttributes;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.RejectValidatorHandler;
import org.eclipse.actf.ai.xmlstore.nvdl.fm.Interpretation;
import org.eclipse.actf.ai.xmlstore.nvdl.fm.PDA;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAllowAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRejectAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLValidateAction;
import org.eclipse.actf.ai.xmlstore.nvdl.util.Log;
import org.eclipse.actf.ai.xmlstore.nvdl.util.PrefixMapper;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NVDLSAXDispatcher {
    private NVDLRules rules;
    private PDA pda;
    private final boolean emitSectionID;
    private PrefixMapper prefixMapper = new PrefixMapper();
    private Map<NVDLElement, List<ActiveHandler>> activeHandlersMap = new HashMap<NVDLElement, List<ActiveHandler>>();
    private Set<ActiveHandler> activeHandlers = new HashSet<ActiveHandler>();
    private int errorCounter = 0;
    private XMLReader reader;
    private int asnIDCounter;
    private HashMap<String, IDMapVal> idMap = new HashMap();
    DebugHandlerFactory debugHandlerFactory;
    private int nextSectionIdx;
    private NVDLElement currentElement;
    private final NVDLValidatorHandler validatorHandler = new NVDLValidatorHandler();

    public void reset() {
        this.pda.reset();
        this.prefixMapper.reset();
        this.activeHandlersMap.clear();
        this.activeHandlers.clear();
        this.errorCounter = 0;
        this.currentElement = null;
        this.nextSectionIdx = 0;
        this.idMap.clear();
        this.asnIDCounter = 0;
    }

    public int getErrorCount() {
        return this.errorCounter;
    }

    private void incrementErrorCounter() {
        ++this.errorCounter;
    }

    private void sendVirtualElement(ContentHandler ch, String instancePrefix, String qName, Attributes attrs, boolean requireDecl) throws SAXException {
        Object effectiveMapping = this.prefixMapper.startEffectivePrefixMappings(ch);
        if (requireDecl) {
            ch.startPrefixMapping(instancePrefix, "http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0");
        }
        ch.startElement("http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0", "virtualElement", qName, attrs);
        ch.endElement("http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0", "virtualElement", qName);
        if (requireDecl) {
            ch.endPrefixMapping(instancePrefix);
        }
        this.prefixMapper.endEffectivePrefixMappings(effectiveMapping, ch);
    }

    private NVDLAttributes addASNIDAttribute(Interpretation ip, ContentHandler h, NVDLAttributes attr, String asnID) throws SAXException {
        if (h == null) {
            return attr;
        }
        PrefixMapper.PrefixReturnVal prv = this.prefixMapper.uniquePrefix("nir", "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0");
        String qName = String.valueOf(prv.prefix) + ":" + "asn-id";
        if (prv.requireDecl) {
            h.startPrefixMapping(prv.prefix, "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0");
            this.prefixMapper.startPrefixMapping(prv.prefix, "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0");
            ip.setPrefix(prv.prefix);
        }
        attr.addExtAttribute("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "asn-id", qName, asnID);
        return attr;
    }

    private void dispatchAttributeSection(List<Interpretation> ips, NVDLAttributes attrs, String asnID) throws SAXException {
        for (Interpretation ip : ips) {
            if (!ip.isDispatch()) continue;
            InterpretationSlot slot = this.setupInterpretationSlot(ip, this.currentElement, true);
            ContentHandler h = slot.contentHandler;
            ContentHandler dh = slot.contentHandlerForDebug;
            PrefixMapper.PrefixReturnVal prv = this.prefixMapper.uniquePrefix("nvdlinstance", "http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0");
            String qName = String.valueOf(prv.prefix) + ":" + "virtualElement";
            this.sendVirtualElement(h, prv.prefix, qName, attrs, prv.requireDecl);
            if (dh == null) continue;
            if (this.emitSectionID) {
                attrs = this.addASNIDAttribute(ip, dh, attrs, asnID);
            }
            this.sendVirtualElement(dh, prv.prefix, qName, attrs, prv.requireDecl);
        }
    }

    private NVDLAttributes dispatchAttribute(Interpretation ip, ContentHandler h, Attributes attrs) throws SAXException {
        HashMap<String, NVDLAttributes> attrsMap = new HashMap<String, NVDLAttributes>();
        int len = attrs.getLength();
        NVDLAttributes restAttributes = new NVDLAttributes(this.currentElement, attrs);
        int i = 0;
        while (i < len) {
            String ns = attrs.getURI(i);
            NVDLAttributes pa = (NVDLAttributes)attrsMap.get(ns);
            if (pa == null) {
                pa = new NVDLAttributes(this.currentElement, attrs, ns);
                attrsMap.put(ns, pa);
            }
            pa.addAttribute(i);
            ++i;
        }
        Iterator it = attrsMap.values().iterator();
        boolean isASNIDRequired = false;
        String asnID = this.generateASNID();
        while (it.hasNext()) {
            NVDLAttributes pa = (NVDLAttributes)it.next();
            List<Interpretation> ipAttrs = this.pda.getAttributeInterpretation(ip, pa);
            if (this.pda.isAttributeAttached()) {
                restAttributes.addAttributes(pa);
            } else {
                isASNIDRequired = this.emitSectionID;
            }
            this.dispatchAttributeSection(ipAttrs, pa, asnID);
        }
        if (isASNIDRequired) {
            restAttributes = this.addASNIDAttribute(ip, h, restAttributes, asnID);
        }
        return restAttributes;
    }

    private String generateASNID() {
        return Integer.toString(this.asnIDCounter++);
    }

    private String generateID(Interpretation ip, boolean sectionID, boolean increment) {
        int idNum;
        String id = ip.getID();
        String idForNum = sectionID ? ip.getPrevID() : id;
        IDMapVal idVal = this.idMap.get(idForNum);
        if (idVal == null) {
            idNum = 0;
            this.idMap.put(idForNum, new IDMapVal());
        } else {
            idNum = idVal.slotNodeID++;
            if (sectionID || increment) {
                // empty if block
            }
        }
        if (idNum == 0) {
            return id;
        }
        return String.valueOf(id) + " " + idNum;
    }

    private InterpretationSlot setupInterpretationSlot(Interpretation ip, NVDLElement e, boolean forAttribute) throws SAXException {
        InterpretationSlot slot = (InterpretationSlot)ip.getSlot();
        if (slot != null) {
            return slot;
        }
        NVDLAction a = ip.getAction();
        ContentHandler contentHandler = this.makeContentHandler(a, forAttribute);
        ContentHandler contentHandlerForDebug = this.setupContentHandlerForDebug(this.generateID(ip, true, false), a);
        if (contentHandler != null) {
            this.startActiveHandler(contentHandler, e);
        }
        if (contentHandlerForDebug != null) {
            this.startActiveHandler(contentHandlerForDebug, e);
        }
        slot = new InterpretationSlot(ip, contentHandler, contentHandlerForDebug);
        ip.setSlot(slot);
        return slot;
    }

    private InterpretationSlot getInterpretationSlot(Interpretation ip) {
        return (InterpretationSlot)ip.getSlot();
    }

    public void setDebugHandlerFactory(DebugHandlerFactory f) {
        this.debugHandlerFactory = f;
    }

    private ContentHandler setupContentHandlerForDebug(String id, NVDLAction a) throws SAXException {
        if (this.debugHandlerFactory == null) {
            return null;
        }
        this.debugHandlerFactory.nextActionHandler(a, this.validatorHandler.locator);
        ContentHandler h = this.debugHandlerFactory.createContentHandler(id, a);
        if (h == null) {
            return null;
        }
        if (this.validatorHandler.locator != null) {
            h.setDocumentLocator(this.validatorHandler.locator);
        }
        return h;
    }

    private NVDLElement createNVDLElement(String ns, String localName, NVDLElement parent) {
        NVDLElement e = new NVDLElement(ns, localName, parent, this.rules.getTriggerManager(), this.nextSectionIdx);
        if (e.isSectionHead()) {
            ++this.nextSectionIdx;
        }
        return e;
    }

    private ActiveHandler startActiveHandler(ContentHandler h, NVDLElement e) throws SAXException {
        ActiveHandler ah = new ActiveHandler();
        ah.handler = h;
        ah.rootElement = e;
        h.startDocument();
        ah.effectiveMapping = this.prefixMapper.startEffectivePrefixMappings(h);
        this.activeHandlers.add(ah);
        List<ActiveHandler> ahs = this.activeHandlersMap.get(e);
        if (ahs == null) {
            ahs = new ArrayList<ActiveHandler>();
            this.activeHandlersMap.put(e, ahs);
        }
        ahs.add(ah);
        return ah;
    }

    private void endActiveHandlers(NVDLElement e) throws SAXException {
        List<ActiveHandler> ahs = this.activeHandlersMap.get(e);
        if (ahs == null) {
            return;
        }
        for (ActiveHandler ah : ahs) {
            this.prefixMapper.endEffectivePrefixMappings(ah.effectiveMapping, ah.handler);
            ah.handler.endDocument();
            this.activeHandlers.remove(ah);
        }
        this.activeHandlersMap.put(e, null);
    }

    private ContentHandler makeContentHandlerForValidateAction(NVDLValidateAction validateAction, boolean forAttribute) throws SAXException {
        Schema schema;
        try {
            schema = validateAction.getSchema(forAttribute);
        }
        catch (NVDLException e) {
            if (e.getException() instanceof SAXException) {
                throw (SAXException)e.getException();
            }
            throw new SAXException(e);
        }
        ValidatorHandler h = schema.newValidatorHandler();
        h.setContentHandler(null);
        return h;
    }

    private ContentHandler makeContentHandler(NVDLAction a, boolean forAttribute) throws SAXException {
        ContentHandler contentHandler;
        if (a instanceof NVDLValidateAction) {
            NVDLValidateAction va = (NVDLValidateAction)a;
            contentHandler = this.makeContentHandlerForValidateAction(va, forAttribute);
        } else if (a instanceof NVDLAllowAction) {
            contentHandler = new AllowValidatorHandler();
        } else if (a instanceof NVDLRejectAction) {
            contentHandler = new RejectValidatorHandler();
        } else {
            return null;
        }
        if (this.validatorHandler.locator != null) {
            contentHandler.setDocumentLocator(this.validatorHandler.locator);
        }
        return contentHandler;
    }

    public ValidatorHandler getValidatorHandler() {
        return this.validatorHandler;
    }

    public boolean validate(InputSource is, ErrorHandler eh) throws SAXException, IOException {
        ValidatorHandler h = this.getValidatorHandler();
        h.setErrorHandler(eh);
        this.reader.setErrorHandler(eh);
        this.reader.parse(is);
        return this.getErrorCount() <= 0;
    }

    public NVDLSAXDispatcher(NVDLRules rules, boolean emitSectionID) throws SAXException {
        this.rules = rules;
        this.pda = new PDA(rules);
        this.emitSectionID = emitSectionID;
        this.reader = XMLReaderFactory.createXMLReader();
        this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
        this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        ValidatorHandler h = this.getValidatorHandler();
        this.reader.setContentHandler(h);
    }

    static /* synthetic */ void access$12(NVDLSAXDispatcher nVDLSAXDispatcher, NVDLElement nVDLElement) throws SAXException {
        nVDLSAXDispatcher.endActiveHandlers(nVDLElement);
    }

    static class ActiveHandler {
        ContentHandler handler;
        NVDLElement rootElement;
        Object effectiveMapping;

        ActiveHandler() {
        }
    }

    public static interface DebugHandlerFactory {
        public ContentHandler createContentHandler(String var1, NVDLAction var2) throws SAXException;

        public void nextActionHandler(NVDLAction var1, Locator var2);
    }

    private static class IDMapVal {
        int sectionID;
        int slotNodeID;

        private IDMapVal() {
        }
    }

    private class InterpretationSlot
    implements ErrorHandler {
        ContentHandler contentHandler;
        ContentHandler contentHandlerForDebug;
        String definedPrefix;
        final Interpretation ip;
        private final ErrorHandler errorHandler;

        private SAXParseException encapsulateException(SAXParseException e) {
            NVDLDispatcherException de = new NVDLDispatcherException(e.getException(), this.ip.getAction());
            return new SAXParseException(e.getMessage(), e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), de);
        }

        public void warning(SAXParseException e) throws SAXException {
            if (this.errorHandler != null) {
                this.errorHandler.warning(this.encapsulateException(e));
            }
        }

        public void error(SAXParseException e) throws SAXException {
            NVDLSAXDispatcher.this.incrementErrorCounter();
            if (this.errorHandler != null) {
                this.errorHandler.error(this.encapsulateException(e));
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            NVDLSAXDispatcher.this.incrementErrorCounter();
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(this.encapsulateException(e));
            }
        }

        InterpretationSlot(Interpretation ip, ContentHandler contentHandler, ContentHandler contentHandlerForDebug) {
            this.ip = ip;
            this.contentHandler = contentHandler;
            this.contentHandlerForDebug = contentHandlerForDebug;
            this.errorHandler = NVDLSAXDispatcher.this.validatorHandler.getErrorHandler();
            if (contentHandler instanceof ValidatorHandler) {
                ((ValidatorHandler)contentHandler).setErrorHandler(this);
            }
        }
    }

    private class NVDLValidatorHandler
    extends ValidatorHandler {
        private ContentHandler contentHandler = null;
        private ErrorHandler errorHandler = null;
        private LSResourceResolver resourceResolver = null;
        Locator locator;

        private NVDLValidatorHandler() {
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        public void setResourceResolver(LSResourceResolver resourceResolver) {
            this.resourceResolver = resourceResolver;
        }

        public LSResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        public TypeInfoProvider getTypeInfoProvider() {
            return null;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            for (ActiveHandler ah : NVDLSAXDispatcher.this.activeHandlers) {
                ah.handler.setDocumentLocator(locator);
            }
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
            for (ActiveHandler ah : NVDLSAXDispatcher.this.activeHandlers) {
                Log.error("All handlers must be deactivated." + ah);
                ah.handler.endDocument();
            }
            NVDLSAXDispatcher.this.activeHandlers.clear();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            NVDLSAXDispatcher.this.prefixMapper.startPrefixMapping(prefix, uri);
            for (ActiveHandler ah : NVDLSAXDispatcher.this.activeHandlers) {
                ah.handler.startPrefixMapping(prefix, uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            NVDLSAXDispatcher.this.prefixMapper.endPrefixMapping(prefix);
            for (ActiveHandler ah : NVDLSAXDispatcher.this.activeHandlers) {
                ah.handler.endPrefixMapping(prefix);
            }
        }

        private void dispatchPlaceHolder(ContentHandler h, String uri, String localName) throws SAXException {
            NVDLPlaceHolderAttributes ats = new NVDLPlaceHolderAttributes(uri, localName);
            NVDLSAXDispatcher.this.prefixMapper.sendEmptyElement(h, "http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0", "placeholder", "nvdlinstance", ats);
        }

        private void dispatchElementSlotNodeStart(Interpretation ip, ContentHandler h) throws SAXException {
            NVDLSlotNodeAttributes ats = new NVDLSlotNodeAttributes("slot-node-id", NVDLSAXDispatcher.this.generateID(ip, false, false));
            NVDLSAXDispatcher.this.prefixMapper.sendEmptyElement(h, "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "slot-node", "nir", ats);
        }

        private void dispatchElementSlotNodeEnd(Interpretation ip, ContentHandler h) throws SAXException {
            NVDLSlotNodeAttributes ats = new NVDLSlotNodeAttributes("slot-node-id", NVDLSAXDispatcher.this.generateID(ip, false, true));
            NVDLSAXDispatcher.this.prefixMapper.sendEmptyElement(h, "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "slot-node-end", "nir", ats);
        }

        private void addSectionIDAttribute(Interpretation ip, ContentHandler h, NVDLAttributes attr) throws SAXException {
            if (h == null) {
                return;
            }
            PrefixMapper.PrefixReturnVal prv = NVDLSAXDispatcher.this.prefixMapper.uniquePrefix("nir", "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0");
            String qName = String.valueOf(prv.prefix) + ":" + "sect-id";
            if (prv.requireDecl) {
                h.startPrefixMapping(prv.prefix, "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0");
                NVDLSAXDispatcher.this.prefixMapper.startPrefixMapping(prv.prefix, "http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0");
                ip.setPrefix(prv.prefix);
            }
            attr.addExtAttribute("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "sect-id", qName, NVDLSAXDispatcher.this.generateID(ip, true, true));
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            InterpretationSlot slot;
            NVDLSAXDispatcher.this.currentElement = NVDLSAXDispatcher.this.createNVDLElement(uri, localName, NVDLSAXDispatcher.this.currentElement);
            if (NVDLSAXDispatcher.this.currentElement.isSectionHead()) {
                List prevIps = NVDLSAXDispatcher.this.pda.getCurrentInterpretations();
                for (Interpretation ip : prevIps) {
                    Interpretation ipHead = ip.getEffectiveInterpretation();
                    if (ipHead == null || !ipHead.isDispatch()) continue;
                    slot = NVDLSAXDispatcher.this.setupInterpretationSlot(ipHead, NVDLSAXDispatcher.this.currentElement, false);
                    ContentHandler dh = slot.contentHandlerForDebug;
                    if (dh == null) continue;
                    this.dispatchElementSlotNodeStart(ip, dh);
                }
            }
            NVDLSAXDispatcher.this.pda.startElement(NVDLSAXDispatcher.this.currentElement);
            List ips = NVDLSAXDispatcher.this.pda.getCurrentInterpretations();
            for (Interpretation ip : ips) {
                Interpretation ipDispatch = ip.getEffectiveInterpretation();
                if (ipDispatch == null) continue;
                slot = NVDLSAXDispatcher.this.setupInterpretationSlot(ipDispatch, NVDLSAXDispatcher.this.currentElement, false);
                ContentHandler h = slot.contentHandler;
                ContentHandler dh = slot.contentHandlerForDebug;
                if (ip.isAttachPlaceHolder()) {
                    if (!NVDLSAXDispatcher.this.currentElement.isSectionHead()) continue;
                    this.dispatchPlaceHolder(h, uri, localName);
                    if (dh == null) continue;
                    this.dispatchPlaceHolder(dh, uri, localName);
                    continue;
                }
                NVDLAttributes rest = NVDLSAXDispatcher.this.dispatchAttribute(ip, dh, attrs);
                h.startElement(uri, localName, qName, rest);
                if (dh == null) continue;
                if (NVDLSAXDispatcher.this.emitSectionID && NVDLSAXDispatcher.this.currentElement.isSectionHead()) {
                    this.addSectionIDAttribute(ip, dh, rest);
                }
                dh.startElement(uri, localName, qName, rest);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ips = NVDLSAXDispatcher.access$8(NVDLSAXDispatcher.this).getCurrentInterpretations();
            it = ips.iterator();
            if (NVDLSAXDispatcher.access$5(NVDLSAXDispatcher.this) != null) ** GOTO lbl18
            Log.error("Something wrong happens.  Some tags are not balanced.");
            return;
lbl-1000:
            // 1 sources

            {
                ip = (Interpretation)it.next();
                if (ip.isAttachPlaceHolder() || (ipDispatch = ip.getEffectiveInterpretation()) == null) continue;
                slot = NVDLSAXDispatcher.access$9(NVDLSAXDispatcher.this, ipDispatch, NVDLSAXDispatcher.access$5(NVDLSAXDispatcher.this), false);
                h = slot.contentHandler;
                dh = slot.contentHandlerForDebug;
                h.endElement(uri, localName, qName);
                if (dh == null) continue;
                dh.endElement(uri, localName, qName);
                if (ip.getPrefix() == null) continue;
                NVDLSAXDispatcher.access$3(NVDLSAXDispatcher.this).endPrefixMapping(ip.getPrefix());
                dh.endPrefixMapping(ip.getPrefix());
                ip.setPrefix(null);
lbl18:
                // 5 sources

                ** while (it.hasNext())
            }
lbl19:
            // 1 sources

            NVDLSAXDispatcher.access$12(NVDLSAXDispatcher.this, NVDLSAXDispatcher.access$5(NVDLSAXDispatcher.this));
            NVDLSAXDispatcher.access$8(NVDLSAXDispatcher.this).endElement();
            if (NVDLSAXDispatcher.access$5(NVDLSAXDispatcher.this).isSectionHead()) {
                prevIps = NVDLSAXDispatcher.access$8(NVDLSAXDispatcher.this).getCurrentInterpretations();
                for (Interpretation ip : prevIps) {
                    ipHead = ip.getEffectiveInterpretation();
                    if (ipHead == null || !ipHead.isDispatch()) continue;
                    slot = NVDLSAXDispatcher.access$9(NVDLSAXDispatcher.this, ipHead, NVDLSAXDispatcher.access$5(NVDLSAXDispatcher.this), false);
                    dh = slot.contentHandlerForDebug;
                    if (dh == null) continue;
                    this.dispatchElementSlotNodeEnd(ip, dh);
                }
            }
            NVDLSAXDispatcher.access$7(NVDLSAXDispatcher.this, NVDLSAXDispatcher.access$5((NVDLSAXDispatcher)NVDLSAXDispatcher.this).parent);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            List ips = NVDLSAXDispatcher.this.pda.getCurrentInterpretations();
            for (Interpretation ip : ips) {
                Interpretation ipDispatch;
                if (ip.isAttachPlaceHolder() || (ipDispatch = ip.getEffectiveInterpretation()) == null) continue;
                InterpretationSlot slot = NVDLSAXDispatcher.this.getInterpretationSlot(ipDispatch);
                ContentHandler h = slot.contentHandler;
                ContentHandler dh = slot.contentHandlerForDebug;
                h.characters(ch, start, length);
                if (dh == null) continue;
                dh.characters(ch, start, length);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            List ips = NVDLSAXDispatcher.this.pda.getCurrentInterpretations();
            for (Interpretation ip : ips) {
                Interpretation ipDispatch;
                if (ip.isAttachPlaceHolder() || (ipDispatch = ip.getEffectiveInterpretation()) == null) continue;
                InterpretationSlot slot = NVDLSAXDispatcher.this.getInterpretationSlot(ipDispatch);
                ContentHandler h = slot.contentHandler;
                ContentHandler dh = slot.contentHandlerForDebug;
                h.ignorableWhitespace(ch, start, length);
                if (dh == null) continue;
                dh.ignorableWhitespace(ch, start, length);
            }
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

