/**
 * <copyright>
 * 
 * Copyright (c) 2014-2016 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 *     itemis - [503063] Provide launching support for Sphinx Workflows
 *     itemis - [506671] Add support for specifying and injecting user-defined arguments for workflows through workflow launch configurations
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.simple.xtend;

import java.util.Map;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.examples.workflows.lib.ExampleWorkflowHelper;
import org.eclipse.sphinx.examples.workflows.lib.ModelWorkflowExtensions;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class SimpleXtendWorkflowComponent extends AbstractWorkflowComponent2 {
  @Override
  protected void invokeInternal(final WorkflowContext ctx, final ProgressMonitor monitor, final Issues issues) {
    InputOutput.<String>println("Executing simple Xtend-based workflow component");
    Map<String, Object> _argumentsSlot = ModelWorkflowExtensions.getArgumentsSlot(ctx);
    String _plus = ("Arguments: " + _argumentsSlot);
    InputOutput.<String>println(_plus);
    InputOutput.<String>println(("Using some class from another project: " + ExampleWorkflowHelper.class));
    final ExampleWorkflowHelper helper = new ExampleWorkflowHelper();
    helper.doSomething();
    InputOutput.<String>println("Done!");
  }
}
