/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sphinx.emf.ui.properties.FilteringPropertySource;
import org.eclipse.sphinx.emf.ui.properties.ProxyURICellEditor;
import org.eclipse.sphinx.emf.ui.properties.ProxyURIFeatureEditorDialog;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.tabbed.AdvancedPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicTransactionalAdvancedPropertySection
extends AdvancedPropertySection
implements IPropertySourceProvider {
    protected TabbedPropertySheetPage tabbedPropertySheetPage;
    protected IPropertySourceProvider lastPropertySourceProviderDelegate = null;
    protected ResourceSetListenerImpl selectedObjectChangedListener = null;
    protected Object lastSelectedObject = null;
    protected ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object selectedObject;
            IStructuredSelection structuredSelection;
            if (BasicTransactionalAdvancedPropertySection.this.tabbedPropertySheetPage != null && !(structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection)).isEmpty() && (selectedObject = BasicTransactionalAdvancedPropertySection.this.unwrap(structuredSelection.getFirstElement())) != BasicTransactionalAdvancedPropertySection.this.lastSelectedObject) {
                TransactionalEditingDomain oldEditingDomain = TransactionUtil.getEditingDomain((Object)BasicTransactionalAdvancedPropertySection.this.lastSelectedObject);
                if (oldEditingDomain != null) {
                    oldEditingDomain.removeResourceSetListener((ResourceSetListener)BasicTransactionalAdvancedPropertySection.this.selectedObjectChangedListener);
                }
                BasicTransactionalAdvancedPropertySection.this.lastSelectedObject = selectedObject;
                TransactionalEditingDomain newEditingDomain = TransactionUtil.getEditingDomain((Object)selectedObject);
                if (newEditingDomain != null) {
                    BasicTransactionalAdvancedPropertySection.this.selectedObjectChangedListener = BasicTransactionalAdvancedPropertySection.this.createSelectedObjectChangedListener(selectedObject);
                    newEditingDomain.addResourceSetListener((ResourceSetListener)BasicTransactionalAdvancedPropertySection.this.selectedObjectChangedListener);
                }
            }
        }
    };

    protected ResourceSetListenerImpl createSelectedObjectChangedListener(Object selectedObject) {
        Assert.isNotNull((Object)selectedObject);
        return new ResourceSetListenerImpl(NotificationFilter.createNotifierFilter((Object)selectedObject)){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                IPageSite site;
                if (BasicTransactionalAdvancedPropertySection.this.tabbedPropertySheetPage != null && (site = BasicTransactionalAdvancedPropertySection.this.tabbedPropertySheetPage.getSite()) != null) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (BasicTransactionalAdvancedPropertySection.this.page != null) {
                                BasicTransactionalAdvancedPropertySection.this.refresh();
                                if ((this).BasicTransactionalAdvancedPropertySection.this.tabbedPropertySheetPage != null) {
                                    (this).BasicTransactionalAdvancedPropertySection.this.tabbedPropertySheetPage.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)new BaseLabelProvider()));
                                }
                            }
                        }
                    });
                }
            }
        };
    }

    protected Object unwrap(Object element) {
        if (element instanceof FeatureMapEntryWrapperItemProvider) {
            return element;
        }
        return AdapterFactoryEditingDomain.unwrap((Object)element);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.tabbedPropertySheetPage = tabbedPropertySheetPage;
        this.createEmbeddedStandardPropertySheetPage(parent);
        ISelectionService selectionService = tabbedPropertySheetPage.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener(this.selectionListener);
        this.selectionListener.selectionChanged(this.getPart(), selectionService.getSelection());
    }

    protected void createEmbeddedStandardPropertySheetPage(Composite parent) {
        this.page.setPropertySourceProvider((IPropertySourceProvider)this);
        IActionBars actionBars = this.tabbedPropertySheetPage.getSite().getActionBars();
        this.page.makeContributions(actionBars.getMenuManager(), actionBars.getToolBarManager(), actionBars.getStatusLineManager());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<Object> translatedSelection = new ArrayList<Object>(structuredSelection.size());
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                Object unwrapped = this.unwrap(it.next());
                if (unwrapped == null) continue;
                translatedSelection.add(unwrapped);
            }
            selection = new StructuredSelection(translatedSelection);
        }
        super.setInput(part, selection);
    }

    public IPropertySource getPropertySource(Object object) {
        if (object != null) {
            IPropertySource propertySource;
            TransactionalEditingDomain editingDomain = this.getEditingDomain(object);
            if (editingDomain != null) {
                this.lastPropertySourceProviderDelegate = this.createModelPropertySourceProvider(editingDomain);
            }
            if (this.lastPropertySourceProviderDelegate != null && (propertySource = this.lastPropertySourceProviderDelegate.getPropertySource(object)) != null) {
                return new FilteringPropertySource(propertySource);
            }
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return (IPropertySource)adaptable.getAdapter(IPropertySource.class);
        }
        return null;
    }

    private TransactionalEditingDomain getEditingDomain(Object object) {
        TransactionalEditingDomain editingDomain = null;
        if (object instanceof WrapperItemProvider) {
            Object wrappedValue = ((WrapperItemProvider)object).getValue();
            if (wrappedValue instanceof FeatureMap.Entry) {
                Object value = ((FeatureMap.Entry)wrappedValue).getValue();
                editingDomain = TransactionUtil.getEditingDomain((Object)value);
            }
        } else {
            editingDomain = TransactionUtil.getEditingDomain((Object)object);
        }
        return editingDomain;
    }

    protected IPropertySourceProvider createModelPropertySourceProvider(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        return new TransactionalAdapterFactoryContentProvider(editingDomain, adapterFactory){

            protected IPropertySource createPropertySource(final Object object, final IItemPropertySource itemPropertySource) {
                return this.wrap((IPropertySource)this.run((RunnableWithResult)new RunnableWithResult.Impl<IPropertySource>(){

                    public void run() {
                        this.setResult(new PropertySource(object, itemPropertySource){

                            protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                                return new PropertyDescriptor(this.object, itemPropertyDescriptor){

                                    public CellEditor createPropertyEditor(Composite composite) {
                                        CellEditor editor = BasicTransactionalAdvancedPropertySection.this.createPropertyEditor(composite, this.object, this.itemPropertyDescriptor, this);
                                        if (editor != null) {
                                            return editor;
                                        }
                                        return super.createPropertyEditor(composite);
                                    }
                                };
                            }
                        });
                    }
                }));
            }
        };
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    protected CellEditor createPropertyEditor(Composite composite, Object object, final IItemPropertyDescriptor itemPropertyDescriptor, final PropertyDescriptor propertyDescriptor) {
        EObject eObject;
        Object feature;
        if (object instanceof EObject && (feature = itemPropertyDescriptor.getFeature((Object)(eObject = (EObject)object))) instanceof EReference) {
            final EReference reference = (EReference)feature;
            if (!reference.isMany()) {
                EObject value;
                Collection choiceOfValues = itemPropertyDescriptor.getChoiceOfValues((Object)eObject);
                if (choiceOfValues != null && (value = (EObject)choiceOfValues.iterator().next()) != null && value.eIsProxy()) {
                    return new ProxyURICellEditor(composite, eObject, (EStructuralFeature)reference, value);
                }
            } else {
                final Collection choiceOfValues = itemPropertyDescriptor.getChoiceOfValues((Object)eObject);
                if (choiceOfValues != null) {
                    for (Object element : choiceOfValues) {
                        EObject value = (EObject)element;
                        if (!value.eIsProxy()) continue;
                        final ILabelProvider editLabelProvider = propertyDescriptor.getLabelProvider();
                        return new ExtendedDialogCellEditor(composite, editLabelProvider){

                            protected Object openDialogBox(Control cellEditorWindow) {
                                ProxyURIFeatureEditorDialog dialog = new ProxyURIFeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, eObject, (EStructuralFeature)reference, propertyDescriptor.getDisplayName(), new ArrayList(choiceOfValues), false, itemPropertyDescriptor.isSortChoices((Object)eObject));
                                dialog.open();
                                return dialog.getResult();
                            }
                        };
                    }
                }
            }
        }
        return null;
    }

    public void dispose() {
        if (this.selectedObjectChangedListener != null) {
            for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainUtil.getAllEditingDomains()) {
                editingDomain.removeResourceSetListener((ResourceSetListener)this.selectedObjectChangedListener);
            }
        }
        if (this.selectionListener != null) {
            IPageSite site;
            ISelectionService selectionService = null;
            if (this.tabbedPropertySheetPage != null && (site = this.tabbedPropertySheetPage.getSite()) != null) {
                selectionService = site.getWorkbenchWindow().getSelectionService();
            }
            if (selectionService == null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                    window = windows[0];
                }
                if (window != null) {
                    selectionService = window.getSelectionService();
                }
            }
            if (selectionService != null) {
                selectionService.removeSelectionListener(this.selectionListener);
            }
        }
        super.dispose();
    }
}

