/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.util;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class URIExtensions {
    public static final String URI_SEGMENT_SEPARATOR = "/";
    public static final String URI_AUTHORITY_SEPARATOR = "//";
    public static final String URI_QUERY_SEPARATOR = "?";
    public static final String URI_FRAGMENT_SEPARATOR = "#";

    public static boolean isActual(URI uri) {
        Assert.isNotNull((Object)uri);
        return !StringExtensions.isNullOrEmpty((String)uri.scheme()) || uri.hasDevice() || uri.hasAuthority() || uri.hasPath() && uri.segmentCount() > 1 || uri.hasTrailingPathSeparator() || uri.hasQuery() || uri.hasFragment();
    }

    public static URI getFragment(URI uri) {
        Assert.isNotNull((Object)uri);
        boolean _hasFragment = uri.hasFragment();
        if (_hasFragment) {
            String fragment = uri.fragment();
            boolean _startsWith = fragment.startsWith(URI_AUTHORITY_SEPARATOR);
            if (_startsWith) {
                int queryIdx = fragment.indexOf(URI_QUERY_SEPARATOR);
                String _xifexpression = null;
                _xifexpression = queryIdx != -1 ? fragment.substring(0, queryIdx) : fragment;
                String path = _xifexpression;
                String _xifexpression_1 = null;
                _xifexpression_1 = queryIdx != -1 && fragment.length() > queryIdx + 1 ? fragment.substring(queryIdx + 1, fragment.length()) : null;
                String query = _xifexpression_1;
                return URI.createHierarchicalURI((String[])path.split(URI_SEGMENT_SEPARATOR), query, null);
            }
            return URI.createURI((String)fragment, (boolean)true);
        }
        return null;
    }

    public static URI substituteFragment(URI uri, URI fragment) {
        boolean _notEquals;
        Assert.isNotNull((Object)uri);
        URI result = uri.trimFragment();
        boolean bl = _notEquals = !Objects.equal((Object)fragment, null);
        if (_notEquals) {
            result = result.appendFragment(fragment.toString());
        }
        return result;
    }

    public static URI asPrefix(URI uri) {
        boolean _not;
        Assert.isNotNull((Object)uri);
        URI result = uri.trimQuery();
        result = result.trimFragment();
        boolean _hasTrailingPathSeparator = result.hasTrailingPathSeparator();
        boolean bl = _not = !_hasTrailingPathSeparator;
        if (_not) {
            result = result.appendSegment("");
        }
        return result;
    }

    public static URI replaceLastSegment(URI uri, String oldLastSegment, String newLastSegment) {
        Assert.isNotNull((Object)uri);
        int _segmentCount = uri.segmentCount();
        boolean _greaterThan = _segmentCount > 0;
        Assert.isLegal((boolean)_greaterThan);
        boolean _equals = uri.lastSegment().equals(oldLastSegment);
        if (_equals) {
            return uri.trimSegments(1).appendSegment(newLastSegment);
        }
        return null;
    }

    public static URI replaceBaseURI(URI uri, URI oldBaseURI, URI newBaseURI) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)oldBaseURI);
        Assert.isNotNull((Object)newBaseURI);
        if (uri.hasFragment() && oldBaseURI.hasFragment() && newBaseURI.hasFragment()) {
            boolean _equals = uri.trimFragment().equals(oldBaseURI.trimFragment());
            if (_equals) {
                boolean _notEquals;
                URI fragment = URIExtensions.getFragment(uri).replacePrefix(URIExtensions.asPrefix(URIExtensions.getFragment(oldBaseURI)), URIExtensions.asPrefix(URIExtensions.getFragment(newBaseURI)));
                boolean bl = _notEquals = !Objects.equal((Object)fragment, null);
                if (_notEquals) {
                    return URIExtensions.substituteFragment(newBaseURI, fragment);
                }
            }
        } else {
            return uri.replacePrefix(URIExtensions.asPrefix(oldBaseURI), URIExtensions.asPrefix(newBaseURI));
        }
        return null;
    }

    public static URI replaceLastFragmentSegment(URI uri, String oldLastFragmentSegment, String newLastFragmentSegment) {
        boolean _notEquals;
        Assert.isNotNull((Object)uri);
        URI fragment = URIExtensions.getFragment(uri);
        boolean bl = _notEquals = !Objects.equal((Object)fragment, null);
        if (_notEquals) {
            boolean _notEquals_1;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)(fragment = URIExtensions.replaceLastSegment(fragment, oldLastFragmentSegment, newLastFragmentSegment)), null);
            if (_notEquals_1) {
                return URIExtensions.substituteFragment(uri, fragment);
            }
        }
        return null;
    }
}

