/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyBooleanIterable;

public class TapBooleanIterable
extends AbstractLazyBooleanIterable {
    private final BooleanIterable adapted;
    private final BooleanProcedure procedure;

    public TapBooleanIterable(BooleanIterable delegate, BooleanProcedure procedure) {
        this.adapted = delegate;
        this.procedure = procedure;
    }

    public void each(BooleanProcedure procedure) {
        this.adapted.forEach((BooleanProcedure & Serializable)each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.adapted.anySatisfy((BooleanPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.adapted.allSatisfy((BooleanPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.adapted.noneSatisfy((BooleanPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.adapted.detectIfNone((BooleanPredicate & Serializable)each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        }, ifNone);
    }

    public BooleanIterator booleanIterator() {
        return new TapBooleanIterator(this.adapted, this.procedure);
    }

    public static class TapBooleanIterator
    implements BooleanIterator {
        private final BooleanIterator iterator;
        private final BooleanProcedure procedure;

        public TapBooleanIterator(BooleanIterable iterable, BooleanProcedure procedure) {
            this(iterable.booleanIterator(), procedure);
        }

        public TapBooleanIterator(BooleanIterator iterator, BooleanProcedure procedure) {
            this.iterator = iterator;
            this.procedure = procedure;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public boolean next() {
            boolean next = this.iterator.next();
            this.procedure.value(next);
            return next;
        }
    }
}

