/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.nio.channels.AsynchronousCloseException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP2
extends HttpConnection
implements Sweeper.Sweepable,
ConnectionPool.Multiplexable {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final Set<HttpChannel> activeChannels = ConcurrentHashMap.newKeySet();
    private final Queue<HttpChannelOverHTTP2> idleChannels = new ConcurrentLinkedQueue<HttpChannelOverHTTP2>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Session session;
    private boolean recycleHttpChannels = true;

    public HttpConnectionOverHTTP2(HttpDestination destination, Session session) {
        super(destination);
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isRecycleHttpChannels() {
        return this.recycleHttpChannels;
    }

    public void setRecycleHttpChannels(boolean recycleHttpChannels) {
        this.recycleHttpChannels = recycleHttpChannels;
    }

    public int getMaxMultiplex() {
        return ((HTTP2Session)this.session).getMaxLocalStreams();
    }

    protected Iterator<HttpChannel> getHttpChannels() {
        return this.activeChannels.iterator();
    }

    protected SendFailure send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        request.version(HttpVersion.HTTP_2);
        this.normalizeRequest((Request)request);
        HttpChannelOverHTTP2 channel = this.acquireHttpChannel();
        this.activeChannels.add(channel);
        return this.send(channel, exchange);
    }

    protected HttpChannelOverHTTP2 acquireHttpChannel() {
        HttpChannelOverHTTP2 channel = this.idleChannels.poll();
        if (channel == null) {
            channel = this.newHttpChannel();
        }
        return channel;
    }

    protected HttpChannelOverHTTP2 newHttpChannel() {
        return new HttpChannelOverHTTP2(this.getHttpDestination(), this, this.getSession());
    }

    protected boolean release(HttpChannelOverHTTP2 channel) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", new Object[]{channel});
        }
        if (this.activeChannels.remove((Object)channel)) {
            if (channel.isFailed()) {
                channel.destroy();
            } else if (this.isRecycleHttpChannels()) {
                this.idleChannels.offer(channel);
            }
            return true;
        }
        channel.destroy();
        return false;
    }

    public boolean onIdleTimeout(long idleTimeout) {
        boolean close = super.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(new TimeoutException("idle_timeout"));
        }
        return false;
    }

    void remove() {
        this.getHttpDestination().remove((Connection)this);
    }

    public void close() {
        this.close(new AsynchronousCloseException());
        this.destroy();
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove((Connection)this);
            this.abort(failure);
            this.session.close(ErrorCode.NO_ERROR.code, failure.getMessage(), Callback.NOOP);
            HttpChannel channel = this.idleChannels.poll();
            while (channel != null) {
                channel.destroy();
                channel = this.idleChannels.poll();
            }
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.activeChannels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.activeChannels.clear();
        HttpChannel channel = this.idleChannels.poll();
        while (channel != null) {
            channel.destroy();
            channel = this.idleChannels.poll();
        }
    }

    public boolean sweep() {
        if (!this.isClosed()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    public String toString() {
        return String.format("%s@%x(closed=%b)[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.isClosed(), this.session);
    }
}

