/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.query.explanation.Explanation;

public class ExplainQueryResultView
extends QueryResultView {
    private static final String MIME_PLAIN = "text/plain";
    private static final String MIME_JSON = "application/json";

    @Override
    protected void renderInternal(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String mimeType = this.getRequestedMimeType(request);
        Explanation explanation = (Explanation)model.get("explainResult");
        if (explanation == null) {
            response.sendError(400, "No explanation result found.");
            return;
        }
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();){
            if (MIME_JSON.equals(mimeType)) {
                response.setContentType(MIME_JSON);
                writer.write(explanation.toJson());
            } else if (MIME_PLAIN.equals(mimeType) || mimeType == null || mimeType.isEmpty()) {
                response.setContentType(MIME_PLAIN);
                writer.write(explanation.toString());
            } else {
                response.sendError(400, "Unsupported MIME type: " + mimeType + ". Must be either text/plain or application/json.");
            }
        }
    }

    private String getRequestedMimeType(HttpServletRequest request) {
        String mimeType = request.getParameter("Accept");
        return mimeType != null ? mimeType : request.getHeader("Accept");
    }
}

