/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.FedXStatementPattern;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.iterator.InsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.WorkerUnionBase;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.repository.RepositoryException;

public class StatementSourcePattern
extends FedXStatementPattern {
    private static final long serialVersionUID = 7548505818766482715L;
    protected boolean usePreparedQuery = false;
    protected final FederationContext federationContext;

    public StatementSourcePattern(StatementPattern node, QueryInfo queryInfo) {
        super(node, queryInfo);
        this.federationContext = queryInfo.getFederationContext();
    }

    public void addStatementSource(StatementSource statementSource) {
        this.statementSources.add(statementSource);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindings) throws QueryEvaluationException {
        try (WorkerUnionBase<BindingSet> union = null;){
            AtomicBoolean isEvaluated = new AtomicBoolean(false);
            String preparedQuery = null;
            union = this.federationContext.getManager().createWorkerUnion(this.queryInfo);
            for (StatementSource source : this.statementSources) {
                Endpoint ownedEndpoint = this.queryInfo.getFederationContext().getEndpointManager().getEndpoint(source.getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                if (t.usePreparedQuery(this, this.queryInfo)) {
                    if (preparedQuery == null) {
                        try {
                            preparedQuery = QueryStringUtil.selectQueryString(this, bindings, this.filterExpr, isEvaluated, this.queryInfo.getDataset());
                        }
                        catch (IllegalQueryException e1) {
                            InsertBindingsIteration res = this.handleStatementSourcePatternCheck(bindings);
                            if (this.boundFilters != null && !(res instanceof EmptyIteration)) {
                                res = new InsertBindingsIteration(res, this.boundFilters);
                            }
                            return res;
                        }
                    }
                    union.addTask(new ParallelPreparedUnionTask(union, preparedQuery, ownedEndpoint, bindings, isEvaluated.get() ? null : this.filterExpr, this.queryInfo));
                    continue;
                }
                union.addTask(new ParallelUnionTask(union, this, ownedEndpoint, bindings, this.filterExpr, this.queryInfo));
            }
            union.run();
            if (this.boundFilters != null) {
                return new InsertBindingsIteration(union, this.boundFilters);
            }
            return union;
        }
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> handleStatementSourcePatternCheck(BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        for (StatementSource source : this.statementSources) {
            Endpoint ownedEndpoint = this.queryInfo.getFederationContext().getEndpointManager().getEndpoint(source.getEndpointID());
            TripleSource t = ownedEndpoint.getTripleSource();
            if (!t.hasStatements(this, bindings, this.queryInfo, this.queryInfo.getDataset())) continue;
            return new SingleBindingSetIteration(bindings);
        }
        return new EmptyIteration<BindingSet, QueryEvaluationException>();
    }
}

