/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

class ShapeSourceHelper {
    ShapeSourceHelper() {
    }

    static Value getFirst(SailConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (CloseableIteration<? extends Statement, SailException> iteration = connection.getStatements(subject, RDF.FIRST, null, true, context);){
            Value value = ShapeSourceHelper.getObject(iteration);
            return value;
        }
    }

    static Value getFirst(RepositoryConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (RepositoryResult<Statement> iteration = connection.getStatements(subject, RDF.FIRST, null, true, context);){
            Value value = ShapeSourceHelper.getObject(iteration);
            return value;
        }
    }

    static Resource getRdfRest(RepositoryConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (RepositoryResult<Statement> iteration = connection.getStatements(subject, RDF.REST, null, true, context);){
            Resource resource = (Resource)ShapeSourceHelper.getObject(iteration);
            return resource;
        }
    }

    static Resource getRdfRest(SailConnection connection, Resource subject, Resource[] context) {
        assert (context != null);
        try (CloseableIteration<? extends Statement, SailException> iteration = connection.getStatements(subject, RDF.REST, null, true, context);){
            Resource resource = (Resource)ShapeSourceHelper.getObject(iteration);
            return resource;
        }
    }

    private static Value getObject(CloseableIteration<? extends Statement, SailException> iteration) {
        if (iteration.hasNext()) {
            return ((Statement)iteration.next()).getObject();
        }
        return null;
    }

    private static Value getObject(RepositoryResult<Statement> iteration) {
        if (iteration.hasNext()) {
            return iteration.next().getObject();
        }
        return null;
    }
}

