/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.MultiColumnPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DebugPrinter
extends MultiColumnPrinter {
    private static final long serialVersionUID = 3312334387486018119L;
    private Hashtable hashtable = null;
    private Vector vector = null;
    private String filename = null;
    private File f;
    private FileOutputStream fos;
    private PrintStream ps = System.out;
    private StringBuffer buffer = new StringBuffer(1024);
    private static String nl = System.getProperty("line.separator");

    public DebugPrinter(int gap) {
        this(null, gap);
    }

    public DebugPrinter(Hashtable hashtable, int gap) {
        this(hashtable, gap, null);
    }

    public DebugPrinter(Vector v, int gap, String filename) {
        super(2, gap, "-");
        this.filename = filename;
        this.vector = v;
        this.initOutput();
        this.setupTitle();
        this.setupData();
    }

    public DebugPrinter(Hashtable hashtable, int gap, String filename) {
        super(2, gap, "-");
        this.filename = filename;
        this.hashtable = hashtable;
        this.initOutput();
        this.setupTitle();
        this.setupData();
    }

    public void setHashtable(Hashtable h) {
        this.hashtable = h;
        this.clear();
        this.setupData();
    }

    public void setFile(String filename) {
        this.filename = filename;
        this.closeOutput();
        this.initOutput();
    }

    @Override
    public void doPrint(String str) {
        if (this.ps == System.out) {
            this.buffer.append(str);
            return;
        }
        this.ps.print(str);
    }

    @Override
    public void doPrintln(String str) {
        if (this.ps == System.out) {
            this.buffer.append(str);
            this.buffer.append(nl);
            this.ps.print(this.buffer.toString());
            this.buffer.setLength(0);
            return;
        }
        this.ps.println(str);
    }

    @Override
    public boolean printObject(Object obj, int indent) {
        if (obj instanceof String) {
            this.doPrint((String)obj);
            return true;
        }
        if (obj instanceof Hashtable) {
            Hashtable hashObj = (Hashtable)obj;
            String tmp = obj.getClass().getName();
            this.doPrintln(tmp);
            DebugPrinter dbp = new DebugPrinter(hashObj, 4, this.filename);
            dbp.setIndent(indent);
            dbp.print();
            dbp.close();
            return false;
        }
        if (obj instanceof Vector) {
            Vector vobj = (Vector)obj;
            if (vobj.isEmpty()) {
                String tmp = "Empty    (" + obj.getClass().getName() + ")";
                this.doPrint(tmp);
                return true;
            }
            String tmp = obj.getClass().getName();
            this.doPrintln(tmp);
            DebugPrinter dbp = new DebugPrinter(vobj, 4, this.filename);
            dbp.setIndent(indent);
            dbp.print();
            dbp.close();
            return false;
        }
        if (obj instanceof Boolean || obj instanceof Integer || obj instanceof Long) {
            String tmp = obj.toString() + "    (" + obj.getClass().getName() + ")";
            this.doPrint(tmp);
            return true;
        }
        String tmp = obj.getClass().getName();
        this.doPrint(tmp);
        this.doPrintln("");
        this.printSpaces(indent);
        tmp = obj.toString();
        this.doPrint(tmp);
        return true;
    }

    private void printSpaces(int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        this.doPrint(sb.toString());
    }

    private void setupTitle() {
        String[] titleRow = new String[2];
        if (this.vector != null) {
            titleRow[0] = "index";
            titleRow[1] = "Value";
            this.addTitle(titleRow);
            return;
        }
        titleRow[0] = "Property Name";
        titleRow[1] = "Property Value";
        this.addTitle(titleRow);
    }

    private void setupData() {
        if (this.hashtable == null) {
            if (this.vector == null) {
                return;
            }
            this.setSortNeeded(false);
            Object[] row = new Object[2];
            int i = 0;
            Enumeration e = this.vector.elements();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                row[0] = String.valueOf(++i);
                row[1] = obj;
                this.add(row);
            }
            return;
        }
        this.setSortNeeded(true);
        Object[] row = new Object[2];
        Enumeration e = this.hashtable.keys();
        while (e.hasMoreElements()) {
            String curKey = (String)e.nextElement();
            row[0] = curKey;
            Object obj = this.hashtable.get(curKey);
            row[1] = obj;
            this.add(row);
        }
    }

    private void initOutput() {
        if (this.filename != null) {
            try {
                this.f = new File(this.filename);
                this.fos = new FileOutputStream(this.f, true);
                this.ps = new PrintStream(this.fos);
            }
            catch (Exception e) {
                System.err.println("Exception caught when setting output to file: " + this.filename + ": " + e);
                System.err.println("Reverting to stdout");
            }
        }
    }

    private void closeOutput() {
        if (this.filename != null) {
            try {
                if (this.ps != null && this.ps != System.out) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.fos != null) {
                    this.fos.close();
                    this.fos = null;
                }
                this.f = null;
            }
            catch (Exception e) {
                System.err.println("Exception caught when closing print streams to: " + this.filename + ": " + e);
            }
        }
    }

    public void close() {
        if (this.ps == System.out && this.buffer.length() > 0) {
            this.ps.print(this.buffer.toString());
            this.buffer.setLength(0);
        }
        this.closeOutput();
    }
}

