/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.resources.SharedResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.service.DestinationLogHandler")
@PerLookup
public class DestinationLogHandler
extends Handler {
    static boolean open = false;
    private static final String PREFIX = "imq.log.destination.";
    public static final String CAPACITY = "capacity";
    public static final String TOPIC = "topic";
    public static final String TIMETOLIVE = "timetolive";
    public static final String PERSIST = "persist";
    public static final String OUTPUT = "output";
    private static int DESTINATION_BEHAVIOR = 1;
    private String topic = "";
    private Destination destination = null;
    private boolean persist = false;
    private int ttl = 300;
    private int capacity = 100;
    protected static final SharedResources rb = SharedResources.getResources();
    private DestinationList DL = Globals.getDestinationList();

    public DestinationLogHandler() {
        LogManager lm = LogManager.getLogManager();
        if (!lm.getProperty("handlers").contains(this.getClass().getName())) {
            this.configure(CommGlobals.getConfig());
        } else {
            String property = "imq.log.destination.capacity";
            String capacityStr = lm.getProperty(property);
            property = "imq.log.destination.topic";
            String topicStr = lm.getProperty(property);
            property = "imq.log.destination.timetolive";
            String timeToLiveStr = lm.getProperty(property);
            property = "imq.log.destination.persist";
            String persistStr = lm.getProperty(property);
            property = "imq.log.destination.output";
            String outputStr = lm.getProperty(property);
            this.configure(capacityStr, topicStr, timeToLiveStr, persistStr, outputStr);
        }
    }

    public void configure(Properties props) {
        String property = "imq.log.destination.capacity";
        String capacityStr = props.getProperty(property);
        property = "imq.log.destination.topic";
        String topicStr = props.getProperty(property);
        property = "imq.log.destination.timetolive";
        String timeToLiveStr = props.getProperty(property);
        property = "imq.log.destination.persist";
        String persistStr = props.getProperty(property);
        property = "imq.log.destination.output";
        String outputStr = props.getProperty(property);
        this.configure(capacityStr, topicStr, timeToLiveStr, persistStr, outputStr);
    }

    public synchronized void configure(String capacityStr, String topicStr, String timeToLiveStr, String persistStr, String outputStr) {
        Object error_msg = null;
        if (capacityStr != null) {
            try {
                this.capacity = Integer.parseInt(capacityStr);
            }
            catch (NumberFormatException e) {
                error_msg = rb.getString("S2000", "imq.log.destination.capacity", capacityStr);
            }
        }
        if (topicStr != null) {
            this.topic = topicStr;
        }
        if (timeToLiveStr != null) {
            try {
                this.ttl = Integer.parseInt(timeToLiveStr);
            }
            catch (NumberFormatException e) {
                error_msg = rb.getString("S2000", "imq.log.destination.timetolive", timeToLiveStr);
            }
        }
        if (persistStr != null) {
            this.persist = persistStr.equals("true");
        }
        if (outputStr != null) {
            try {
                int configLevel = Logger.levelStrToInt(outputStr);
                Level levelSetByConfig = Logger.levelIntToJULLevel(configLevel);
                this.setLevel(levelSetByConfig);
            }
            catch (IllegalArgumentException e) {
                error_msg = (String)(error_msg != null ? (String)error_msg + "\n" : "") + "imq.log.destination.output: " + e.getMessage();
            }
        }
        if (error_msg != null) {
            throw new IllegalArgumentException((String)error_msg);
        }
        if (open) {
            this.close();
        }
        this.open();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (!open) {
            return;
        }
        if (BrokerStateHandler.isShuttingDown()) {
            return;
        }
        try {
            Destination[] ds = DestinationList.getLoadedDestination(null, this.topic, false);
            this.destination = ds[0];
            if (this.destination == null) {
                return;
            }
            if (this.destination.getCapacity() != this.capacity) {
                this.destination.setCapacity(this.capacity);
            }
            if (this.destination.getLimitBehavior() != DESTINATION_BEHAVIOR) {
                this.destination.setLimitBehavior(DESTINATION_BEHAVIOR);
            }
        }
        catch (Exception e) {
            IOException e2 = new IOException("Could not get or configure logging destination \"" + this.topic + "\". Closing destination logger: " + e);
            e2.initCause(e);
            this.close();
            CommGlobals.getLogger().publish(32, "Could not get or configure logging destination \"" + this.topic + "\". Closing destination logger: " + e);
        }
        if (this.destination.getActiveConsumerCount() <= 0) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        Hashtable<String, String> body = new Hashtable<String, String>();
        long curTime = System.currentTimeMillis();
        PortMapper pm = Globals.getPortMapper();
        int port = 0;
        if (pm != null) {
            port = pm.getPort();
        }
        props.put("broker", Globals.getMQAddress().getHostName() + ":" + port);
        props.put("brokerInstance", Globals.getConfigName());
        props.put("type", this.topic);
        props.put("timestamp", curTime);
        int logLevelInt = Logger.levelJULLevelToInt(record.getLevel());
        body.put("level", Logger.levelIntToStr(logLevelInt));
        body.put("text", record.getMessage());
        try {
            Packet pkt = new Packet(false);
            pkt.setProperties(props);
            pkt.setPacketType(3);
            pkt.setDestination(this.topic);
            pkt.setPriority(5);
            pkt.setIP(Globals.getBrokerInetAddress().getAddress());
            pkt.setPort(port);
            pkt.updateSequenceNumber();
            pkt.updateTimestamp();
            pkt.generateSequenceNumber(false);
            pkt.generateTimestamp(false);
            pkt.setIsQueue(false);
            pkt.setTransactionID(0L);
            pkt.setSendAcknowledge(false);
            pkt.setPersistent(this.persist);
            pkt.setExpiration(this.ttl == 0 ? 0L : curTime + (long)this.ttl);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(body);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            byte[] messageBody = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            pkt.setMessageBody(messageBody);
            PacketReference ref = PacketReference.createReference(this.destination.getPartitionedStore(), pkt, null);
            this.destination.queueMessage(ref, false);
            Set s = this.destination.routeNewMessage(ref);
            this.destination.forwardMessage(s, ref);
        }
        catch (Exception e) {
            this.close();
            Globals.getLogger().log(32, "Destination logger: Can't log to destination: " + this.topic, e);
            Globals.getLogger().log(32, "Closing destination logger.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Class<DestinationLogHandler> clazz = DestinationLogHandler.class;
        synchronized (DestinationLogHandler.class) {
            if (!open) {
                open = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<DestinationLogHandler> clazz = DestinationLogHandler.class;
        synchronized (DestinationLogHandler.class) {
            if (open) {
                open = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.topic;
    }

    @Override
    public void flush() {
    }
}

