package business;

import java.util.ArrayList;
import java.util.List;

import base world.City;
import base world.Person;

public team class Company {

	String mainPhone;
	
	protected class Employee playedBy Person {
		public String officePhoneNo;

		String getName() -> String getName();

		String getFullPhoneNo() {
			return mainPhone+"-"+this.officePhoneNo;
		}
		@Override
		public String toString() {
			return getName()+" "+getFullPhoneNo();
		}
		
		// L2:
		getOfficePhoneNo <- replace getPhoneNo;

        @SuppressWarnings("basecall")
		callin String getOfficePhoneNo() {
        	return getFullPhoneNo();
		}
        //
		// L3:
		@SuppressWarnings("decapsulation")
		HomeTown getLivesIn() -> get City livesIn;

		protected void registerHomeTown() {
        	HomeTown myTown = this.getLivesIn();
        	myTown.addCommuter(this);
        }
        //
	}

	// L3:
	protected class HomeTown playedBy City {

		List<Employee> commuters = new ArrayList<Employee>();
		
		protected String getName() -> get String name;

		public void addCommuter(Employee employee) {
			this.commuters.add(employee);
		}

		public void printSharing() {
			if (commuters.size() > 1) {
				System.out.println("\tRide sharing:");
				for (Employee emp : this.commuters)
					System.out.println("\t\t"+emp.getName());
			} else {
				System.out.println("\tNo sharing");
			}			
		}
	}
	//

	public Company(String phone) {
		this.mainPhone = phone;
	}
	
	public void hire(Person as Employee emp, String phone) {
		emp.officePhoneNo = phone;
		// L3:
		emp.registerHomeTown();
		// 
	}
	public String getBusinessCard(Person as Employee emp) {
		return "Employee "+emp.toString();
	}
	
	// L3:
	public void findRideSharing() {
		for (HomeTown town : getAllRoles(HomeTown.class)) {
			System.out.println("City "+town.getName());
			town.printSharing();
		}
	}
	//
}
