/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.textmate;

import java.util.Optional;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.xtext.generator.textmate.BeginEndRule;
import org.eclipse.xtext.xtext.generator.textmate.MatchRule;
import org.eclipse.xtext.xtext.generator.textmate.TerminalRuleToTextMateRule;
import org.eclipse.xtext.xtext.generator.textmate.TextMateRule;

public class AutoRule
extends TextMateRule {
    @Override
    @Mandatory
    public void setTerminalRule(String terminalRule) {
        super.setTerminalRule(terminalRule);
    }

    public Optional<TextMateRule> init(Grammar grammar, boolean ignoreCase, TerminalRuleToTextMateRule generator) {
        TerminalRule terminal = (TerminalRule)GrammarUtil.findRuleForName((Grammar)grammar, (String)this.getTerminalRule());
        if (terminal != null) {
            Optional<TextMateRule> result = this.toBeginEndRule(terminal, generator).or(() -> this.toMatchRule(terminal, generator));
            return result.map(r -> {
                r.setName(Optional.ofNullable(this.getName()).orElseGet(() -> this.toTextMateName(terminal, GrammarUtil.getSimpleName((Grammar)grammar).toLowerCase())));
                return r;
            }).filter(r -> r.getName() != null);
        }
        return Optional.empty();
    }

    protected Optional<TextMateRule> toBeginEndRule(TerminalRule rule, TerminalRuleToTextMateRule generator) {
        Group group;
        AbstractElement alternatives = rule.getAlternatives();
        if (alternatives instanceof Group && (group = (Group)alternatives).getElements().size() == 2 && group.getElements().get(1) instanceof UntilToken) {
            String begin = generator.getMatchRegEx((AbstractElement)group.getElements().get(0));
            String end = generator.getMatchRegEx(((UntilToken)group.getElements().get(1)).getTerminal());
            BeginEndRule result = new BeginEndRule();
            result.setBegin(begin);
            result.setEnd(end);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected Optional<TextMateRule> toMatchRule(TerminalRule rule, TerminalRuleToTextMateRule generator) {
        try {
            String match = generator.getMatchRegEx(rule);
            MatchRule result = new MatchRule();
            result.setMatch(match);
            return Optional.of(result);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    protected String toTextMateName(TerminalRule terminal, String langName) {
        switch (terminal.getName()) {
            case "SL_COMMENT": {
                return "comment.line." + langName;
            }
            case "ML_COMMENT": {
                return "comment.block." + langName;
            }
            case "STRING": {
                return "string.quoted." + langName;
            }
            case "ID": {
                return "variable." + langName;
            }
            case "INT": {
                return "constant.numeric." + langName;
            }
            case "ANY_OTHER": {
                return "invalid." + langName;
            }
        }
        return null;
    }
}

