/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.ResolvedTypeParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class DelegateProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    public void doTransform(List<? extends MutableMemberDeclaration> elements, @Extension TransformationContext context) {
        Util util = new Util(context);
        Consumer<MutableMemberDeclaration> _function = it -> {
            boolean _isValidDelegate = util.isValidDelegate((MemberDeclaration)it);
            if (_isValidDelegate) {
                Consumer<ResolvedMethod> _function_1 = method -> util.implementMethod((MutableMemberDeclaration)it, (ResolvedMethod)method);
                util.getMethodsToImplement((MemberDeclaration)it).forEach(_function_1);
            }
        };
        elements.forEach(_function);
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        protected boolean _isValidDelegate(FieldDeclaration it) {
            return this.hasValidType((MemberDeclaration)it) && !this.hasDelegationConflicts((MemberDeclaration)it) && this.areListedInterfacesValid((MemberDeclaration)it);
        }

        protected boolean _isValidDelegate(MethodDeclaration it) {
            return this.hasValidType((MemberDeclaration)it) && this.hasValidSignature(it) && !this.hasDelegationConflicts((MemberDeclaration)it) && this.areListedInterfacesValid((MemberDeclaration)it);
        }

        public boolean hasValidType(MemberDeclaration it) {
            boolean _xifexpression = false;
            if (this.getType(it) == null || this.getType(it).isInferred()) {
                boolean _xblockexpression = false;
                this.context.addError((Element)it, "Cannot use inferred types on delegates");
                _xifexpression = _xblockexpression = false;
            } else {
                _xifexpression = true;
            }
            return _xifexpression;
        }

        protected TypeReference _getType(FieldDeclaration it) {
            return it.getType();
        }

        protected TypeReference _getType(MethodDeclaration it) {
            return it.getReturnType();
        }

        public boolean hasValidSignature(MethodDeclaration it) {
            boolean _switchResult = false;
            Functions.Function1 _function = it_1 -> it_1.getType();
            List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)it.getParameters(), (Functions.Function1)_function));
            boolean _matched = false;
            if (com.google.common.base.Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList()))) {
                _matched = true;
            }
            if (!_matched) {
                TypeReference _string = this.context.getString();
                if (com.google.common.base.Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string})))) {
                    _matched = true;
                }
            }
            if (!_matched) {
                TypeReference _string_1 = this.context.getString();
                TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(this.context.newTypeReference(Class.class, new TypeReference[]{this.context.newWildcardTypeReference()}));
                TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(this.context.getObject());
                if (com.google.common.base.Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string_1, _newArrayTypeReference, _newArrayTypeReference_1})))) {
                    _matched = true;
                }
            }
            if (_matched) {
                _switchResult = true;
            }
            if (!_matched) {
                boolean _xblockexpression = false;
                this.context.addError((Element)it, "Not a valid delegate signature, use () or (String methodName) or (String methodName, Class<?>[] argumentTypes, Object[] arguments)");
                _switchResult = _xblockexpression = false;
            }
            return _switchResult;
        }

        public boolean hasDelegationConflicts(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            boolean conflict = false;
            Iterable<? extends MemberDeclaration> _otherDelegates = this.otherDelegates(delegate);
            for (MemberDeclaration memberDeclaration : _otherDelegates) {
                Set<TypeReference> otherInterfaces = this.getDelegatedInterfaces(memberDeclaration);
                Set<TypeReference> _delegatedInterfaces = this.getDelegatedInterfaces(delegate);
                for (TypeReference iface : _delegatedInterfaces) {
                    boolean _contains = otherInterfaces.contains(iface);
                    if (!_contains) continue;
                    conflict = true;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("The interface ");
                    String _simpleName = iface.getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" is also implemented by the delegate ");
                    String _simpleName_1 = memberDeclaration.getSimpleName();
                    _builder.append(_simpleName_1);
                    this.context.addError((Element)delegate, _builder.toString());
                }
            }
            _xblockexpression = conflict;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> otherDelegates(MemberDeclaration delegate) {
            Functions.Function1 _function = it -> !Objects.equals(it, delegate);
            return IterableExtensions.filter(this.getDelegates(delegate.getDeclaringType()), (Functions.Function1)_function);
        }

        public boolean areListedInterfacesValid(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            TypeReference declaringType = this.context.newSelfTypeReference((Type)delegate.getDeclaringType());
            Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(declaringType);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(this.getType(delegate));
            Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            boolean valid = true;
            for (TypeReference iface : listedInterfaces) {
                Functions.Function1 _function_1;
                boolean _exists_1;
                boolean _not_1;
                boolean _not;
                Functions.Function1 _function = it -> {
                    Type _type = it.getType();
                    Type _type_1 = iface.getType();
                    return Objects.equals(_type, _type_1);
                };
                boolean _exists = IterableExtensions.exists(availableInterfaces, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _simpleName = this.getType(delegate).getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(" does not implement ");
                    String _simpleName_1 = iface.getSimpleName();
                    _builder.append(_simpleName_1);
                    this.context.addError((Element)delegate, _builder.toString());
                    valid = false;
                }
                boolean bl2 = _not_1 = !(_exists_1 = IterableExtensions.exists(interfacesOfDeclaringType, (Functions.Function1)(_function_1 = it -> {
                    Type _type = it.getType();
                    Type _type_1 = iface.getType();
                    return Objects.equals(_type, _type_1);
                })));
                if (!_not_1) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                String _simpleName_2 = declaringType.getSimpleName();
                _builder_1.append(_simpleName_2);
                _builder_1.append(" does not implement ");
                String _simpleName_3 = iface.getSimpleName();
                _builder_1.append(_simpleName_3);
                this.context.addError((Element)delegate, _builder_1.toString());
                valid = false;
            }
            if (listedInterfaces.isEmpty() && Sets.intersection(interfacesOfDeclaringType, availableInterfaces).isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                String _simpleName = this.getType(delegate).getSimpleName();
                _builder.append(_simpleName);
                _builder.append(" and ");
                String _simpleName_1 = declaringType.getSimpleName();
                _builder.append(_simpleName_1);
                _builder.append(" have no interfaces in common");
                this.context.addError((Element)delegate, _builder.toString());
                valid = false;
            }
            _xblockexpression = valid;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> getDelegates(TypeDeclaration it) {
            Functions.Function1 _function = it_1 -> {
                AnnotationReference _findAnnotation = it_1.findAnnotation(this.context.findTypeGlobally(Delegate.class));
                return _findAnnotation != null;
            };
            return IterableExtensions.filter((Iterable)it.getDeclaredMembers(), (Functions.Function1)_function);
        }

        public Set<TypeReference> listedInterfaces(MemberDeclaration it) {
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)it.findAnnotation(this.context.findTypeGlobally(Delegate.class)).getClassArrayValue("value"))));
        }

        public Set<TypeReference> getImplementedInterfaces(TypeReference it) {
            Set _xblockexpression = null;
            LinkedHashSet seen = CollectionLiterals.newLinkedHashSet();
            this.collectAllSuperTypes(it, seen);
            Functions.Function1 _function = it_1 -> {
                Type _type = it_1.getType();
                return _type instanceof InterfaceDeclaration;
            };
            _xblockexpression = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)seen, (Functions.Function1)_function));
            return _xblockexpression;
        }

        private void collectAllSuperTypes(TypeReference it, Set<TypeReference> seen) {
            boolean cycle;
            boolean _add = seen.add(it);
            boolean bl = cycle = !_add;
            if (cycle) {
                return;
            }
            Consumer<TypeReference> _function = it_1 -> this.collectAllSuperTypes((TypeReference)it_1, seen);
            it.getDeclaredSuperTypes().forEach(_function);
        }

        public Set<TypeReference> getDelegatedInterfaces(MemberDeclaration delegate) {
            Set _xblockexpression = null;
            Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(this.context.newSelfTypeReference((Type)delegate.getDeclaringType()));
            Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(this.getType(delegate));
            Functions.Function1 _function = iface -> interfacesOfDeclaringType.contains(iface) && (listedInterfaces.isEmpty() || IterableExtensions.exists((Iterable)listedInterfaces, it -> iface.isAssignableFrom(it)));
            _xblockexpression = IterableExtensions.toSet((Iterable)IterableExtensions.filter(availableInterfaces, (Functions.Function1)_function));
            return _xblockexpression;
        }

        public Set<ResolvedMethod> getMethodsToImplement(MemberDeclaration delegate) {
            Functions.Function1 _function = it -> it.getDeclaredResolvedMethods();
            Functions.Function1 _function_1 = it -> {
                Functions.Function1 _function_2 = it_1 -> it_1.getResolvedType();
                MethodDeclaration _findDeclaredMethod = delegate.getDeclaringType().findDeclaredMethod(it.getDeclaration().getSimpleName(), (TypeReference[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)it.getResolvedParameters(), (Functions.Function1)_function_2), TypeReference.class));
                return _findDeclaredMethod == null;
            };
            Functions.Function1 _function_2 = it -> {
                boolean _isObjectMethod = this.isObjectMethod((ResolvedMethod)it);
                return !_isObjectMethod;
            };
            Functions.Function1 _function_3 = it -> {
                boolean _isStatic = this.isStatic((ResolvedMethod)it);
                return !_isStatic;
            };
            Functions.Function1 _function_4 = it -> it.getSimpleSignature();
            Functions.Function1 _function_5 = it -> (ResolvedMethod)IterableExtensions.head((Iterable)it);
            Functions.Function1 _function_6 = it -> it.getSimpleSignature();
            return IterableExtensions.toSet((Iterable)IterableExtensions.sortBy((Iterable)IterableExtensions.map(IterableExtensions.groupBy((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(this.getDelegatedInterfaces(delegate), (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4).values(), (Functions.Function1)_function_5), (Functions.Function1)_function_6));
        }

        public boolean isObjectMethod(ResolvedMethod it) {
            boolean _xblockexpression = false;
            String name = it.getDeclaration().getSimpleName();
            Functions.Function1 _function = it_1 -> it_1.getResolvedType();
            List parameterTypes = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)it.getResolvedParameters(), (Functions.Function1)_function));
            _xblockexpression = Objects.equals(name, "hashCode") && parameterTypes.isEmpty() || Objects.equals(name, "toString") && parameterTypes.isEmpty() || Objects.equals(name, "equals") && Objects.equals(parameterTypes, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{this.context.getObject()}))) || Objects.equals(name, "finalize") && parameterTypes.isEmpty() || Objects.equals(name, "clone") && parameterTypes.isEmpty();
            return _xblockexpression;
        }

        public boolean isStatic(ResolvedMethod it) {
            return it.getDeclaration().isStatic();
        }

        public MutableMethodDeclaration implementMethod(final MutableMemberDeclaration delegate, final ResolvedMethod resolvedMethod) {
            MutableMethodDeclaration _xblockexpression = null;
            delegate.markAsRead();
            final MethodDeclaration declaration = resolvedMethod.getDeclaration();
            Procedures.Procedure1 _function = impl -> {
                this.context.setPrimarySourceElement((MutableElement)impl, this.context.getPrimarySourceElement((Element)delegate));
                HashMap typeParameterMappings = CollectionLiterals.newHashMap();
                Consumer<ResolvedTypeParameter> _function_1 = param -> {
                    MutableTypeParameterDeclaration copy = impl.addTypeParameter(param.getDeclaration().getSimpleName(), (TypeReference[])Conversions.unwrapArray((Object)param.getResolvedUpperBounds(), TypeReference.class));
                    typeParameterMappings.put(this.context.newTypeReference((Type)param.getDeclaration(), new TypeReference[0]), this.context.newTypeReference((Type)copy, new TypeReference[0]));
                    Functions.Function1 _function_2 = it -> this.replace((TypeReference)it, typeParameterMappings);
                    copy.setUpperBounds(IterableExtensions.map((Iterable)copy.getUpperBounds(), (Functions.Function1)_function_2));
                };
                resolvedMethod.getResolvedTypeParameters().forEach(_function_1);
                Functions.Function1 _function_2 = it -> this.replace((TypeReference)it, typeParameterMappings);
                impl.setExceptions((TypeReference[])Conversions.unwrapArray((Object)IterableExtensions.map((Iterable)resolvedMethod.getResolvedExceptionTypes(), (Functions.Function1)_function_2), TypeReference.class));
                impl.setVarArgs(declaration.isVarArgs());
                impl.setReturnType(this.replace(resolvedMethod.getResolvedReturnType(), typeParameterMappings));
                Consumer<ResolvedParameter> _function_3 = p -> impl.addParameter(p.getDeclaration().getSimpleName(), this.replace(p.getResolvedType(), typeParameterMappings));
                resolvedMethod.getResolvedParameters().forEach(_function_3);
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        String _returnIfNeeded = this.returnIfNeeded(resolvedMethod);
                        _builder.append((Object)_returnIfNeeded);
                        CharSequence _delegateAccess = this.delegateAccess((MemberDeclaration)delegate, declaration);
                        _builder.append((Object)_delegateAccess);
                        _builder.append((Object)".");
                        String _simpleName = declaration.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)"(");
                        Functions.Function1 _function = it -> it.getSimpleName();
                        String _join = IterableExtensions.join((Iterable)declaration.getParameters(), (CharSequence)", ", (Functions.Function1)_function);
                        _builder.append((Object)_join);
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                };
                impl.setBody(_client);
            };
            _xblockexpression = delegate.getDeclaringType().addMethod(declaration.getSimpleName(), _function);
            return _xblockexpression;
        }

        public TypeReference replace(TypeReference target, Map<? extends TypeReference, ? extends TypeReference> mappings) {
            Functions.Function2 _function = (result, mapping) -> this.replace((TypeReference)result, (TypeReference)mapping.getKey(), (TypeReference)mapping.getValue());
            return (TypeReference)IterableExtensions.fold(mappings.entrySet(), (Object)target, (Functions.Function2)_function);
        }

        public TypeReference replace(TypeReference target, TypeReference oldType, TypeReference newType) {
            boolean _isArray;
            boolean _not;
            boolean _equals = Objects.equals(target, oldType);
            if (_equals) {
                return newType;
            }
            boolean _isEmpty = target.getActualTypeArguments().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Functions.Function1 _function = it -> this.replace((TypeReference)it, oldType, newType);
                return this.context.newTypeReference(target.getType(), (TypeReference[])Conversions.unwrapArray((Object)ListExtensions.map((List)target.getActualTypeArguments(), (Functions.Function1)_function), TypeReference.class));
            }
            boolean _isWildCard = target.isWildCard();
            if (_isWildCard) {
                boolean _not_1;
                TypeReference _object;
                boolean _notEquals;
                TypeReference _upperBound = target.getUpperBound();
                boolean bl2 = _notEquals = !Objects.equals(_upperBound, _object = this.context.getObject());
                if (_notEquals) {
                    return this.context.newWildcardTypeReference(this.replace(target.getUpperBound(), oldType, newType));
                }
                boolean _isAnyType = target.getLowerBound().isAnyType();
                boolean bl3 = _not_1 = !_isAnyType;
                if (_not_1) {
                    return this.context.newWildcardTypeReferenceWithLowerBound(this.replace(target.getLowerBound(), oldType, newType));
                }
            }
            if (_isArray = target.isArray()) {
                return this.context.newArrayTypeReference(this.replace(target.getArrayComponentType(), oldType, newType));
            }
            return target;
        }

        protected CharSequence _delegateAccess(FieldDeclaration it, MethodDeclaration method) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this.");
            String _simpleName = it.getSimpleName();
            _builder.append(_simpleName);
            return _builder;
        }

        protected CharSequence _delegateAccess(MethodDeclaration it, MethodDeclaration method) {
            StringConcatenation _switchResult = null;
            Functions.Function1 _function = it_1 -> it_1.getType();
            List _list = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)it.getParameters(), (Functions.Function1)_function));
            boolean _matched = false;
            if (com.google.common.base.Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList()))) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("this.");
                String _simpleName = it.getSimpleName();
                _builder.append(_simpleName);
                _builder.append("()");
                _switchResult = _builder;
            }
            if (!_matched) {
                TypeReference _string = this.context.getString();
                if (com.google.common.base.Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string})))) {
                    _matched = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("this.");
                    String _simpleName_1 = it.getSimpleName();
                    _builder_1.append(_simpleName_1);
                    _builder_1.append("(\"");
                    String _simpleName_2 = method.getSimpleName();
                    _builder_1.append(_simpleName_2);
                    _builder_1.append("\")");
                    _switchResult = _builder_1;
                }
            }
            if (!_matched) {
                TypeReference _string_1 = this.context.getString();
                TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(this.context.newTypeReference(Class.class, new TypeReference[]{this.context.newWildcardTypeReference()}));
                TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(this.context.getObject());
                if (com.google.common.base.Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string_1, _newArrayTypeReference, _newArrayTypeReference_1})))) {
                    _matched = true;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("this.");
                    String _simpleName_3 = it.getSimpleName();
                    _builder_2.append(_simpleName_3);
                    _builder_2.append("(\"");
                    String _simpleName_4 = method.getSimpleName();
                    _builder_2.append(_simpleName_4);
                    _builder_2.append("\", new Class[]{");
                    Functions.Function1 _function_1 = it_1 -> {
                        String _simpleName_5 = it_1.getType().getType().getSimpleName();
                        return _simpleName_5 + ".class";
                    };
                    String _join = IterableExtensions.join((Iterable)method.getParameters(), (CharSequence)", ", (Functions.Function1)_function_1);
                    _builder_2.append(_join);
                    _builder_2.append("}, new Object[]{");
                    Functions.Function1 _function_2 = it_1 -> it_1.getSimpleName();
                    String _join_1 = IterableExtensions.join((Iterable)method.getParameters(), (CharSequence)", ", (Functions.Function1)_function_2);
                    _builder_2.append(_join_1);
                    _builder_2.append("})");
                    _switchResult = _builder_2;
                }
            }
            if (!_matched) {
                throw new IllegalArgumentException("delegate signature");
            }
            return _switchResult;
        }

        public String returnIfNeeded(ResolvedMethod it) {
            String _xifexpression = null;
            boolean _isVoid = it.getResolvedReturnType().isVoid();
            _xifexpression = _isVoid ? "" : "return ";
            return _xifexpression;
        }

        public boolean isValidDelegate(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._isValidDelegate((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._isValidDelegate((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public TypeReference getType(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._getType((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._getType((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public CharSequence delegateAccess(MemberDeclaration it, MethodDeclaration method) {
            if (it instanceof MethodDeclaration) {
                return this._delegateAccess((MethodDeclaration)it, method);
            }
            if (it instanceof FieldDeclaration) {
                return this._delegateAccess((FieldDeclaration)it, method);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, method).toString());
        }
    }
}

