/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.TaskTag;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.ComboDialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.DialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.IDialogFieldListener;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.LayoutUtil;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.StringDialogField;
import org.eclipse.xtext.ui.preferences.StatusInfo;
import org.eclipse.xtext.ui.tasks.preferences.PreferencesMessages;

public class TaskTagInputDialog
extends StatusDialog {
    public static final String ENABLED = "true";
    public static final String DISABLED = "false";
    private StringDialogField nameField;
    private ComboDialogField priorityField;
    private List<String> existingNames;
    private String languageName;

    public TaskTagInputDialog(Shell parent, TaskTag task, List<TaskTag> existingEntries, String languageName) {
        super(parent);
        this.languageName = languageName;
        this.existingNames = new ArrayList<String>(existingEntries.size());
        int i = 0;
        while (i < existingEntries.size()) {
            TaskTag curr = existingEntries.get(i);
            if (!curr.equals((Object)task)) {
                this.existingNames.add(curr.getName());
            }
            ++i;
        }
        if (task == null) {
            this.setTitle(PreferencesMessages.TaskTagInputDialog_new_title);
        } else {
            this.setTitle(PreferencesMessages.TaskTagInputDialog_edit_title);
        }
        TaskTagInputAdapter adapter = new TaskTagInputAdapter();
        this.nameField = new StringDialogField();
        this.nameField.setLabelText(PreferencesMessages.TaskTagInputDialog_name_label);
        this.nameField.setDialogFieldListener(adapter);
        this.nameField.setText(task != null ? task.getName() : "");
        String[] items = new String[]{PreferencesMessages.TaskTagInputDialog_priority_high, PreferencesMessages.TaskTagInputDialog_priority_normal, PreferencesMessages.TaskTagInputDialog_priority_low};
        this.priorityField = new ComboDialogField(8);
        this.priorityField.setLabelText(PreferencesMessages.TaskTagInputDialog_priority_label);
        this.priorityField.setItems(items);
        if (task != null) {
            if (Priority.HIGH == task.getPriority()) {
                this.priorityField.selectItem(0);
            } else if (Priority.NORMAL == task.getPriority()) {
                this.priorityField.selectItem(1);
            } else {
                this.priorityField.selectItem(2);
            }
        } else {
            this.priorityField.selectItem(1);
        }
    }

    public TaskTag getResult() {
        TaskTag task = new TaskTag();
        task.setName(this.nameField.getText().trim());
        switch (this.priorityField.getSelectionIndex()) {
            case 0: {
                task.setPriority(Priority.HIGH);
                break;
            }
            case 1: {
                task.setPriority(Priority.NORMAL);
                break;
            }
            default: {
                task.setPriority(Priority.LOW);
            }
        }
        return task;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.nameField.doFillIntoGrid(inner, 2);
        this.priorityField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.nameField.getTextControl(null), this.convertWidthInCharsToPixels(45));
        this.nameField.postSetFocusOnDialogField(parent.getDisplay());
        TaskTagInputDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getTaskTagInputDialog());
        return composite;
    }

    public String getTaskTagInputDialog() {
        return String.valueOf(this.languageName) + "_todo_task_input_dialog_context";
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.nameField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.TaskTagInputDialog_error_enterName);
        } else if (newText.indexOf(44) != -1) {
            status.setError(PreferencesMessages.TaskTagInputDialog_error_comma);
        } else if (this.existingNames.contains(newText)) {
            status.setError(PreferencesMessages.TaskTagInputDialog_error_entryExists);
        } else if (Character.isWhitespace(newText.charAt(0)) || Character.isWhitespace(newText.charAt(newText.length() - 1))) {
            status.setError(PreferencesMessages.TaskTagInputDialog_error_noSpace);
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, this.getTaskTagInputDialog());
    }

    private class TaskTagInputAdapter
    implements IDialogFieldListener {
        private TaskTagInputAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TaskTagInputDialog.this.doValidation();
        }
    }
}

