/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.wizard.Scope;

public class ExternalDependency {
    private final MavenCoordinates maven = new MavenCoordinates();
    private final P2Coordinates p2 = new P2Coordinates();

    public static ExternalDependency createXtextDependency(String xtextBundle) {
        ExternalDependency externalDependency = new ExternalDependency();
        externalDependency.p2.bundleId = xtextBundle;
        externalDependency.maven.groupId = "org.eclipse.xtext";
        externalDependency.maven.artifactId = xtextBundle;
        externalDependency.maven.version = "${xtextVersion}";
        return externalDependency;
    }

    public static ExternalDependency createMavenDependency(String shortNotation) {
        ExternalDependency externalDependency = new ExternalDependency();
        externalDependency.maven.setShortNotation(shortNotation);
        return externalDependency;
    }

    public static ExternalDependency createBundleDependency(String bundleId) {
        ExternalDependency externalDependency = new ExternalDependency();
        externalDependency.p2.bundleId = bundleId;
        return externalDependency;
    }

    public void maven(Procedures.Procedure1<? super MavenCoordinates> config) {
        config.apply((Object)this.maven);
    }

    public void p2(Procedures.Procedure1<? super P2Coordinates> config) {
        config.apply((Object)this.p2);
    }

    @Pure
    public MavenCoordinates getMaven() {
        return this.maven;
    }

    @Pure
    public P2Coordinates getP2() {
        return this.p2;
    }

    public static class MavenCoordinates {
        private String groupId;
        private String artifactId;
        private String version;
        private Scope scope = Scope.COMPILE;
        private boolean optional = false;

        public void setShortNotation(String shortNotation) {
            String[] parts = shortNotation.split(":");
            this.groupId = parts[0];
            this.artifactId = parts[1];
            this.version = parts[2];
        }

        @Pure
        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Pure
        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @Pure
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @Pure
        public Scope getScope() {
            return this.scope;
        }

        public void setScope(Scope scope) {
            this.scope = scope;
        }

        @Pure
        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }
    }

    public static class P2Coordinates {
        private String bundleId;
        private String version;
        private Set<String> packages = new HashSet<String>();

        @Pure
        public String getBundleId() {
            return this.bundleId;
        }

        public void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Pure
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @Pure
        public Set<String> getPackages() {
            return this.packages;
        }

        public void setPackages(Set<String> packages) {
            this.packages = packages;
        }
    }
}

