/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.common.types.ui.notification.LayeredTypeResourceDescription;
import org.eclipse.xtext.common.types.ui.notification.NameBasedEObjectDescriptionBuilder;
import org.eclipse.xtext.common.types.ui.notification.TypeResourceDescription;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChangedResourceDescriptionDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaConverter {
    private static final Logger logger = Logger.getLogger(DeltaConverter.class);
    private final TypeURIHelper uriHelper;
    private final IQualifiedNameConverter nameConverter;

    @Inject
    public DeltaConverter(IQualifiedNameConverter nameConverter, TypeURIHelper uriHelper) {
        this.nameConverter = nameConverter;
        this.uriHelper = uriHelper;
    }

    public List<IResourceDescription.Delta> convert(IJavaElementDelta delta) {
        if (delta.getFlags() == 524288) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)2);
        this.convertCompilationUnits(delta, result);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void convertCompilationUnit(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        if ((delta.getFlags() & 8) != 0) {
            IJavaElementDelta[] children;
            IJavaElementDelta[] iJavaElementDeltaArray = children = delta.getAffectedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                IJavaElement childElement = child.getElement();
                if (childElement instanceof IType) {
                    void var12_22;
                    IType type = (IType)childElement;
                    URI uri = this.getURIFor(type);
                    List<IEObjectDescription> exported = this.getExportedEObjects(type);
                    Object var12_23 = null;
                    TypeResourceDescription newDescription = null;
                    if (child.getKind() == 2) {
                        TypeResourceDescription typeResourceDescription = new TypeResourceDescription(uri, exported);
                    } else if (child.getKind() == 1) {
                        newDescription = new TypeResourceDescription(uri, exported);
                    } else {
                        newDescription = new TypeResourceDescription(uri, exported);
                        List<IEObjectDescription> additionallyExportedEObjects = this.getAdditionallyExportedEObjects(type, child);
                        LayeredTypeResourceDescription layeredTypeResourceDescription = new LayeredTypeResourceDescription(newDescription, additionallyExportedEObjects);
                    }
                    ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta((IResourceDescription)var12_22, (IResourceDescription)newDescription);
                    result.add((IResourceDescription.Delta)resourceDelta);
                }
                ++n2;
            }
            return;
        } else {
            if ((delta.getFlags() & 0x40030) == 0 && (delta.getKind() != 1 || delta.getFlags() != 0)) return;
            ICompilationUnit cu = (ICompilationUnit)delta.getElement();
            try {
                IType[] iTypeArray = cu.getTypes();
                int n = iTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IType type = iTypeArray[n3];
                    URI uri = this.getURIFor(type);
                    List<IEObjectDescription> exported = this.getExportedEObjects(type);
                    LayeredTypeResourceDescription oldDescription = null;
                    TypeResourceDescription newDescription = null;
                    newDescription = new TypeResourceDescription(uri, exported);
                    List<IEObjectDescription> list = this.getAdditionallyExportedEObjects(type, delta);
                    oldDescription = new LayeredTypeResourceDescription(newDescription, list);
                    ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta((IResourceDescription)oldDescription, (IResourceDescription)newDescription);
                    result.add((IResourceDescription.Delta)resourceDelta);
                    ++n3;
                }
                return;
            }
            catch (JavaModelException e) {
                if (!logger.isDebugEnabled()) return;
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected List<IEObjectDescription> getAdditionallyExportedEObjects(IType type, IJavaElementDelta delta) {
        QualifiedName typeName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        NameBasedEObjectDescriptionBuilder descriptionBuilder = new NameBasedEObjectDescriptionBuilder(typeName);
        this.traverseDelta(delta, descriptionBuilder);
        return descriptionBuilder.getExported();
    }

    protected void traverseDelta(IJavaElementDelta delta, NameBasedEObjectDescriptionBuilder acceptor) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
            if (childDelta.getKind() == 2) {
                String childName = childDelta.getElement().getElementName();
                acceptor.accept(childName);
            } else {
                IJavaElement childElement = childDelta.getElement();
                if (childElement.getElementType() == 7) {
                    NameBasedEObjectDescriptionBuilder childAcceptor = acceptor.nestType(childElement.getElementName());
                    this.traverseDelta(childDelta, childAcceptor);
                }
            }
            ++n2;
        }
    }

    protected List<IEObjectDescription> getExportedEObjects(IType type) {
        QualifiedName typeName = this.nameConverter.toQualifiedName(type.getFullyQualifiedName());
        NameBasedEObjectDescriptionBuilder descriptionBuilder = new NameBasedEObjectDescriptionBuilder(typeName);
        this.traverseType(type, descriptionBuilder);
        List<IEObjectDescription> exported = descriptionBuilder.getExported();
        return exported;
    }

    protected void traverseType(IType type, NameBasedEObjectDescriptionBuilder acceptor) {
        block8: {
            try {
                if (type.exists()) {
                    IField[] iFieldArray = type.getFields();
                    int n = iFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        if (!Flags.isSynthetic((int)field.getFlags())) {
                            String fieldName = field.getElementName();
                            acceptor.accept(fieldName);
                        }
                        ++n2;
                    }
                    iFieldArray = type.getMethods();
                    n = iFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IField method = iFieldArray[n2];
                        if (!Flags.isSynthetic((int)method.getFlags())) {
                            String methodName = method.getElementName();
                            acceptor.accept(methodName);
                        }
                        ++n2;
                    }
                    iFieldArray = type.getTypes();
                    n = iFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        IField nestedType = iFieldArray[n2];
                        this.traverseType((IType)nestedType, acceptor.nestType(nestedType.getElementName()));
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void convertCompilationUnits(IJavaElementDelta delta, List<IResourceDescription.Delta> result) {
        block9: {
            IJavaElement element = delta.getElement();
            if (delta.getKind() != 2 && this.hasStructureErrors(element)) {
                return;
            }
            if (element.getElementType() == 5) {
                this.convertCompilationUnit(delta, result);
            }
            if (element.getElementType() < 5) {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta child = iJavaElementDeltaArray[n2];
                    this.convertCompilationUnits(child, result);
                    ++n2;
                }
                if (delta.getKind() == 1 && delta.getAffectedChildren().length == 0 && element.getElementType() == 4) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    try {
                        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                        int n3 = iCompilationUnitArray.length;
                        n = 0;
                        while (n < n3) {
                            ICompilationUnit cu = iCompilationUnitArray[n];
                            IType[] iTypeArray = cu.getTypes();
                            int n4 = iTypeArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                IType type = iTypeArray[n5];
                                URI uri = this.getURIFor(type);
                                List<IEObjectDescription> exported = this.getExportedEObjects(type);
                                TypeResourceDescription newDescription = new TypeResourceDescription(uri, exported);
                                ChangedResourceDescriptionDelta resourceDelta = new ChangedResourceDescriptionDelta(null, (IResourceDescription)newDescription);
                                result.add((IResourceDescription.Delta)resourceDelta);
                                ++n5;
                            }
                            ++n;
                        }
                    }
                    catch (JavaModelException e) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    protected boolean hasStructureErrors(IJavaElement element) {
        try {
            return !element.isStructureKnown();
        }
        catch (JavaModelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e, (Throwable)e);
            }
            return true;
        }
    }

    protected URI getURIFor(IType type) {
        URI result = this.uriHelper.createResourceURIForFQN(type.getFullyQualifiedName());
        return result;
    }
}

