/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.junit.editor;

import junit.framework.TestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.junit.util.IResourcesSetupUtil;

public abstract class AbstractWorkbenchTest
extends TestCase {
    public AbstractWorkbenchTest() {
    }

    public AbstractWorkbenchTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.closeWelcomePage();
        this.closeEditors();
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.waitForAutoBuild();
    }

    protected void tearDown() throws Exception {
        this.closeEditors();
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.waitForAutoBuild();
        super.tearDown();
    }

    protected void closeEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void closeWelcomePage() throws InterruptedException {
        if (PlatformUI.getWorkbench().getIntroManager().getIntro() != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(PlatformUI.getWorkbench().getIntroManager().getIntro());
        }
    }

    protected void sleep(long i) throws InterruptedException {
        Display displ = Display.getCurrent();
        if (displ != null) {
            long timeToGo = System.currentTimeMillis() + i;
            while (System.currentTimeMillis() < timeToGo) {
                if (displ.readAndDispatch()) continue;
                displ.sleep();
            }
            displ.update();
        } else {
            Thread.sleep(i);
        }
    }

    protected IWorkbenchPage getActivePage() {
        return this.getWorkbenchWindow().getActivePage();
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.getWorkbench().getActiveWorkbenchWindow();
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

