/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.ITypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeScopeProvider
extends AbstractScopeProvider {
    public IScope getScope(EObject context, EReference reference) {
        if (context.eResource() == null) {
            throw new IllegalStateException("context must be contained in a resource");
        }
        ResourceSet resourceSet = context.eResource().getResourceSet();
        if (resourceSet == null) {
            throw new IllegalStateException("context must be contained in a resource set");
        }
        EClass referenceType = reference.getEReferenceType();
        if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)referenceType)) {
            ITypeProvider typeProvider = this.getTypeProvider(resourceSet);
            return this.createTypeScope(typeProvider);
        }
        return IScope.NULLSCOPE;
    }

    public ITypeProvider getTypeProvider(ResourceSet resourceSet) {
        ITypeProvider typeProvider = this.getTypeProviderFactory().findTypeProvider(resourceSet);
        if (typeProvider == null) {
            typeProvider = this.getTypeProviderFactory().createTypeProvider(resourceSet);
        }
        return typeProvider;
    }

    public abstract AbstractTypeScope createTypeScope(ITypeProvider var1);

    public abstract ITypeProvider.Factory getTypeProviderFactory();

    public IScope createMemberScope(JvmType containerType, Predicate<JvmMember> filter, Function<JvmMember, String> names, IScope outer) {
        if (containerType == null || containerType.eIsProxy()) {
            return outer;
        }
        if (containerType instanceof JvmDeclaredType) {
            IScope result = outer;
            EList<JvmTypeReference> superTypes = ((JvmDeclaredType)containerType).getSuperTypes();
            for (JvmTypeReference superType : superTypes) {
                if (superType.getType() == null) continue;
                result = this.createMemberScope(superType.getType(), filter, names, result);
            }
            EList<JvmMember> members = ((JvmDeclaredType)containerType).getMembers();
            return Scopes.scopeFor((Iterable)Iterables.filter(members, filter), names, (IScope)result);
        }
        return outer;
    }
}

