/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;

public class ShortCutEditStrategy
implements IAutoEditStrategy,
ISourceViewerAware,
VerifyKeyListener {
    private String shortcut;
    private String longForm;
    private boolean matched = false;
    private ISourceViewer sourceViewer;

    public ShortCutEditStrategy configure(String shortcut, String replacement) {
        this.shortcut = shortcut;
        this.longForm = replacement;
        return this;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            this.matched = false;
            int shortCutIndex = this.shortcut.length() - 1;
            boolean isLastCharacterOfShortCut = command.text.equals(this.shortcut.substring(shortCutIndex));
            boolean isShortCut = document.get(command.offset - shortCutIndex, shortCutIndex).equals(this.shortcut.subSequence(0, shortCutIndex));
            if (isLastCharacterOfShortCut && isShortCut) {
                command.offset -= shortCutIndex;
                command.length = shortCutIndex;
                command.text = this.longForm;
                this.matched = true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        if (sourceViewer instanceof SourceViewer) {
            this.sourceViewer = sourceViewer;
        }
        ((SourceViewer)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this);
    }

    public void verifyKey(VerifyEvent event) {
        if (this.matched && event.keyCode == 27) {
            Point range = this.sourceViewer.getSelectedRange();
            try {
                this.sourceViewer.getDocument().replace(range.x - this.longForm.length(), this.longForm.length(), this.shortcut);
                this.sourceViewer.setSelectedRange(range.x - this.longForm.length() + this.shortcut.length(), 0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

