/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public abstract class AbstractNode
implements Node {
    private @NonNull NodeRole nodeRole;
    protected final @NonNull Region region;
    protected final @NonNull String name;
    private @Nullable NodeConnection incomingConnection = null;
    private @Nullable List<@NonNull Edge> incomingEdges = null;
    private @Nullable List<@NonNull NodeConnection> outgoingConnections = null;
    private @Nullable List<@NonNull Edge> outgoingEdges = null;
    private @NonNull ClassDatumAnalysis classDatumAnalysis;

    protected AbstractNode(@NonNull NodeRole nodeRole, @NonNull Region region, @NonNull String name, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        this.nodeRole = nodeRole;
        this.region = region;
        this.name = name;
        this.classDatumAnalysis = classDatumAnalysis;
        region.addNode(this);
    }

    @Override
    public void destroy() {
        List<Edge> outgoingEdges2;
        List<Edge> incomingEdges2;
        List<NodeConnection> outgoingConnections2;
        this.region.removeNode(this);
        NodeConnection incomingConnection2 = this.incomingConnection;
        if (incomingConnection2 != null) {
            incomingConnection2.destroy();
        }
        if ((outgoingConnections2 = this.outgoingConnections) != null) {
            while (!outgoingConnections2.isEmpty()) {
                outgoingConnections2.get(0).destroy();
            }
        }
        if ((incomingEdges2 = this.incomingEdges) != null) {
            while (!incomingEdges2.isEmpty()) {
                incomingEdges2.get(0).destroy();
            }
        }
        if ((outgoingEdges2 = this.outgoingEdges) != null) {
            while (!outgoingEdges2.isEmpty()) {
                outgoingEdges2.get(0).destroy();
            }
        }
    }

    @Override
    public final void addIncomingConnection(@NonNull NodeConnection connection) {
        assert (this.incomingConnection == null || this.incomingConnection == connection);
        assert (Iterables.contains(connection.getTargetNodes(), (Object)this));
        this.incomingConnection = connection;
    }

    @Override
    public final void addIncomingEdge(@NonNull Edge edge) {
        assert (edge.getTarget() == this);
        List<@NonNull Edge> incomingEdges2 = this.incomingEdges;
        if (incomingEdges2 == null) {
            this.incomingEdges = incomingEdges2 = new ArrayList<Edge>();
        } else assert (!incomingEdges2.contains(edge));
        incomingEdges2.add(edge);
    }

    @Override
    public final void addOutgoingConnection(@NonNull NodeConnection connection) {
        assert (Iterables.contains(connection.getSources(), (Object)this));
        List<@NonNull NodeConnection> outgoingConnections2 = this.outgoingConnections;
        if (outgoingConnections2 == null) {
            this.outgoingConnections = outgoingConnections2 = new ArrayList<NodeConnection>();
        } else assert (!outgoingConnections2.contains(connection));
        outgoingConnections2.add(connection);
    }

    @Override
    public final void addOutgoingEdge(@NonNull Edge edge) {
        assert (edge.getSource() == this);
        List<@NonNull Edge> outgoingEdges2 = this.outgoingEdges;
        if (outgoingEdges2 == null) {
            this.outgoingEdges = outgoingEdges2 = new ArrayList<Edge>();
        } else assert (!outgoingEdges2.contains(edge));
        outgoingEdges2.add(edge);
    }

    public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
        String style;
        boolean isHead = this.isHead();
        if (isHead) {
            s.setHead();
        }
        this.setLabel(s);
        String shape = this.getShape();
        if (shape != null) {
            s.setShape(shape);
        }
        if ((style = this.getStyle()) != null) {
            s.setStyle(style);
        }
        s.setColor(this.getColor());
        s.setPenwidth(this.getPenwidth());
        s.appendAttributedNode(nodeName);
    }

    @Override
    public void getAllAncestors(@NonNull Set<@NonNull Node> ancestors) {
        if (ancestors.add(this)) {
            Region region = this.getRegion();
            for (Node headNode : region.getHeadNodes()) {
                for (Node passedBindingSource : headNode.getPassedBindingSources()) {
                    passedBindingSource.getAllAncestors(ancestors);
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getArgumentEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getIncomingEdges(), (Predicate)AbstractRegion.IsExpressionEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public final @Nullable Edge getAssignmentEdge(@NonNull Property source2targetProperty) {
        for (Edge edge : this.getOutgoingEdges()) {
            if (!edge.isRealized() || !(edge instanceof NavigationEdge) || ((NavigationEdge)edge).getProperty() != source2targetProperty) continue;
            return edge;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NavigationEdge> getAssignmentEdges() {
        @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsAssignmentEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public final @NonNull ClassDatumAnalysis getClassDatumAnalysis() {
        return this.classDatumAnalysis;
    }

    protected @NonNull String getColor() {
        return this.nodeRole.getColor();
    }

    @Override
    public @NonNull CompleteClass getCompleteClass() {
        return this.classDatumAnalysis.getCompleteClass();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getComputationEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsComputationEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @NonNull String getDisplayName() {
        return String.valueOf(this.region.getName()) + "::" + this.getName();
    }

    @Override
    public final @Nullable NodeConnection getIncomingConnection() {
        return this.incomingConnection;
    }

    @Override
    public final @NonNull List<@NonNull Edge> getIncomingEdges() {
        return this.incomingEdges != null ? this.incomingEdges : SchedulerConstants.EMPTY_EDGE_LIST;
    }

    @Override
    public final @Nullable NodeConnection getIncomingPassedConnection() {
        NodeConnection incomingConnection2 = this.incomingConnection;
        if (incomingConnection2 != null && incomingConnection2.isPassed()) {
            return incomingConnection2;
        }
        return null;
    }

    @Override
    public @Nullable NodeConnection getIncomingUsedConnection() {
        NodeConnection incomingConnection2 = this.incomingConnection;
        if (incomingConnection2 != null && incomingConnection2.isUsed(this)) {
            return incomingConnection2;
        }
        return null;
    }

    @Override
    public @NonNull String getLabel() {
        return this.getName();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getMergeableEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsMergeableEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @Nullable NavigationEdge getNavigationEdge(@NonNull Property source2targetProperty) {
        for (Edge edge : this.getOutgoingEdges()) {
            NavigationEdge navigationEdge;
            if (!(edge instanceof NavigationEdge) || (navigationEdge = (NavigationEdge)edge).getProperty() != source2targetProperty) continue;
            return navigationEdge;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NavigationEdge> getNavigationEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsNavigationEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @Nullable Node getNavigationTarget(@NonNull Property source2targetProperty) {
        for (Edge edge : this.getOutgoingEdges()) {
            NavigationEdge navigationEdge;
            if (!(edge instanceof NavigationEdge) || (navigationEdge = (NavigationEdge)edge).getProperty() != source2targetProperty) continue;
            return navigationEdge.getTarget();
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull Node> getNavigationTargets() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsNavigationEdgePredicate.INSTANCE);
        @NonNull @NonNull Iterable transform = Iterables.transform((Iterable)filter, (Function)AbstractRegion.EdgeTargetFunction.INSTANCE);
        return transform;
    }

    @Override
    public @NonNull NodeRole getNodeRole() {
        return this.nodeRole;
    }

    @Override
    public final @NonNull List<@NonNull NodeConnection> getOutgoingConnections() {
        return this.outgoingConnections != null ? this.outgoingConnections : SchedulerConstants.EMPTY_NODE_CONNECTION_LIST;
    }

    @Override
    public final @NonNull List<@NonNull Edge> getOutgoingEdges() {
        return this.outgoingEdges != null ? this.outgoingEdges : SchedulerConstants.EMPTY_EDGE_LIST;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NodeConnection> getOutgoingPassedConnections() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingConnections(), (Predicate)RootScheduledRegion.IsPassedBindingEdgePredicate.INSTANCE);
        return filter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NodeConnection> getOutgoingUsedBindingEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingConnections(), (Predicate)RootScheduledRegion.IsUsedBindingEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getPassedBindingSources() {
        ArrayList<@NonNull Node> sources = new ArrayList<Node>();
        NodeConnection connection = this.getIncomingPassedConnection();
        if (connection != null) {
            for (Node source : connection.getSources()) {
                if (sources.contains(source)) continue;
                sources.add(source);
            }
        }
        return sources;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getPassedBindingTargets() {
        ArrayList<@NonNull Node> targets = new ArrayList<Node>();
        for (NodeConnection connection : this.getOutgoingPassedConnections()) {
            for (Node target : connection.getTargetNodes()) {
                if (targets.contains(target)) continue;
                targets.add(target);
            }
        }
        return targets;
    }

    protected @NonNull Integer getPenwidth() {
        return this.nodeRole.getPenwidth();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NavigationEdge> getPredicateEdges() {
        @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsPredicatedEdgePredicate.INSTANCE);
        return filter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getRecursionEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsRecursionEdgePredicate.INSTANCE);
        return filter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull Node> getRecursionSources() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getIncomingEdges(), (Predicate)AbstractRegion.IsRecursionEdgePredicate.INSTANCE);
        @NonNull @NonNull Iterable transform = Iterables.transform((Iterable)filter, (Function)AbstractRegion.EdgeSourceFunction.INSTANCE);
        return transform;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull Node> getRecursionTargets() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.getOutgoingEdges(), (Predicate)AbstractRegion.IsRecursionEdgePredicate.INSTANCE);
        @NonNull @NonNull Iterable transform = Iterables.transform((Iterable)filter, (Function)AbstractRegion.EdgeTargetFunction.INSTANCE);
        return transform;
    }

    @Override
    public @NonNull Region getRegion() {
        return this.region;
    }

    @Override
    public @NonNull SchedulerConstants getSchedulerConstants() {
        return this.region.getSchedulerConstants();
    }

    protected @Nullable String getShape() {
        return this.nodeRole.getShape();
    }

    protected @Nullable String getStyle() {
        return this.nodeRole.getStyle();
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getUsedBindingSources() {
        ArrayList<@NonNull Node> sources = new ArrayList<Node>();
        NodeConnection connection = this.getIncomingUsedConnection();
        if (connection != null) {
            for (Node source : connection.getSources()) {
                if (sources.contains(source)) continue;
                sources.add(source);
            }
        }
        return sources;
    }

    @Override
    public final boolean isAttributeNode() {
        boolean isAttributeNode2 = this.classDatumAnalysis.getClassDatum().getType() instanceof DataType && !this.isNull();
        return isAttributeNode2;
    }

    @Override
    public final boolean isClassNode() {
        boolean isClassNode2;
        boolean isClassNode1 = this.nodeRole.isClassNode();
        boolean bl = isClassNode2 = !(this.classDatumAnalysis.getClassDatum().getType() instanceof DataType) && !this.isNull();
        if (isClassNode1 != isClassNode2) {
            isClassNode1 = this.nodeRole.isClassNode();
            isClassNode2 = !(this.classDatumAnalysis.getClassDatum().getType() instanceof DataType) && !this.isNull();
        }
        return isClassNode2;
    }

    @Override
    public boolean isComposed() {
        return this.nodeRole.isComposed();
    }

    @Override
    public boolean isConstant() {
        return this.nodeRole.isConstant();
    }

    @Override
    public boolean isExpression() {
        return this.nodeRole.isExpression();
    }

    @Override
    public boolean isGuard() {
        return this.nodeRole.isGuardVariable() || this.nodeRole.isHead();
    }

    @Override
    public boolean isGuardVariable() {
        return this.nodeRole.isGuardVariable();
    }

    @Override
    public boolean isHead() {
        return this.nodeRole.isHead();
    }

    @Override
    public boolean isInternal() {
        return this.nodeRole.isInternal();
    }

    @Override
    public boolean isIterator() {
        return this.nodeRole.isIterator();
    }

    @Override
    public boolean isKnown() {
        return this.nodeRole.isConstant() || this.nodeRole.isLoaded();
    }

    @Override
    public boolean isLoaded() {
        return this.nodeRole.isLoaded();
    }

    @Override
    public boolean isMatchable() {
        return this.nodeRole.isMatchable();
    }

    @Override
    public boolean isNavigable() {
        return this.nodeRole.isNavigable();
    }

    @Override
    public boolean isNull() {
        return this.nodeRole.isNull();
    }

    @Override
    public boolean isOperation() {
        return this.nodeRole.isOperation();
    }

    @Override
    public boolean isPredicated() {
        return this.nodeRole.isPredicated();
    }

    @Override
    public boolean isRealized() {
        return this.nodeRole.isRealized();
    }

    @Override
    public boolean isRealizedVariable() {
        return this.nodeRole.isRealizedVariable();
    }

    @Override
    public boolean isResult() {
        return this.nodeRole.isResult();
    }

    @Override
    public boolean isTrue() {
        return this.nodeRole.isTrue();
    }

    public void mergeRole(@NonNull NodeRole nodeRole) {
        if (this.nodeRole != nodeRole) {
            this.nodeRole = this.nodeRole.merge(nodeRole);
        }
    }

    @Override
    public boolean refineClassDatumAnalysis(@NonNull ClassDatumAnalysis newClassDatumAnalysis) {
        CompleteClass newCompleteClass;
        CompleteClass oldCompleteClass = this.classDatumAnalysis.getCompleteClass();
        if (oldCompleteClass.conformsTo(newCompleteClass = newClassDatumAnalysis.getCompleteClass())) {
            RootDomainUsageAnalysis domainAnalysis = this.getSchedulerConstants().getDomainAnalysis();
            DomainUsage.Internal oldDomainUsage = (DomainUsage.Internal)this.classDatumAnalysis.getDomainUsage();
            DomainUsage.Internal newDomainUsage = (DomainUsage.Internal)newClassDatumAnalysis.getDomainUsage();
            int refinedBitMask = oldDomainUsage.getMask() & newDomainUsage.getMask();
            RootDomainUsageAnalysis.DomainUsageConstant refinedDomainUsage = domainAnalysis.getConstantUsage(refinedBitMask);
            TypedModel refinedTypedModel = refinedDomainUsage.getTypedModel((Element)oldCompleteClass);
            assert (refinedTypedModel != null);
            this.classDatumAnalysis = this.getSchedulerConstants().getClassDatumAnalysis(oldCompleteClass.getPrimaryClass(), refinedTypedModel);
            return true;
        }
        if (newCompleteClass.conformsTo(oldCompleteClass)) {
            RootDomainUsageAnalysis domainAnalysis = this.getSchedulerConstants().getDomainAnalysis();
            DomainUsage.Internal oldDomainUsage = (DomainUsage.Internal)this.classDatumAnalysis.getDomainUsage();
            DomainUsage.Internal newDomainUsage = (DomainUsage.Internal)newClassDatumAnalysis.getDomainUsage();
            int refinedBitMask = oldDomainUsage.getMask() & newDomainUsage.getMask();
            RootDomainUsageAnalysis.DomainUsageConstant refinedDomainUsage = domainAnalysis.getConstantUsage(refinedBitMask);
            TypedModel refinedTypedModel = refinedDomainUsage.getTypedModel((Element)newCompleteClass);
            assert (refinedTypedModel != null);
            this.classDatumAnalysis = this.getSchedulerConstants().getClassDatumAnalysis(newCompleteClass.getPrimaryClass(), refinedTypedModel);
            return true;
        }
        if (oldCompleteClass.getPrimaryClass().getESObject() == EcorePackage.Literals.EOBJECT) {
            this.classDatumAnalysis = newClassDatumAnalysis;
            return true;
        }
        return false;
    }

    @Override
    public final void removeIncomingConnection(@NonNull NodeConnection connection) {
        assert (Iterables.contains(connection.getTargetNodes(), (Object)this));
        assert (this.incomingConnection != null);
        this.incomingConnection = null;
    }

    @Override
    public final void removeIncomingEdge(@NonNull Edge edge) {
        assert (edge.getTarget() == this);
        List<Edge> incomingEdges2 = this.incomingEdges;
        assert (incomingEdges2 != null);
        boolean wasRemoved = incomingEdges2.remove(edge);
        assert (wasRemoved);
    }

    @Override
    public final void removeOutgoingConnection(@NonNull NodeConnection connection) {
        assert (Iterables.contains(connection.getSources(), (Object)this));
        List<NodeConnection> outgoingConnections2 = this.outgoingConnections;
        assert (outgoingConnections2 != null);
        boolean wasRemoved = outgoingConnections2.remove(connection);
    }

    @Override
    public final void removeOutgoingEdge(@NonNull Edge edge) {
        assert (edge.getSource() == this);
        List<Edge> outgoingEdges2 = this.outgoingEdges;
        assert (outgoingEdges2 != null);
        boolean wasRemoved = outgoingEdges2.remove(edge);
        assert (wasRemoved);
    }

    @Override
    public void setHead() {
        this.nodeRole = this.nodeRole.setHead();
    }

    public void setLabel(@NonNull GraphStringBuilder s) {
        StringBuilder n = new StringBuilder();
        n.append(this.getName());
        if (!(this.isExpression() || this.isNull() || this.isTrue())) {
            n.append("\\n");
            n.append(PrettyPrinter.printType((Element)this.getCompleteClass().getPrimaryClass()));
        }
        @NonNull String string = n.toString();
        s.setLabel(string);
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.appendNode((GraphStringBuilder.GraphNode)this);
    }

    public @NonNull String toString() {
        return String.valueOf(this.nodeRole.toString()) + "(" + this.getName() + " : " + this.classDatumAnalysis.toString() + ")";
    }

    public static final class NodeComparator
    implements Comparator<Node> {
        public static final @NonNull NodeComparator INSTANCE = new NodeComparator();

        @Override
        public int compare(@NonNull Node o1, @NonNull Node o2) {
            String n2;
            String n1 = NameUtil.getSafeName((Nameable)o1);
            int diff = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = NameUtil.getSafeName((Nameable)o2))));
            if (diff != 0) {
                return diff;
            }
            n1 = o1.getCompleteClass().getPrimaryClass().toString();
            diff = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = o2.getCompleteClass().getPrimaryClass().toString())));
            if (diff != 0) {
                return diff;
            }
            return diff;
        }
    }
}

