/*
 * Decompiled with CFR 0.152.
 */
package org.atl.engine.injectors.ebnf;

import antlr.CharScanner;
import antlr.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.m2m.atl.engine.injectors.Injector;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class EBNFInjector
implements Injector {
    private static final boolean debug = false;
    private static Map parameterTypes = new HashMap();
    private ASMModelElement root = null;
    private ASMModel extent;
    private Collection refSettings = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        parameterTypes.put("name", "String");
    }

    public Map getParameterTypes() {
        return parameterTypes;
    }

    public ASMModelElement inject(ASMModel target, InputStream source, Map params) throws IOException {
        this.performImportation(null, target, source, (String)params.get("name"));
        return this.root;
    }

    public String getPrefix() {
        return "ebnf";
    }

    public String getFormatMMName() {
        return "EBNF";
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other) throws IOException {
        this.extent = extent;
        try {
            String[] ss = other.split("-");
            String name = ss[0];
            String productionRule = "main";
            if (ss.length > 1) {
                productionRule = ss[1];
            }
            Class<?> lexer_ = Class.forName("org.mda.conv." + name + "Lexer");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.io.InputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            CharScanner lexer = (CharScanner)lexer_.getDeclaredConstructor(classArray).newInstance(in);
            Class<?> parser_ = Class.forName("org.mda.conv." + name + "Parser");
            Class[] classArray2 = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("antlr.TokenStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            Parser parser = (Parser)parser_.getDeclaredConstructor(classArray2).newInstance(lexer);
            Class[] classArray3 = new Class[1];
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.atl.engine.injectors.ebnf.EBNFInjector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray3[0] = clazz3;
            Method m = parser_.getMethod(productionRule, classArray3);
            try {
                this.root = (ASMModelElement)m.invoke((Object)parser, this);
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace(System.out);
            }
            Iterator i = this.refSettings.iterator();
            while (i.hasNext()) {
                RefSetting rs = (RefSetting)i.next();
                this.realSetRef(rs.o, rs.name, rs.type, rs.key, rs.keyValue, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public ASMModelElement create(String name) {
        ASMModelElement ret = null;
        ret = this.extent.newModelElement(name);
        return ret;
    }

    public void set(ASMModelElement ame, String prop, Object value) {
        if (value instanceof ASMModelElement) {
            ame.set(null, prop, (ASMOclAny)((ASMModelElement)value));
        } else if (value instanceof ASMSequence) {
            ame.set(null, prop, (ASMOclAny)((ASMSequence)value));
        } else if (value instanceof Integer) {
            ame.set(null, prop, (ASMOclAny)new ASMInteger(((Integer)value).intValue()));
        } else if (value instanceof Boolean) {
            ame.set(null, prop, (ASMOclAny)new ASMBoolean(((Boolean)value).booleanValue()));
        } else if (value instanceof String) {
            ame.set(null, prop, (ASMOclAny)new ASMString((String)value));
        } else if (value != null) {
            System.out.println("ERROR: unsupported type: " + value.getClass());
            new Exception().printStackTrace();
        }
    }

    public void setRef(ASMModelElement o, String name, String type, String key, String keyValue) {
        if (keyValue == null) {
            return;
        }
        this.realSetRef(o, name, type, key, keyValue, false);
    }

    private void realSetRef(ASMModelElement o, String name, String type, String key, String keyValue, boolean retrying) {
        Iterator i = this.extent.getElementsByType(type).iterator();
        while (i.hasNext()) {
            ASMModelElement ame = (ASMModelElement)i.next();
            if (!ame.get(null, key).equals(new ASMString(keyValue))) continue;
            o.set(null, name, (ASMOclAny)ame);
            return;
        }
        if (!retrying) {
            this.refSettings.add(new RefSetting(o, name, type, key, keyValue));
        } else {
            ASMModelElement ro = this.create(type);
            ro.set(null, key, (ASMOclAny)new ASMString(keyValue));
            o.set(null, name, (ASMOclAny)ro);
        }
    }

    private class RefSetting {
        public ASMModelElement o;
        public String name;
        public String type;
        public String key;
        public String keyValue;

        public RefSetting(ASMModelElement o, String name, String type, String key, String keyValue) {
            this.o = o;
            this.name = name;
            this.type = type;
            this.key = key;
            this.keyValue = keyValue;
        }
    }
}

