/**
 * Copyright (c) 2010 Artem Tikhomirov and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (independent) - Initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package plugin;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import xpt.plugin.ActivatorImpl;

@Singleton
@SuppressWarnings("all")
public class Activator {
  @Inject
  private ActivatorImpl activatorImpl;

  public CharSequence className(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _activatorClassName = it.getActivatorClassName();
    _builder.append(_activatorClassName);
    return _builder;
  }

  public CharSequence packageName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getEditorGen().getEditor().getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  @MetaDef
  public CharSequence instanceAccess(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it.getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".getInstance()");
    return _builder;
  }

  @MetaDef
  public CharSequence preferenceHintAccess(final GenEditorGenerator it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it.getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".DIAGRAM_PREFERENCES_HINT");
    return _builder;
  }

  public CharSequence Main(final GenPlugin it) {
    StringConcatenation _builder = new StringConcatenation();
    Object _ActivatorImpl = this.activatorImpl.ActivatorImpl(it);
    _builder.append(_ActivatorImpl);
    return _builder;
  }
}
