/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.statemachine;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.sirius.uml.diagram.statemachine.ElementToRefresh;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtensionProvider;
import org.eclipse.sirius.diagram.description.DiagramDescription;

public class StateMachineRefreshExtensionProvider
implements IRefreshExtensionProvider {
    public boolean provides(DDiagram viewPoint) {
        DiagramDescription description = viewPoint.getDescription();
        String name = description.getName();
        return name.equals("StateMachineDiagram");
    }

    public IRefreshExtension getRefreshExtension(DDiagram viewPoint) {
        return new IRefreshExtension(){

            public void postRefresh(DDiagram dDiagram) {
                StateMachineRefreshExtensionProvider.this.manageRegionPresentation();
                StateMachineRefreshExtensionProvider.this.manageStatePresentation(dDiagram);
            }

            public void beforeRefresh(DDiagram dDiagram) {
                StateMachineRefreshExtensionProvider.this.registeredRegionPresentation(dDiagram);
            }
        };
    }

    private void manageRegionPresentation() {
        for (Map.Entry<DNodeContainer, ContainerLayout> entry : ElementToRefresh.map.entrySet()) {
            DNodeContainer key = entry.getKey();
            ContainerLayout value = entry.getValue();
            key.setChildrenPresentation(value);
        }
        ElementToRefresh.map.clear();
    }

    private void manageStatePresentation(DDiagram dDiagram) {
        DSemanticDiagram di = (DSemanticDiagram)dDiagram;
        EList diagramElements = di.getDiagramElements();
        for (DDiagramElement dDiagramElement : diagramElements) {
            if (!(dDiagramElement instanceof DNodeContainer) || !((DNodeContainer)dDiagramElement).getActualMapping().getName().equals("SMD_State")) continue;
            if (((DNodeContainer)dDiagramElement).getElements().size() == 0) {
                ((DNodeContainer)dDiagramElement).setChildrenPresentation(ContainerLayout.FREE_FORM);
                continue;
            }
            ((DNodeContainer)dDiagramElement).setChildrenPresentation(ContainerLayout.VERTICAL_STACK);
        }
    }

    private void registeredRegionPresentation(DDiagram dDiagram) {
        EList diagramElements = dDiagram.getDiagramElements();
        for (DDiagramElement dDiagramElement : diagramElements) {
            if (!(dDiagramElement instanceof DNodeContainer)) continue;
            ContainerLayout childrenPresentation = ((DNodeContainer)dDiagramElement).getChildrenPresentation();
            ElementToRefresh.map.put((DNodeContainer)dDiagramElement, childrenPresentation);
        }
    }
}

